/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.tabs.threads;

import com.jrockit.mc.common.IMCMethod;
import com.jrockit.mc.common.internal.MethodToolkit;
import com.jrockit.mc.common.parsing.Tokenizer;
import com.jrockit.mc.console.ui.messages.internal.Messages;
import com.jrockit.mc.console.ui.tabs.threads.MonitorInfoCompositeSupport;
import com.jrockit.mc.console.ui.tabs.threads.StackTraceElementCompositeSupport;
import com.jrockit.mc.console.ui.tabs.threads.ThreadInfoCompositeSupport;
import com.jrockit.mc.ui.model.fields.StringField;
import org.eclipse.osgi.util.NLS;

public class TraceMMXBeanMethodField
extends StringField {
    private static final String MESSAGE_PART_NON_NATIVE_METHOD = "";
    private static final String MESSAGE_PART_UNKNOWN_THREAD_ID = "?";
    private static final String UNKNOWN_COMPOSITE_SUPPORT_CLASS = "";
    private static final String MESSAGE_PART_UNKNOWN_THREAD_STATE = "?";
    private static final String THREAD_FORMAT_STRING = "{0} [{1}] ({2})";

    public TraceMMXBeanMethodField(int id) {
        super(id);
    }

    public String formatObject(Object element) {
        if (element instanceof StackTraceElementCompositeSupport) {
            return this.formatStackTraceElement((StackTraceElementCompositeSupport)element);
        }
        if (element instanceof MonitorInfoCompositeSupport) {
            MonitorInfoCompositeSupport mip = (MonitorInfoCompositeSupport)element;
            return mip.getClassName();
        }
        if (element instanceof ThreadInfoCompositeSupport) {
            ThreadInfoCompositeSupport tip = (ThreadInfoCompositeSupport)element;
            Object[] messages = new String[]{tip.getThreadName(), String.valueOf(tip.getThreadId()), tip.getThreadState()};
            if (messages[0] == null) {
                messages[0] = Messages.StackTraceLabelProvider_MESSAGE_PART_NAME_UNKNOWN_THREAD_NAME;
            }
            if (messages[1] == null) {
                messages[1] = "?";
            }
            if (messages[2] == null) {
                messages[2] = "?";
            }
            return NLS.bind((String)THREAD_FORMAT_STRING, (Object[])messages);
        }
        return "";
    }

    public String formatStackTraceElement(IMCMethod element) {
        String qualifiedName = MethodToolkit.formatQualifiedName((String)element.getPackageName(), (String)element.getClassName());
        Object[] messages = new String[]{qualifiedName != null ? qualifiedName : Messages.StackTraceLabelProvider_MESSAGE_PART_CLASS_NOT_AVAILABLE, element.getMethodName() != null ? element.getMethodName() : Messages.StackTraceLabelProvider_MESSAGE_PART_METHOD_NOT_AVAILABLE, element.getLineNumber() != null && element.getLineNumber() >= 0 ? String.valueOf(element.getLineNumber()) : Messages.StackTraceLabelProvider_MESSAGE_PART_LINE_NUMBER_NOT_AVAILABLE, element.getIsNative() != null && element.getIsNative() != false ? Messages.StackTraceLabelProvider_MESSAGE_PART_NATIVE_METHOD : ""};
        return NLS.bind((String)Messages.StackTraceLabelProvider_STACK_TRACE_FORMAT_STRING, (Object[])messages);
    }

    public Object parse(Tokenizer tokenizer) {
        return null;
    }
}

