/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.provider.bcel;

import com.jrockit.mc.flightrecorder.provider.EventType;
import com.jrockit.mc.flightrecorder.provider.Field;
import java.lang.reflect.Constructor;

public class BCELUtilities {
    private static final ClassLoader CLASS_LOADER = BCELUtilities.createEventClassLoader();
    static final String EVENT_CLASS_PREFIX = "com.jrockit.mc.flightrecorder.provider.bcel.BCELEvent";
    static final String FIELD_CLASS_PREFIX = "Field";
    static final String VALUE_FIELD_PREFIX = "value";
    static final String ARGUMENTS_VALUES_FIELD_NAME = "values";
    static final String FIELD_GET_VALUE_METHOD_NAME = "getValue";
    static final String CONSTRUCTOR_METHOD_NAME = "<init>";

    public static String createEventClassName(int fieldCount) {
        return EVENT_CLASS_PREFIX + fieldCount;
    }

    public static String createFieldClassName(int fieldCount, int fieldIndex) {
        if (fieldIndex >= fieldCount) {
            throw new IllegalArgumentException("Field index must be less than the field count.");
        }
        return String.valueOf(BCELUtilities.createEventClassName(fieldCount)) + FIELD_CLASS_PREFIX + fieldIndex;
    }

    public static Constructor<?> getEventConstructor(int fieldCount) {
        try {
            String eventClassName = BCELUtilities.createEventClassName(fieldCount);
            Class<?> c = CLASS_LOADER.loadClass(eventClassName);
            return c.getConstructors()[0];
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Field createField(EventType eventType, int fieldIndex, int fieldCount, String fieldId) {
        try {
            if (fieldId == null || fieldId.equals("")) {
                throw new IllegalArgumentException("Field identifier can't be " + (fieldId == null ? "null" : "empty"));
            }
            String fieldClassName = BCELUtilities.createFieldClassName(fieldCount, fieldIndex);
            Class<?> fieldClass = CLASS_LOADER.loadClass(fieldClassName);
            Object[] arguments = new Object[]{eventType, fieldId};
            return (Field)fieldClass.getConstructors()[0].newInstance(arguments);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ClassLoader createEventClassLoader() {
        try {
            Class<?> c = EventType.class.getClassLoader().loadClass("com.jrockit.mc.flightrecorder.provider.bcel.EventClassLoader");
            return (ClassLoader)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can't find BCEL class loader");
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Can't instantiate event class loader");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Can't access event class loader class");
        }
    }
}

