/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.provider;

import com.jrockit.mc.flightrecorder.provider.EventStorage;
import com.jrockit.mc.flightrecorder.provider.EventType;
import com.jrockit.mc.flightrecorder.provider.Repository;
import com.jrockit.mc.flightrecorder.provider.Track;
import com.jrockit.mc.flightrecorder.provider.TrackIterator;
import com.jrockit.mc.flightrecorder.provider.Values;
import com.jrockit.mc.flightrecorder.spi.EventOrder;
import com.jrockit.mc.flightrecorder.spi.Expansion;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventFilter;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.spi.ITrack;
import com.jrockit.mc.flightrecorder.spi.IValues;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.util.AlwaysTrueFilter;
import com.jrockit.mc.flightrecorder.util.OrderByStartTime;
import com.jrockit.mc.flightrecorder.util.PriorityIterator;
import com.jrockit.mc.flightrecorder.util.TimeRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class View
implements IView {
    private final Values m_values;
    private final Repository repo;
    private ITimeRange m_range = TimeRange.INFINITE_RANGE;
    private IEventFilter m_filter = AlwaysTrueFilter.getInstance();
    private EventOrder m_eventOrder = EventOrder.ANY;
    private Expansion expansion = Expansion.NORMAL;
    private Collection<ITrack> m_tracks;
    private Collection<IEventType> m_eventTypes;
    private Collection<EventStorage> storages;

    public View(Repository repo, Collection<EventStorage> storages) {
        this.repo = repo;
        this.storages = storages;
        this.m_values = new Values(this);
    }

    @Override
    public Collection<IEventType> getEventTypes() {
        return Collections.unmodifiableCollection(this.m_eventTypes == null ? this.repo.getEventTypes() : this.m_eventTypes);
    }

    @Override
    public Collection<ITrack> getTracks() {
        return Collections.unmodifiableCollection(this.m_tracks == null ? this.repo.getTracks() : this.m_tracks);
    }

    @Override
    public void setEventTypes(Collection<IEventType> eventTypes) {
        this.m_eventTypes = eventTypes;
        Collection<EventStorage> etStorages = View.createEventTypeStorages(eventTypes);
        this.storages = this.m_tracks == null ? etStorages : this.intersect(etStorages, View.createTrackStorages(this.m_tracks));
    }

    @Override
    public void setTracks(Collection<ITrack> tracks) {
        this.m_tracks = tracks;
        Collection<EventStorage> trStorages = View.createTrackStorages(tracks);
        this.storages = this.m_eventTypes == null ? trStorages : this.intersect(View.createEventTypeStorages(this.m_eventTypes), trStorages);
    }

    private static Collection<EventStorage> createEventTypeStorages(Collection<IEventType> list) {
        ArrayList<EventStorage> storages = new ArrayList<EventStorage>();
        for (IEventType t : list) {
            storages.addAll(((EventType)t).getStorages());
        }
        return storages;
    }

    private static Collection<EventStorage> createTrackStorages(Collection<ITrack> list) {
        ArrayList<EventStorage> storages = new ArrayList<EventStorage>();
        for (ITrack t : list) {
            storages.addAll(((Track)t).getStorages());
        }
        return storages;
    }

    @Override
    public ITimeRange getRange() {
        return this.m_range;
    }

    @Override
    public void setOrder(EventOrder order) {
        this.m_eventOrder = order;
    }

    @Override
    public void setFilter(IEventFilter filter) {
        this.m_filter = filter;
    }

    @Override
    public void setRange(ITimeRange range) {
        this.m_range = range;
    }

    private List<EventStorage> intersect(Collection<EventStorage> eventStorages, Collection<EventStorage> trackStorages) {
        HashSet<EventStorage> trackSet = new HashSet<EventStorage>(trackStorages);
        ArrayList<EventStorage> list = new ArrayList<EventStorage>();
        for (EventStorage es : eventStorages) {
            if (!trackSet.contains(es)) continue;
            list.add(es);
        }
        return list;
    }

    @Override
    public Iterator<IEvent> iterator() {
        switch (this.m_eventOrder) {
            case ASCENDING: {
                ArrayList iterators = new ArrayList(this.storages.size());
                for (EventStorage storage : this.storages) {
                    iterators.add(storage.iterator(this.m_filter, this.m_range, this.expansion));
                }
                if (iterators.size() == 1) {
                    return (Iterator)iterators.get(0);
                }
                return new PriorityIterator<IEvent>(iterators, OrderByStartTime.getInstance());
            }
            case ANY: {
                if (this.storages.size() == 1) {
                    return this.storages.iterator().next().iterator(this.m_filter, this.m_range, this.expansion);
                }
                return new TrackIterator(this.storages, this.m_range, this.m_filter, this.expansion);
            }
        }
        throw new UnsupportedOperationException("Order " + (Object)((Object)this.m_eventOrder) + " currently not supported");
    }

    @Override
    public IEventFilter getFilter() {
        return this.m_filter;
    }

    @Override
    public EventOrder getOrder() {
        return this.m_eventOrder;
    }

    @Override
    public void setExpansion(Expansion expansion) {
        this.expansion = expansion;
    }

    public IValues<Object> getValues() {
        return this.m_values;
    }

    @Override
    public IView copy() {
        View view = new View(this.repo, this.storages);
        view.m_tracks = this.m_tracks;
        view.m_eventTypes = this.m_eventTypes;
        view.expansion = this.expansion;
        view.m_eventOrder = this.m_eventOrder;
        view.m_filter = this.m_filter;
        view.m_range = this.m_range;
        return view;
    }
}

