/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.parser.binary.IntegerParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.InvalidFlrFileException;

class Offset {
    private int offset;
    private final int offsetLimit;

    Offset(byte[] data, int startOffset) throws InvalidFlrFileException {
        int structSize = IntegerParser.readInt(data, startOffset);
        int structEnd = startOffset + structSize;
        if (structSize < 4 || structEnd > data.length) {
            throw new InvalidFlrFileException();
        }
        this.offset = startOffset + 4;
        this.offsetLimit = structEnd;
    }

    void increase(int amount) throws InvalidFlrFileException {
        if (amount < 0) {
            throw new InvalidFlrFileException();
        }
        int newOffset = this.offset + amount;
        if (newOffset > this.offsetLimit) {
            throw new InvalidFlrFileException();
        }
        this.offset = newOffset;
    }

    int get() {
        return this.offset;
    }

    int getEnd() {
        return this.offsetLimit;
    }
}

