/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.model.FLRThread;
import com.jrockit.mc.flightrecorder.internal.parser.binary.EventCollection;
import com.jrockit.mc.flightrecorder.internal.parser.binary.IEventHook;
import com.jrockit.mc.flightrecorder.internal.parser.binary.IParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.InvalidFlrFileException;
import com.jrockit.mc.flightrecorder.internal.parser.binary.Offset;
import com.jrockit.mc.flightrecorder.provider.EventType;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class EventParser {
    private final Object[] values;
    private final IEventFactory eventBuilder;
    private final IParser[] parsers;
    private final Map<FLRThread, EventCollection> events = new HashMap<FLRThread, EventCollection>();
    private IEventHook[] eventHooks;
    private final EventType eventType;

    public EventParser(EventType eventType, IEventFactory eventBuilder, IParser[] valueParsers) {
        this.parsers = valueParsers;
        this.values = new Object[valueParsers.length];
        this.eventBuilder = eventBuilder;
        this.eventType = eventType;
    }

    void loadEvent(byte[] data, Offset offset, long startTime, long endTime) throws InvalidFlrFileException {
        FLRThread thread;
        int n = 0;
        while (n < this.parsers.length) {
            this.values[n] = this.parsers[n].read(data, offset);
            ++n;
        }
        IEvent event = this.eventBuilder.createEvent(startTime, endTime, this.eventType, this.values);
        Integer threadValueIndex = this.getEventType().getThreadValueIndex();
        FLRThread fLRThread = thread = threadValueIndex != null ? (FLRThread)this.values[threadValueIndex] : null;
        if (this.eventHooks != null) {
            IEventHook[] iEventHookArray = this.eventHooks;
            int n2 = this.eventHooks.length;
            int n3 = 0;
            while (n3 < n2) {
                IEventHook hook = iEventHookArray[n3];
                List<IEventHook.IEventThreadPair> additionalEvents = hook.handleEvent(event, thread);
                if (additionalEvents != null) {
                    for (IEventHook.IEventThreadPair pair : additionalEvents) {
                        this.registerEvent(pair.getEvent(), pair.getThread());
                    }
                }
                ++n3;
            }
        }
        this.registerEvent(event, thread);
    }

    private void registerEvent(IEvent event, FLRThread thread) {
        EventCollection eventCollection = this.events.get(thread);
        if (eventCollection == null) {
            eventCollection = new EventCollection();
            this.events.put(thread, eventCollection);
        }
        eventCollection.add(event);
    }

    EventType getEventType() {
        return this.eventType;
    }

    Iterable<Map.Entry<FLRThread, EventCollection>> getLoadedEvents() {
        return this.events.entrySet();
    }

    void setEventHooks(IEventHook ... eventHooks) {
        this.eventHooks = eventHooks;
    }
}

