/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.fields;

import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.flightrecorder.internal.model.FLRFrame;
import com.jrockit.mc.flightrecorder.internal.model.FLRMethod;
import com.jrockit.mc.flightrecorder.internal.model.FLRStackTrace;
import com.jrockit.mc.flightrecorder.provider.Field;
import com.jrockit.mc.flightrecorder.spi.FieldType;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IField;

public final class TopFrameClassField
extends Field {
    private final IField m_field;

    public TopFrameClassField(IEventType type, String identifier, IField field) {
        super(type, "(" + identifier + ".class)");
        this.m_field = field;
        this.setName("Stacktrace (Top Frame : Class)");
        this.setDescription("The method in top of the stack");
        this.setFieldType(FieldType.OBJECT);
        this.setContentType(UnitLookup.CLASS.getIdentifier());
        this.setVisible(false);
        this.setSynthetic(true);
    }

    @Override
    public Object getValue(IEvent event) {
        FLRStackTrace s;
        FLRFrame topFrame;
        Object o = this.m_field.getValue(event);
        if (o instanceof FLRStackTrace && (topFrame = (s = (FLRStackTrace)o).getValidTopFrame()) != null) {
            return ((FLRMethod)topFrame.getMethod()).getType();
        }
        return null;
    }
}

