/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.attach;

import com.jrockit.mc.browser.attach.LocalJVMToolkit;
import com.jrockit.mc.browser.attach.Messages;
import com.jrockit.mc.browser.attach.RemoteJMXAgentWizardPage;
import com.jrockit.mc.rjmx.IServerHandle;
import com.jrockit.mc.rjmx.ServerToolkit;
import com.jrockit.mc.ui.misc.DialogToolkit;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class RemoteJMXAgentWizard
extends Wizard {
    private final IServerHandle serverHandle;

    public RemoteJMXAgentWizard(IServerHandle serverHandle) {
        this.serverHandle = serverHandle;
        this.setWindowTitle(Messages.RemoteJMXStarterAction_START_REMOTE_JMX_AGENT);
    }

    public void addPages() {
        this.addPage((IWizardPage)new RemoteJMXAgentWizardPage(this.serverHandle));
    }

    public boolean performFinish() {
        String command = ((RemoteJMXAgentWizardPage)this.getPage("browser.attach.management.agent.settings.wizard.page")).getCommand();
        if (command != null) {
            try {
                String pid = String.valueOf(ServerToolkit.getPid((IServerHandle)this.serverHandle));
                String result = LocalJVMToolkit.executeCommandForPid(pid, command);
                if (result.length() != 0) {
                    DialogToolkit.showWarning((Shell)this.getShell(), (String)Messages.RemoteJMXStarterAction_REMOTE_JMX_AGENT_RESULT_TITLE, (String)NLS.bind((String)Messages.RemoteJMXStarterAction_REMOTE_JMX_AGENT_RESULT_DESCRIPTION, (Object[])new String[]{ServerToolkit.getDisplayName((IServerHandle)this.serverHandle), command, result}));
                }
                return true;
            }
            catch (Throwable e) {
                DialogToolkit.showException((Shell)this.getShell(), (String)Messages.RemoteJMXStarterAction_REMOTE_JMX_AGENT_PROBLEM_TITLE, (String)NLS.bind((String)Messages.RemoteJMXStarterAction_REMOTE_JMX_AGENT_PROBLEM_DESCRIPTION, (Object)ServerToolkit.getDisplayName((IServerHandle)this.serverHandle), (Object)command), (Throwable)e);
            }
        }
        return false;
    }
}

