/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.unit;

import com.jrockit.mc.common.unit.DecimalPrefix;
import com.jrockit.mc.common.unit.IQuantity;
import com.jrockit.mc.common.unit.IScalarAffineTransform;
import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.KindOfQuantity;
import com.jrockit.mc.common.unit.LinearKindOfQuantity;
import com.jrockit.mc.common.unit.LinearUnit;
import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.common.unit.Timestamp;
import com.jrockit.mc.common.util.FormatThreadLocal;
import com.jrockit.mc.common.util.Messages;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class TimestampKind
extends KindOfQuantity<Timestamp> {
    private static final Pattern NUMBER_UNIT_PATTERN = Pattern.compile("^(-?\\d+)\\s*([a-zA-Z%]*)$");
    private static final FormatThreadLocal<DateFormat> DATE_FORMATTING_HOLDER;
    static TimestampUnit NANOS_UNIT;
    static TimestampUnit MILLIS_UNIT;
    static TimestampUnit SECONDS_UNIT;
    private static TimestampKind INSTANCE;

    static {
        DateFormat df = DateFormat.getDateTimeInstance(3, 2);
        if (df instanceof SimpleDateFormat) {
            SimpleDateFormat sdf = (SimpleDateFormat)df;
            String pattern = sdf.toPattern();
            String newPattern = pattern.replaceFirst("y{2,4}", "yyyy");
            sdf.applyPattern(newPattern);
        }
        DATE_FORMATTING_HOLDER = new FormatThreadLocal<DateFormat>(df);
    }

    static DateFormat getDateFormatter() {
        return (DateFormat)DATE_FORMATTING_HOLDER.get();
    }

    public static KindOfQuantity<Timestamp> buildContentType(LinearKindOfQuantity timespan) {
        NANOS_UNIT = new TimestampUnit(timespan.getUnit(DecimalPrefix.NANO));
        MILLIS_UNIT = new TimestampUnit(timespan.getUnit(DecimalPrefix.MILLI));
        SECONDS_UNIT = new TimestampUnit(timespan.getUnit(DecimalPrefix.NONE));
        INSTANCE = new TimestampKind();
        INSTANCE.addUnit(NANOS_UNIT);
        INSTANCE.addUnit(MILLIS_UNIT);
        INSTANCE.addUnit(SECONDS_UNIT);
        return INSTANCE;
    }

    private TimestampKind() {
        super("timestamp");
    }

    @Override
    public IUnit<Timestamp> getPreferredUnit(Timestamp value, double minNumericalValue, double maxNumericalValue) {
        return value.getUnit();
    }

    @Override
    public IUnit<Timestamp> getDefaultUnit() {
        return NANOS_UNIT;
    }

    @Override
    public Timestamp parsePersisted(String persistedQuantity) throws QuantityConversionException {
        Matcher m = NUMBER_UNIT_PATTERN.matcher(persistedQuantity.trim());
        if (m.matches()) {
            IUnit unit = this.getUnit(m.group(2));
            if (unit != null) {
                try {
                    return (Timestamp)unit.quantity(Long.parseLong(m.group(1)));
                }
                catch (RuntimeException runtimeException) {
                }
            } else {
                if (m.group(3).length() == 0) {
                    throw QuantityConversionException.noUnit(persistedQuantity, this.getDefaultUnit().quantity(1234.0));
                }
                throw QuantityConversionException.unknownUnit(persistedQuantity, this.getDefaultUnit().quantity(1234.0));
            }
        }
        throw QuantityConversionException.unparsable(persistedQuantity, this.getDefaultUnit().quantity(1234.0));
    }

    @Override
    public Timestamp parseInteractive(String interactiveQuantity) throws QuantityConversionException {
        try {
            DateFormat df = DateFormat.getDateTimeInstance(3, 2);
            ParsePosition pos = new ParsePosition(0);
            Date date = df.parse(interactiveQuantity, pos);
            if (date != null) {
                long time = date.getTime();
                String rest = interactiveQuantity.substring(pos.getIndex()).trim();
                if (!rest.isEmpty()) {
                    DecimalFormat format = new DecimalFormat();
                    format.setParseBigDecimal(true);
                    pos.setIndex(0);
                    BigDecimal bd = (BigDecimal)format.parse(rest, pos);
                    if (pos.getIndex() < rest.length()) {
                        throw QuantityConversionException.unparsable(interactiveQuantity, MILLIS_UNIT.quantity(System.currentTimeMillis()));
                    }
                    if (rest.length() > 10) {
                        throw new QuantityConversionException.Quantity(QuantityConversionException.Problem.TOO_SMALL_MAGNITUDE, interactiveQuantity, (IQuantity)NANOS_UNIT.quantity(1L));
                    }
                    if (rest.length() > 4) {
                        return new Timestamp(time * 1000000L + bd.multiply(BigDecimal.valueOf(1000000000L)).longValueExact(), NANOS_UNIT);
                    }
                    return new Timestamp(time + bd.multiply(BigDecimal.valueOf(1000L)).longValueExact(), MILLIS_UNIT);
                }
                return new Timestamp(time / 1000L, SECONDS_UNIT);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        throw QuantityConversionException.unparsable(interactiveQuantity, MILLIS_UNIT.quantity(System.currentTimeMillis()));
    }

    static class TimestampUnit
    implements IUnit<Timestamp> {
        private final LinearUnit timeOffsetUnit;
        private final String unitId;
        private final String unitDescription;

        private TimestampUnit(LinearUnit timeOffsetUnit) {
            this.timeOffsetUnit = timeOffsetUnit;
            this.unitId = "epoch" + timeOffsetUnit.getIdentifier();
            String multiplier = timeOffsetUnit.asWellKnownQuantity().displayUsing("exact");
            this.unitDescription = MessageFormat.format(Messages.getString("TimestampKind_SINCE_1970_MSG"), multiplier);
        }

        LinearUnit getLinearUnit() {
            return this.timeOffsetUnit;
        }

        @Override
        public KindOfQuantity<Timestamp> getContentType() {
            return INSTANCE;
        }

        @Override
        public Timestamp quantity(Number numericalValue) {
            return new Timestamp(numericalValue.longValue(), this);
        }

        @Override
        public Timestamp quantity(long numericalValue) {
            return new Timestamp(numericalValue, this);
        }

        @Override
        public Timestamp quantity(double numericalValue) {
            return new Timestamp((long)numericalValue, this);
        }

        @Override
        public IScalarAffineTransform valueTransformTo(IUnit<Timestamp> targetUnit) {
            if (targetUnit.getContentType() != this.getContentType()) {
                throw new IllegalArgumentException("Cannot convert from unit " + this + " into unit of type " + targetUnit.getContentType().getIdentifier());
            }
            return this.timeOffsetUnit.valueTransformTo(((TimestampUnit)targetUnit).timeOffsetUnit);
        }

        public String toString() {
            return this.getIdentifier();
        }

        @Override
        public String getIdentifier() {
            return this.unitId;
        }

        @Override
        public String getLocalizedSymbol() {
            return "";
        }

        @Override
        public String getAppendableSuffix(boolean useBreakingSpace) {
            return "";
        }

        @Override
        public String getLocalizedDescription() {
            return this.unitDescription;
        }

        @Override
        public String[] getAltLocalizedNames() {
            return IUnit.EMPTY_STRING_ARRAY;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof TimestampUnit) {
                TimestampUnit otherUnit = (TimestampUnit)other;
                return otherUnit.timeOffsetUnit.equals(this.timeOffsetUnit);
            }
            return false;
        }

        public int hashCode() {
            return this.timeOffsetUnit.hashCode();
        }
    }
}

