/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class ExceptionTableElement {
    private static long offsetOfStartPC;
    private static long offsetOfEndPC;
    private static long offsetOfHandlerPC;
    private static long offsetOfCatchTypeIndex;
    private OopHandle handle;
    private long offset;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("ExceptionTableElement");
        offsetOfStartPC = type.getCIntegerField("start_pc").getOffset();
        offsetOfEndPC = type.getCIntegerField("end_pc").getOffset();
        offsetOfHandlerPC = type.getCIntegerField("handler_pc").getOffset();
        offsetOfCatchTypeIndex = type.getCIntegerField("catch_type_index").getOffset();
    }

    public ExceptionTableElement(OopHandle handle, long offset) {
        this.handle = handle;
        this.offset = offset;
    }

    public int getStartPC() {
        return (int)this.handle.getCIntegerAt(this.offset + offsetOfStartPC, 2L, true);
    }

    public int getEndPC() {
        return (int)this.handle.getCIntegerAt(this.offset + offsetOfEndPC, 2L, true);
    }

    public int getHandlerPC() {
        return (int)this.handle.getCIntegerAt(this.offset + offsetOfHandlerPC, 2L, true);
    }

    public int getCatchTypeIndex() {
        return (int)this.handle.getCIntegerAt(this.offset + offsetOfCatchTypeIndex, 2L, true);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ExceptionTableElement.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

