/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import se.hirt.greychart.Selection;
import se.hirt.greychart.SelectionRenderer;

public final class HorizontalSelectionRenderer
implements SelectionRenderer {
    private final Rectangle m_renderedBounds;
    private final Number m_min;
    private final Number m_max;
    private final Number m_worldWidth;
    private Number m_worldStartX;
    private Number m_worldEndX;
    private Selection m_selection;
    private int m_selectedDeviceStart;
    private int m_selectedDeviceEnd;

    HorizontalSelectionRenderer(Rectangle rect, Number min, Number max) {
        this.m_renderedBounds = rect;
        this.m_min = min;
        this.m_max = max;
        if (this.hasValidRange()) {
            this.m_worldWidth = min instanceof Long && max instanceof Long ? (Number)(max.longValue() - min.longValue()) : (Number)(max.doubleValue() - min.doubleValue());
            if (this.m_worldWidth.doubleValue() < 0.0) {
                throw new IllegalArgumentException("Max must be larger or equal to min");
            }
        } else {
            this.m_worldWidth = null;
        }
    }

    private boolean hasValidRange() {
        return this.m_min != null && this.m_max != null;
    }

    boolean hasValidSelection(Selection selection) {
        if (selection.isFinished()) {
            return false;
        }
        if (selection.getStart() == null) {
            return false;
        }
        if (selection.getEnd() == null) {
            return false;
        }
        return Math.abs(selection.getStart().x - selection.getEnd().x) > 1;
    }

    public Number getSelectedWorldStartX() {
        return 0;
    }

    public Number getSelectedWorldEndX() {
        return 0;
    }

    @Override
    public void setSelection(Selection selection) {
        this.m_selection = selection;
        this.clearWorldCoordinates();
        if (this.hasValidSelection(selection)) {
            this.m_selectedDeviceStart = Math.max(this.m_renderedBounds.x, Math.min(this.m_selection.getStart().x, this.m_selection.getEnd().x));
            this.m_selectedDeviceEnd = Math.min(this.m_renderedBounds.x + this.m_renderedBounds.width, Math.max(this.m_selection.getStart().x, this.m_selection.getEnd().x));
            this.updateWorldCoordinates();
        }
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.hasValidSelection(this.m_selection)) {
            g.setXORMode(Color.black);
            g.fillRect(this.m_selectedDeviceStart, this.m_renderedBounds.y, this.m_selectedDeviceEnd - this.m_selectedDeviceStart, this.m_renderedBounds.height);
            g.setPaintMode();
        }
    }

    private void updateWorldCoordinates() {
        if (this.hasValidRange() && this.hasValidSelection(this.m_selection)) {
            if (this.m_min instanceof Long && this.m_max instanceof Long) {
                this.updateLongWorldCoordinates();
            } else {
                this.updateDoubleWorldCoordinates();
            }
        } else {
            this.clearWorldCoordinates();
        }
    }

    private void clearWorldCoordinates() {
        this.m_worldStartX = null;
        this.m_worldEndX = null;
    }

    private void updateDoubleWorldCoordinates() {
        double perPixel = this.m_worldWidth.doubleValue() / (double)this.m_renderedBounds.width;
        this.m_worldStartX = this.m_min.doubleValue() + (double)(this.m_selectedDeviceStart - this.m_renderedBounds.x) * perPixel;
        this.m_worldEndX = this.m_min.doubleValue() + (double)(this.m_selectedDeviceEnd - this.m_renderedBounds.x) * perPixel;
    }

    private void updateLongWorldCoordinates() {
        double perPixel = this.m_worldWidth.doubleValue() / (double)this.m_renderedBounds.width;
        this.m_worldStartX = this.m_min.longValue() + (long)((double)(this.m_selectedDeviceStart - this.m_renderedBounds.x) * perPixel);
        this.m_worldEndX = this.m_min.longValue() + (long)((double)(this.m_selectedDeviceEnd - this.m_renderedBounds.x) * perPixel);
    }

    @Override
    public Number getSelectedStartX() {
        return this.m_worldStartX;
    }

    @Override
    public Number getSelectedStartY() {
        return null;
    }

    @Override
    public Number getSelectedEndX() {
        return this.m_worldEndX;
    }

    @Override
    public Number getSelectedEndY() {
        return null;
    }

    @Override
    public boolean hasValidSelection() {
        return this.m_worldStartX != null && this.m_worldEndX != null;
    }
}

