/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.triggers.internal;

import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.triggers.ITrigger;
import com.jrockit.mc.rjmx.triggers.TriggerEvent;
import java.io.PrintWriter;

public final class NotificationToolkit {
    private NotificationToolkit() {
    }

    public static String prettyPrint(TriggerEvent e) {
        StringBuffer buf = new StringBuffer(200);
        if (e.wasTriggered()) {
            buf.append("A notification event has been triggered!\n\n");
        }
        if (e.wasRecovered()) {
            buf.append("Your notification has recovered!\n\n");
        }
        buf.append("Notification creation time was: " + e.getCreationTime() + '\n');
        buf.append("The notification source is: " + e.getConnectorSourceDescription() + '\n');
        buf.append("The notification rule is: " + e.getRule().getName() + '\n');
        buf.append("Type description:\n" + e.getRule().getTrigger().getAttributeDescriptor() + '\n');
        buf.append("Rule trigger condition: " + e.getRule().getTrigger().getValueEvaluator());
        if (e.getSustainTime() > 0) {
            buf.append(" for " + e.getRule().getTrigger().getSustainTime() + " seconds.\n");
            buf.append("The condition was met for " + e.getSustainTime() / 1000 + " seconds.\n");
        } else {
            buf.append("\nThe actual trigger value: " + e.getTriggerValue().toString());
        }
        return buf.toString();
    }

    public static void prettyPrint(PrintWriter writer, TriggerEvent e) {
        if (e.wasTriggered()) {
            writer.println("A notification event has been triggered!");
        }
        if (e.wasRecovered()) {
            writer.println("Your notification has recovered!");
        }
        writer.println("Notification creation time was: " + e.getCreationTime());
        writer.println("The notification source is: " + e.getConnectorSourceDescription());
        writer.println("The notification rule is: " + e.getRule().getName());
        writer.println("Type description:");
        writer.println(e.getSource().getServiceOrDummy(IMRIMetaDataService.class).getMetaData(e.getRule().getTrigger().getAttributeDescriptor()));
        writer.print("Rule trigger condition: " + e.getRule().getTrigger().getValueEvaluator());
        if (e.getSustainTime() > 0) {
            writer.println(" for " + e.getRule().getTrigger().getSustainTime() + " seconds.");
            writer.println("The condition was met for " + e.getSustainTime() / 1000 + " seconds.");
        } else {
            writer.println("\nThe actual trigger value: " + e.getTriggerValue().toString());
        }
        writer.println();
    }

    public static boolean isComplete(ITrigger trigger) {
        return trigger.getValueEvaluator() != null && trigger.getAttributeDescriptor() != null;
    }
}

