/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.triggers.actions.internal;

import com.jrockit.mc.common.debug.Debug;
import com.jrockit.mc.core.security.PersistentCredentials;
import com.jrockit.mc.core.security.SecurityException;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.triggers.TriggerAction;
import com.jrockit.mc.rjmx.triggers.TriggerEvent;
import com.jrockit.mc.rjmx.triggers.actions.internal.Messages;
import com.jrockit.mc.rjmx.triggers.internal.NotificationToolkit;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.eclipse.osgi.util.NLS;

public class TriggerActionMail
extends TriggerAction {
    public static final String XML_ELEMENT_EMAIL_FROM = "email_from";
    public static final String XML_ELEMENT_EMAIL_TO = "email_to";
    public static final String XML_ELEMENT_EMAIL_CC = "email_cc";
    private static final String MAILER = Messages.TriggerActionMail_MAIL_HEADER_MAILER;

    @Override
    public void handleNotificationEvent(TriggerEvent e) throws MessagingException {
        String subject = this.getSubject(e);
        this.sendEMail(subject, NotificationToolkit.prettyPrint(e));
    }

    public void sendEMail(String subject, String content) throws MessagingException {
        Properties props = new Properties();
        Session session = Session.getInstance((Properties)props, null);
        UserPassword credentials = this.getSmtpCredentials();
        URLName urlName = this.createURLName(credentials);
        session.setPasswordAuthentication(urlName, new PasswordAuthentication(credentials.getUser(), credentials.getPassword()));
        if (Debug.isDebug()) {
            session.setDebug(true);
        }
        MimeMessage msg = new MimeMessage(session);
        if (this.getFrom() != null && this.getFrom().length() > 0) {
            msg.setFrom((Address)new InternetAddress(this.getFrom()));
        }
        if (this.getTo() != null && this.getTo().length() > 0) {
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.getTo(), (boolean)false));
        }
        if (this.getCc() != null && this.getCc().length() > 0) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)this.getCc(), (boolean)false));
        }
        msg.setSubject(subject);
        msg.setText(content);
        msg.setHeader("X-Mailer", MAILER);
        msg.setSentDate(new Date());
        Transport transport = session.getTransport(urlName);
        transport.connect();
        transport.sendMessage((Message)msg, msg.getAllRecipients());
        transport.close();
    }

    private URLName createURLName(UserPassword credentials) {
        String protocol = this.getSmtpSSL() != false ? "smtps" : "smtp";
        return new URLName(protocol, this.getSmtpServer(), this.getSmtpPort().intValue(), null, credentials.getUser(), credentials.getPassword());
    }

    private String getSmtpServer() {
        return RJMXPlugin.getDefault().getRJMXPreferences().get("rjmx.smtp.server", "mail.example.com");
    }

    private UserPassword getSmtpCredentials() {
        try {
            UserPassword userPassword = this.getSecureSmtpCredentials();
            if (userPassword != null) {
                return userPassword;
            }
        }
        catch (SecurityException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not load SMTP credentials", e);
        }
        return new UserPassword("", "");
    }

    private UserPassword getSecureSmtpCredentials() throws SecurityException {
        String key = RJMXPlugin.getDefault().getRJMXPreferences().get("rjmx.smtp.server.credentials", "");
        if (key != null && !"".equals(key)) {
            PersistentCredentials credentials = new PersistentCredentials(key);
            return new UserPassword(credentials.getUsername(), credentials.getPassword());
        }
        return null;
    }

    private Integer getSmtpPort() {
        return RJMXPlugin.getDefault().getRJMXPreferences().getInt("rjmx.smtp.server.port", 25);
    }

    private Boolean getSmtpSSL() {
        return RJMXPlugin.getDefault().getRJMXPreferences().getBoolean("rjmx.smtp.server.secure", false);
    }

    private String getCc() {
        return this.getSetting(XML_ELEMENT_EMAIL_CC).getString();
    }

    private String getFrom() {
        return this.getSetting(XML_ELEMENT_EMAIL_FROM).getString();
    }

    private String getTo() {
        return this.getSetting(XML_ELEMENT_EMAIL_TO).getString();
    }

    private String getSubject(TriggerEvent e) {
        if (e.wasTriggered()) {
            return NLS.bind((String)Messages.TriggerActionMail_SUBJECT_TRIGGERED, (Object)e.getRule().getName());
        }
        if (e.wasRecovered()) {
            return NLS.bind((String)Messages.TriggerActionMail_SUBJECT_RECOVERED, (Object)e.getRule().getName());
        }
        return NLS.bind((String)Messages.TriggerActionMail_SUBJECT_INVOKED, (Object)e.getRule().getName());
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "{From: " + this.getFrom() + "\nTo: " + this.getTo() + "\nSMTP: " + this.getSmtpServer() + '}';
    }

    @Override
    public boolean isReady() {
        try {
            this.getSecureSmtpCredentials();
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }

    private static class UserPassword {
        private final String user;
        private final String password;

        private UserPassword(String user, String password) {
            this.user = user;
            this.password = password;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

