/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.internal.DefaultConnectionHandle;
import com.jrockit.mc.rjmx.services.ITimingService;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.subscription.MRI;
import java.io.IOException;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.ReflectionException;

public class DefaultTimingService
implements ITimingService {
    private final DefaultConnectionHandle connectionHandle;

    public DefaultTimingService(IConnectionHandle handle) {
        this.connectionHandle = (DefaultConnectionHandle)handle;
    }

    @Override
    public long getRemoteStartTime() throws IOException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        Object val;
        IMBeanHelperService service = this.connectionHandle.getServiceOrDummy(IMBeanHelperService.class);
        try {
            val = service.getAttribute(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=Runtime", "StartTime")).getValue();
        }
        catch (JMException e) {
            return 0L;
        }
        return ((Number)val).longValue();
    }

    @Override
    public double getTicksPerSecond() throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Ticks per second is not supported on the platform");
    }

    @Override
    public boolean isTicksSupported() {
        return false;
    }

    @Override
    public long getApproximateServerTime() {
        return this.connectionHandle.getApproximateServerTime(System.currentTimeMillis());
    }

    @Override
    public long getUptime() throws IOException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        Object val;
        IMBeanHelperService service = this.connectionHandle.getServiceOrDummy(IMBeanHelperService.class);
        try {
            val = service.getAttribute(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=Runtime", "Uptime")).getValue();
        }
        catch (JMException e) {
            return 0L;
        }
        return ((Number)val).longValue();
    }
}

