/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import sun.misc.BASE64Decoder;
import sun.misc.JavaUtilJarAccess;
import sun.misc.SharedSecrets;
import sun.security.action.OpenFileInputStreamAction;
import sun.security.util.BitArray;

public final class BlackList {
    private static BlackList INSTANCE = null;
    private static final String DIGEST_MANIFEST = "-DIGEST-MANIFEST";
    private static final String CACHE_VERSION = "v2";
    private static final int BITLEN = 65536;
    private static final int WORDLEN = 2;
    private static final int NEED_CREATE = 0;
    private static final int NEED_LOAD = 1;
    private static final int IN_MEMORY = 2;
    private static final String[] stateStrings = new String[]{"NEED_CREATE", "NEED_LOAD", "IN_MEMORY"};
    private List rawBlacklistFiles;
    private Cache cachedBlacklistFile;
    private SmartBitArray cache;
    private long lastModified;
    private boolean isEmpty;
    private int state;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$util$jar$Attributes;

    private static BlackList createDefaultInstance() {
        BlackList blackList = null;
        if (Config.getBooleanProperty("deployment.security.blacklist.check") && Config.isJavaVersionAtLeast14() && Config.checkClassName("sun.security.action.OpenFileInputStreamAction")) {
            Trace.msgSecurityPrintln("downloadengine.check.blacklist.enabled");
            blackList = new BlackList(false);
        }
        if (blackList == null) {
            blackList = new BlackList(true);
        }
        return blackList;
    }

    public static synchronized BlackList getInstance() {
        if (INSTANCE == null) {
            INSTANCE = BlackList.createDefaultInstance();
        }
        return INSTANCE;
    }

    static String getCachePath() {
        return BlackList.getInstance().cachedBlacklistFile.file.getPath();
    }

    private BlackList(boolean bl) {
        this.isEmpty = bl;
        if (bl) {
            this.lastModified = 0L;
        } else {
            String string = Config.getDynamicBlacklistFile();
            String string2 = Config.getSystemBlacklistFile();
            String string3 = Config.getUserBlacklistFile();
            this.rawBlacklistFiles = new ArrayList();
            this.rawBlacklistFiles.add(new File(string));
            this.rawBlacklistFiles.add(new File(string2));
            this.rawBlacklistFiles.add(new File(string3));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(CACHE_VERSION).append('|');
            Iterator iterator = this.rawBlacklistFiles.iterator();
            boolean bl2 = false;
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                stringBuilder.append(file.getPath()).append('|');
                long l = file.lastModified();
                if (l != 0L) {
                    bl2 = true;
                }
                stringBuilder.append(l).append('|');
            }
            if (!bl2) {
                this.isEmpty = true;
                this.lastModified = 0L;
                Trace.println("blacklist: no raw file", TraceLevel.SECURITY);
                return;
            }
            this.cachedBlacklistFile = new Cache(stringBuilder.toString().hashCode());
            if (this.cachedBlacklistFile.exists()) {
                this.state = 1;
                this.lastModified = this.cachedBlacklistFile.lastModified();
            } else {
                this.state = 0;
                this.lastModified = new Date().getTime();
            }
        }
        Trace.println("blacklist: created: " + stateStrings[this.state] + ", lastModified: " + this.lastModified, TraceLevel.SECURITY);
    }

    public synchronized boolean contains(String string, String string2) {
        if (this.isEmpty) {
            return false;
        }
        Trace.println("blacklist: check contains " + string2 + ", state now " + stateStrings[this.state], TraceLevel.SECURITY);
        if (this.state == 0) {
            return this.checkInRaw(string, string2, true);
        }
        try {
            if (this.state == 1) {
                this.cache = this.cachedBlacklistFile.loadCache();
                this.state = 2;
            }
        }
        catch (IOException iOException) {
            return this.checkInRaw(string, string2, true);
        }
        boolean bl = this.checkInCache(string2);
        Trace.println("blacklist: " + (bl ? "" : "not ") + " found in cache", TraceLevel.SECURITY);
        if (bl) {
            return this.checkInRaw(string, string2, false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateCache() {
        BlackList blackList = BlackList.getInstance();
        if (blackList.state == 0) {
            BlackList blackList2 = blackList;
            synchronized (blackList2) {
                blackList.checkInRaw(null, null, true);
            }
            return true;
        }
        return false;
    }

    private boolean checkInCache(String string) {
        byte[] byArray = BlackList.debase64(string);
        if (byArray.length == 0) {
            return false;
        }
        int n = 0;
        while (n + 2 <= byArray.length) {
            int n2 = 0;
            for (int i = 0; i < 2; ++i) {
                n2 <<= 8;
                n2 |= byArray[n + i] & 0xFF;
            }
            if (!this.cache.get(n2)) {
                return false;
            }
            n += 2;
        }
        return true;
    }

    private boolean checkInRaw(String string, String string2, boolean bl) {
        if (bl) {
            this.cache = new SmartBitArray(65536);
        }
        Iterator iterator = this.rawBlacklistFiles.iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (bl2) {
                this.checkInOneRaw(file, null, null, true);
                Trace.println("blacklist: read raw " + file, TraceLevel.SECURITY);
            } else {
                bl2 = this.checkInOneRaw(file, string, string2, bl);
                Trace.println("blacklist: check raw " + file + ", " + bl2, TraceLevel.SECURITY);
            }
            if (!bl2 || bl) continue;
            return true;
        }
        if (bl) {
            this.saveCache();
        }
        return bl2;
    }

    private void saveCache() {
        if (this.cache.isEmpty()) {
            this.isEmpty = true;
            Trace.println("blacklist: raw files are all empty", TraceLevel.SECURITY);
            this.cachedBlacklistFile.delete();
        } else {
            this.cachedBlacklistFile.save(this.cache);
        }
        this.state = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkInOneRaw(File var1_1, String var2_2, String var3_3, boolean var4_4) {
        if (!var1_1.exists()) {
            return false;
        }
        var5_5 = null;
        var6_6 = false;
        try {
            var7_7 = AccessController.doPrivileged(new OpenFileInputStreamAction(var1_1));
            var5_5 = new BufferedReader(new InputStreamReader(var7_7));
            var8_10 = new StreamTokenizer(var5_5);
            this.setupTokenizer(var8_10);
            while ((var9_11 = var8_10.nextToken()) != -1) {
                block17: {
                    if (var9_11 == 10) continue;
                    if (var9_11 != -3) {
                        throw new IOException("Unexpected token: " + var8_10);
                    }
                    var10_12 = var8_10.sval;
                    if (var10_12.toUpperCase(Locale.ENGLISH).endsWith("-DIGEST-MANIFEST") == false) throw new IOException("Unknown attribute `" + var10_12 + "', line " + var8_10.lineno());
                    var11_13 = var8_10.sval;
                    this.parseColon(var8_10);
                    var12_14 = null;
                    var8_10.wordChars(61, 61);
                    var9_11 = var8_10.nextToken();
                    if (var9_11 != -3) {
                        throw new IOException("Unexpected value: " + var8_10);
                    }
                    var8_10.ordinaryChar(61);
                    var12_14 = var8_10.sval;
                    if (var12_14 == null) {
                        throw new IOException("hash must be specified");
                    }
                    if (!var12_14.equals(var3_3) || !var11_13.equalsIgnoreCase(var2_2)) break block17;
                    var6_6 = true;
                    if (var4_4) break block17;
                    var13_15 = var6_6;
                    var15_16 = null;
                    if (var5_5 == null) return var13_15;
                    ** GOTO lbl73
                }
                if (!var4_4) continue;
                this.encode(var12_14);
            }
            ** GOTO lbl79
        }
        catch (PrivilegedActionException var7_8) {
            Trace.println("blacklist: PrivilegedActionException: " + var7_8, TraceLevel.SECURITY);
            var15_18 = null;
            if (var5_5 == null) return var6_6;
            try {
                var5_5.close();
                return var6_6;
            }
            catch (IOException var16_23) {
                Trace.println("blacklist: Cannot close reader for " + var1_1, TraceLevel.SECURITY);
                return var6_6;
            }
        }
        catch (IOException var7_9) {
            Trace.println("blacklist: " + var7_9, TraceLevel.SECURITY);
            var15_19 = null;
            if (var5_5 == null) return var6_6;
            try {}
            catch (IOException var16_24) {
                Trace.println("blacklist: Cannot close reader for " + var1_1, TraceLevel.SECURITY);
                return var6_6;
            }
            var5_5.close();
            return var6_6;
        }
        {
            catch (Throwable var14_26) {
                var15_20 = null;
                if (var5_5 == null) throw var14_26;
                ** try [egrp 2[TRYBLOCK] [9 : 429->437)] { 
lbl68:
                // 1 sources

                var5_5.close();
                throw var14_26;
lbl70:
                // 1 sources

                catch (IOException var16_25) {
                    Trace.println("blacklist: Cannot close reader for " + var1_1, TraceLevel.SECURITY);
                }
                throw var14_26;
            }
lbl73:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [9 : 429->437)] { 
lbl74:
            // 1 sources

            var5_5.close();
            return var13_15;
lbl76:
            // 1 sources

            catch (IOException var16_21) {
                Trace.println("blacklist: Cannot close reader for " + var1_1, TraceLevel.SECURITY);
            }
            return var13_15;
lbl79:
            // 1 sources

            var15_17 = null;
            if (var5_5 == null) return var6_6;
            try {}
            catch (IOException var16_22) {}
            Trace.println("blacklist: Cannot close reader for " + var1_1, TraceLevel.SECURITY);
            return var6_6;
            var5_5.close();
            return var6_6;
        }
    }

    private void encode(String string) {
        byte[] byArray = BlackList.debase64(string);
        int n = 0;
        while (n + 2 <= byArray.length) {
            int n2 = 0;
            for (int i = 0; i < 2; ++i) {
                n2 <<= 8;
                n2 |= byArray[n + i] & 0xFF;
            }
            this.cache.set(n2, true);
            n += 2;
        }
    }

    private static byte[] debase64(String string) {
        try {
            return new BASE64Decoder().decodeBuffer(string);
        }
        catch (IOException iOException) {
            Trace.println("blacklist: Cannot decode " + string, TraceLevel.SECURITY);
            return new byte[0];
        }
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    private void setupTokenizer(StreamTokenizer streamTokenizer) {
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(97, 122);
        streamTokenizer.wordChars(65, 90);
        streamTokenizer.wordChars(48, 57);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(43, 43);
        streamTokenizer.wordChars(47, 47);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.commentChar(35);
        streamTokenizer.eolIsSignificant(true);
    }

    private void parseColon(StreamTokenizer streamTokenizer) throws IOException {
        int n = streamTokenizer.nextToken();
        if (n != 58) {
            throw new IOException("Expected ':', read " + streamTokenizer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Attributes readAttributes(JarFile jarFile, JarEntry jarEntry) throws IOException {
        Attributes attributes;
        final InputStream inputStream = jarFile.getInputStream(jarEntry);
        try {
            Object t = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Object object;
                    Attributes attributes = new Attributes();
                    Class<?> clazz = Class.forName("java.util.jar.Manifest$FastInputStream");
                    Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
                    Constructor<?> constructor = null;
                    for (int i = 0; i < constructorArray.length; ++i) {
                        object = constructorArray[i].getParameterTypes();
                        if (((Class<?>[])object).length != 1 || object[0] != (class$java$io$InputStream == null ? BlackList.class$("java.io.InputStream") : class$java$io$InputStream)) continue;
                        constructor = constructorArray[i];
                        break;
                    }
                    if (constructor == null) {
                        throw new Exception("Failed to find stream constructor");
                    }
                    constructor.setAccessible(true);
                    Object[] objectArray = new Object[]{inputStream};
                    object = constructor.newInstance(objectArray);
                    byte[] byArray = new byte[512];
                    Class[] classArray = new Class[]{clazz, byArray.getClass()};
                    Method method = (class$java$util$jar$Attributes == null ? (class$java$util$jar$Attributes = BlackList.class$("java.util.jar.Attributes")) : class$java$util$jar$Attributes).getDeclaredMethod("read", classArray);
                    if (method != null) {
                        method.setAccessible(true);
                        Object[] objectArray2 = new Object[]{object, byArray};
                        method.invoke((Object)attributes, objectArray2);
                    }
                    return attributes;
                }
            });
            attributes = (Attributes)t;
            Object var6_7 = null;
        }
        catch (Exception exception) {
            Attributes attributes2;
            try {
                attributes2 = jarEntry.getAttributes();
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return attributes2;
        }
        inputStream.close();
        return attributes;
    }

    public boolean checkJarEntry(JarFile jarFile, JarEntry jarEntry) throws IOException, GeneralSecurityException {
        if (this.isEmpty() || jarEntry == null) {
            return true;
        }
        if (!jarEntry.getName().toUpperCase(Locale.ENGLISH).endsWith(".SF")) {
            return false;
        }
        Attributes attributes = BlackList.readAttributes(jarFile, jarEntry);
        if (attributes == null) {
            return false;
        }
        Iterator<Object> iterator = attributes.keySet().iterator();
        while (iterator.hasNext()) {
            Attributes.Name name;
            String string;
            String string2 = iterator.next().toString();
            if (!string2.toUpperCase(Locale.ENGLISH).endsWith(DIGEST_MANIFEST) || !INSTANCE.contains(string2, string = attributes.getValue(name = new Attributes.Name(string2)))) continue;
            Trace.msgSecurityPrintln("downloadengine.check.blacklist.found", new Object[]{jarFile.getName()});
            throw new GeneralSecurityException("blacklisted entry!");
        }
        Trace.msgSecurityPrintln("downloadengine.check.blacklist.notfound");
        return false;
    }

    public boolean checkJarFile(JarFile jarFile) throws IOException {
        if (this.isEmpty()) {
            Trace.msgSecurityPrintln("downloadengine.check.blacklist.notexist");
            return false;
        }
        List list = BlackList.getManifestDigests(jarFile);
        if (list != null && list.size() > 0) {
            try {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string;
                    String string2 = (String)iterator.next();
                    if (!INSTANCE.contains(string2, string = (String)iterator.next())) continue;
                    Trace.msgSecurityPrintln("downloadengine.check.blacklist.found", new Object[]{jarFile.getName()});
                    return true;
                }
                return false;
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.getName().toUpperCase(Locale.ENGLISH);
            if (!string.startsWith("META-INF/") && !string.startsWith("/META-INF/")) continue;
            try {
                if (!this.checkJarEntry(jarFile, jarEntry)) continue;
                return false;
            }
            catch (GeneralSecurityException generalSecurityException) {
                return true;
            }
        }
        Trace.msgSecurityPrintln("downloadengine.check.blacklist.notsigned");
        return false;
    }

    public boolean hasBeenModifiedSince(long l) {
        Trace.println("blacklist: hasBeenModifiedSince " + l + " (we have " + this.lastModified + ")", TraceLevel.SECURITY);
        return this.lastModified >= l;
    }

    private static List getManifestDigests(JarFile jarFile) {
        try {
            JavaUtilJarAccess javaUtilJarAccess = SharedSecrets.javaUtilJarAccess();
            return javaUtilJarAccess.getManifestDigests(jarFile);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Cache {
        File file;
        int signature;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        Cache(int n) {
            boolean bl;
            block13: {
                FileInputStream fileInputStream;
                block12: {
                    this.file = new File(Config.getSecurityCacheDir(), "blacklist.cache");
                    this.signature = n;
                    fileInputStream = null;
                    bl = false;
                    fileInputStream = new FileInputStream(this.file);
                    if (new DataInputStream(fileInputStream).readInt() == n) break block12;
                    bl = true;
                }
                Object var6_4 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    break block13;
                }
                catch (Exception exception) {
                    Trace.println("blacklist: Cannot close " + this.file, TraceLevel.SECURITY);
                }
                break block13;
                {
                    catch (IOException iOException) {
                        bl = true;
                        Object var6_5 = null;
                        try {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                            break block13;
                        }
                        catch (Exception exception) {
                            Trace.println("blacklist: Cannot close " + this.file, TraceLevel.SECURITY);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    catch (Exception exception) {
                        Trace.println("blacklist: Cannot close " + this.file, TraceLevel.SECURITY);
                    }
                    throw throwable;
                }
            }
            if (bl) {
                Trace.println("blacklist: Reconstruct cache", TraceLevel.SECURITY);
                this.file.delete();
            }
        }

        long lastModified() {
            return this.file.lastModified();
        }

        boolean exists() {
            return this.file.exists();
        }

        void delete() {
            this.file.delete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        SmartBitArray loadCache() throws IOException {
            Trace.println("blacklist: loadCache", TraceLevel.SECURITY);
            byte[] byArray = new byte[8192];
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(this.file);
                fileInputStream.read(byArray, 0, 4);
                fileInputStream.read(byArray);
                Object var4_3 = null;
                if (fileInputStream == null) return new SmartBitArray(65536, byArray);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (fileInputStream == null) throw throwable;
                fileInputStream.close();
                throw throwable;
            }
            fileInputStream.close();
            return new SmartBitArray(65536, byArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void save(SmartBitArray smartBitArray) {
            Trace.println("blacklist: save cache to " + this.file, TraceLevel.SECURITY);
            FileOutputStream fileOutputStream = null;
            new File(Config.getSecurityCacheDir()).mkdir();
            fileOutputStream = new FileOutputStream(this.file);
            new DataOutputStream(fileOutputStream).writeInt(this.signature);
            fileOutputStream.write(smartBitArray.toByteArray());
            Object var6_3 = null;
            if (fileOutputStream == null) return;
            try {
                fileOutputStream.close();
                return;
            }
            catch (IOException iOException) {}
            return;
            {
                catch (IOException iOException) {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException2) {
                            Trace.println("blacklist: Cannot close " + this.file, TraceLevel.SECURITY);
                        }
                        fileOutputStream = null;
                    }
                    this.file.delete();
                    Trace.println("blacklist: Cannot save cache", TraceLevel.SECURITY);
                    Object var6_4 = null;
                    if (fileOutputStream == null) return;
                    try {
                        fileOutputStream.close();
                        return;
                    }
                    catch (IOException iOException3) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (fileOutputStream == null) throw throwable;
                try {
                    fileOutputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private static class SmartBitArray
    extends BitArray {
        private boolean isEmpty = true;

        SmartBitArray(int n) {
            super(n);
        }

        SmartBitArray(int n, byte[] byArray) {
            super(n, byArray);
            this.isEmpty = false;
        }

        public void set(int n, boolean bl) throws ArrayIndexOutOfBoundsException {
            super.set(n, bl);
            this.isEmpty = false;
        }

        boolean isEmpty() {
            return this.isEmpty;
        }
    }
}

