/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import sun.awt.FontConfiguration;
import sun.awt.Win32GraphicsEnvironment;
import sun.awt.windows.WFontConfiguration;
import sun.font.SunFontManager;
import sun.font.TrueTypeFont;

public class Win32FontManager
extends SunFontManager {
    private static String[] defaultPlatformFont = null;
    private static TrueTypeFont eudcFont;
    static String fontsForPrinting;

    private static native String getEUDCFontFile();

    @Override
    public TrueTypeFont getEUDCFont() {
        return eudcFont;
    }

    public Win32FontManager() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Win32FontManager.this.registerJREFontsWithPlatform(SunFontManager.jreFontDirName);
                return null;
            }
        });
    }

    @Override
    protected boolean useAbsoluteFontFileNames() {
        return false;
    }

    @Override
    protected void registerFontFile(String string, String[] stringArray, int n, boolean bl) {
        int n2;
        if (this.registeredFontFiles.contains(string)) {
            return;
        }
        this.registeredFontFiles.add(string);
        if (this.getTrueTypeFilter().accept(null, string)) {
            n2 = 0;
        } else if (this.getType1Filter().accept(null, string)) {
            n2 = 1;
        } else {
            return;
        }
        if (this.fontPath == null) {
            this.fontPath = this.getPlatformFontPath(noType1Font);
        }
        String string2 = jreFontDirName + File.pathSeparator + this.fontPath;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
        boolean bl2 = false;
        try {
            while (!bl2 && stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                boolean bl3 = string3.equals(jreFontDirName);
                File file = new File(string3, string);
                if (!file.canRead()) continue;
                bl2 = true;
                String string4 = file.getAbsolutePath();
                if (bl) {
                    this.registerDeferredFont(string, string4, stringArray, n2, bl3, n);
                } else {
                    this.registerFontFile(string4, stringArray, n2, bl3, n);
                }
                break;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println(noSuchElementException);
        }
        if (!bl2) {
            this.addToMissingFontFileList(string);
        }
    }

    @Override
    protected FontConfiguration createFontConfiguration() {
        WFontConfiguration wFontConfiguration = new WFontConfiguration(this);
        wFontConfiguration.init();
        return wFontConfiguration;
    }

    @Override
    public FontConfiguration createFontConfiguration(boolean bl, boolean bl2) {
        return new WFontConfiguration(this, bl, bl2);
    }

    @Override
    protected void populateFontFileNameMap(HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, ArrayList<String>> hashMap3, Locale locale) {
        Win32FontManager.populateFontFileNameMap0(hashMap, hashMap2, hashMap3, locale);
    }

    private static native void populateFontFileNameMap0(HashMap<String, String> var0, HashMap<String, String> var1, HashMap<String, ArrayList<String>> var2, Locale var3);

    @Override
    protected synchronized native String getFontPath(boolean var1);

    @Override
    public String[] getDefaultPlatformFont() {
        if (defaultPlatformFont != null) {
            return defaultPlatformFont;
        }
        String[] stringArray = new String[]{"Arial", "c:\\windows\\fonts"};
        final String[] stringArray2 = this.getPlatformFontDirs(true);
        if (stringArray2.length > 1) {
            String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    for (int i = 0; i < stringArray2.length; ++i) {
                        String string = stringArray2[i] + File.separator + "arial.ttf";
                        File file = new File(string);
                        if (!file.exists()) continue;
                        return stringArray2[i];
                    }
                    return null;
                }
            });
            if (string != null) {
                stringArray[1] = string;
            }
        } else {
            stringArray[1] = stringArray2[0];
        }
        stringArray[1] = stringArray[1] + File.separator + "arial.ttf";
        defaultPlatformFont = stringArray;
        return defaultPlatformFont;
    }

    protected void registerJREFontsWithPlatform(String string) {
        fontsForPrinting = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerJREFontsForPrinting() {
        Class<Win32GraphicsEnvironment> clazz = Win32GraphicsEnvironment.class;
        synchronized (Win32GraphicsEnvironment.class) {
            GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (fontsForPrinting == null) {
                // ** MonitorExit[var1] (shouldn't be in output)
                return;
            }
            final String string = fontsForPrinting;
            fontsForPrinting = null;
            // ** MonitorExit[var1] (shouldn't be in output)
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    File file = new File(string);
                    String[] stringArray = file.list(SunFontManager.getInstance().getTrueTypeFilter());
                    if (stringArray == null) {
                        return null;
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        File file2 = new File(file, stringArray[i]);
                        Win32FontManager.registerFontWithPlatform(file2.getAbsolutePath());
                    }
                    return null;
                }
            });
            return;
        }
    }

    protected static native void registerFontWithPlatform(String var0);

    protected static native void deRegisterFontWithPlatform(String var0);

    @Override
    public HashMap<String, SunFontManager.FamilyDescription> populateHardcodedFileNameMap() {
        HashMap<String, SunFontManager.FamilyDescription> hashMap = new HashMap<String, SunFontManager.FamilyDescription>();
        SunFontManager.FamilyDescription familyDescription = new SunFontManager.FamilyDescription();
        familyDescription.familyName = "Segoe UI";
        familyDescription.plainFullName = "Segoe UI";
        familyDescription.plainFileName = "segoeui.ttf";
        familyDescription.boldFullName = "Segoe UI Bold";
        familyDescription.boldFileName = "segoeuib.ttf";
        familyDescription.italicFullName = "Segoe UI Italic";
        familyDescription.italicFileName = "segoeuii.ttf";
        familyDescription.boldItalicFullName = "Segoe UI Bold Italic";
        familyDescription.boldItalicFileName = "segoeuiz.ttf";
        hashMap.put("segoe", familyDescription);
        familyDescription = new SunFontManager.FamilyDescription();
        familyDescription.familyName = "Tahoma";
        familyDescription.plainFullName = "Tahoma";
        familyDescription.plainFileName = "tahoma.ttf";
        familyDescription.boldFullName = "Tahoma Bold";
        familyDescription.boldFileName = "tahomabd.ttf";
        hashMap.put("tahoma", familyDescription);
        familyDescription = new SunFontManager.FamilyDescription();
        familyDescription.familyName = "Verdana";
        familyDescription.plainFullName = "Verdana";
        familyDescription.plainFileName = "verdana.TTF";
        familyDescription.boldFullName = "Verdana Bold";
        familyDescription.boldFileName = "verdanab.TTF";
        familyDescription.italicFullName = "Verdana Italic";
        familyDescription.italicFileName = "verdanai.TTF";
        familyDescription.boldItalicFullName = "Verdana Bold Italic";
        familyDescription.boldItalicFileName = "verdanaz.TTF";
        hashMap.put("verdana", familyDescription);
        familyDescription = new SunFontManager.FamilyDescription();
        familyDescription.familyName = "Arial";
        familyDescription.plainFullName = "Arial";
        familyDescription.plainFileName = "ARIAL.TTF";
        familyDescription.boldFullName = "Arial Bold";
        familyDescription.boldFileName = "ARIALBD.TTF";
        familyDescription.italicFullName = "Arial Italic";
        familyDescription.italicFileName = "ARIALI.TTF";
        familyDescription.boldItalicFullName = "Arial Bold Italic";
        familyDescription.boldItalicFileName = "ARIALBI.TTF";
        hashMap.put("arial", familyDescription);
        familyDescription = new SunFontManager.FamilyDescription();
        familyDescription.familyName = "Symbol";
        familyDescription.plainFullName = "Symbol";
        familyDescription.plainFileName = "Symbol.TTF";
        hashMap.put("symbol", familyDescription);
        familyDescription = new SunFontManager.FamilyDescription();
        familyDescription.familyName = "WingDings";
        familyDescription.plainFullName = "WingDings";
        familyDescription.plainFileName = "WINGDING.TTF";
        hashMap.put("wingdings", familyDescription);
        return hashMap;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = Win32FontManager.getEUDCFontFile();
                if (string != null) {
                    try {
                        eudcFont = new TrueTypeFont(string, null, 0, true);
                    }
                    catch (FontFormatException fontFormatException) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
        fontsForPrinting = null;
    }
}

