/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import sun.misc.Unsafe;

public class SynchronousQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = -3223113410248163686L;
    static final int NCPUS = Runtime.getRuntime().availableProcessors();
    static final int maxTimedSpins = NCPUS < 2 ? 0 : 32;
    static final int maxUntimedSpins = maxTimedSpins * 16;
    static final long spinForTimeoutThreshold = 1000L;
    private volatile transient Transferer transferer;
    private ReentrantLock qlock;
    private WaitQueue waitingProducers;
    private WaitQueue waitingConsumers;

    public SynchronousQueue() {
        this(false);
    }

    public SynchronousQueue(boolean bl) {
        this.transferer = bl ? new TransferQueue() : new TransferStack();
    }

    @Override
    public void put(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.transferer.transfer(e, false, 0L) == null) {
            Thread.interrupted();
            throw new InterruptedException();
        }
    }

    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.transferer.transfer(e, true, timeUnit.toNanos(l)) != null) {
            return true;
        }
        if (!Thread.interrupted()) {
            return false;
        }
        throw new InterruptedException();
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        return this.transferer.transfer(e, true, 0L) != null;
    }

    @Override
    public E take() throws InterruptedException {
        Object object = this.transferer.transfer(null, false, 0L);
        if (object != null) {
            return (E)object;
        }
        Thread.interrupted();
        throw new InterruptedException();
    }

    @Override
    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        Object object = this.transferer.transfer(null, true, timeUnit.toNanos(l));
        if (object != null || !Thread.interrupted()) {
            return (E)object;
        }
        throw new InterruptedException();
    }

    @Override
    public E poll() {
        return (E)this.transferer.transfer(null, true, 0L);
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public int remainingCapacity() {
        return 0;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean contains(Object object) {
        return false;
    }

    @Override
    public boolean remove(Object object) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return collection.isEmpty();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return false;
    }

    @Override
    public E peek() {
        return null;
    }

    @Override
    public Iterator<E> iterator() {
        return Collections.emptyIterator();
    }

    @Override
    public Object[] toArray() {
        return new Object[0];
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        if (TArray.length > 0) {
            TArray[0] = null;
        }
        return TArray;
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        E e;
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while ((e = this.poll()) != null) {
            collection.add(e);
            ++n;
        }
        return n;
    }

    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        E e;
        int n2;
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        for (n2 = 0; n2 < n && (e = this.poll()) != null; ++n2) {
            collection.add(e);
        }
        return n2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.transferer instanceof TransferQueue;
        if (bl) {
            this.qlock = new ReentrantLock(true);
            this.waitingProducers = new FifoWaitQueue();
            this.waitingConsumers = new FifoWaitQueue();
        } else {
            this.qlock = new ReentrantLock();
            this.waitingProducers = new LifoWaitQueue();
            this.waitingConsumers = new LifoWaitQueue();
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.transferer = this.waitingProducers instanceof FifoWaitQueue ? new TransferQueue() : new TransferStack();
    }

    static long objectFieldOffset(Unsafe unsafe, String string, Class<?> clazz) {
        try {
            return unsafe.objectFieldOffset(clazz.getDeclaredField(string));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            NoSuchFieldError noSuchFieldError = new NoSuchFieldError(string);
            noSuchFieldError.initCause(noSuchFieldException);
            throw noSuchFieldError;
        }
    }

    static class FifoWaitQueue
    extends WaitQueue {
        private static final long serialVersionUID = -3623113410248163686L;

        FifoWaitQueue() {
        }
    }

    static class LifoWaitQueue
    extends WaitQueue {
        private static final long serialVersionUID = -3633113410248163686L;

        LifoWaitQueue() {
        }
    }

    static final class TransferQueue
    extends Transferer {
        volatile transient QNode head;
        volatile transient QNode tail;
        volatile transient QNode cleanMe;
        private static final Unsafe UNSAFE;
        private static final long headOffset;
        private static final long tailOffset;
        private static final long cleanMeOffset;

        TransferQueue() {
            QNode qNode;
            this.head = qNode = new QNode(null, false);
            this.tail = qNode;
        }

        void advanceHead(QNode qNode, QNode qNode2) {
            if (qNode == this.head && UNSAFE.compareAndSwapObject(this, headOffset, qNode, qNode2)) {
                qNode.next = qNode;
            }
        }

        void advanceTail(QNode qNode, QNode qNode2) {
            if (this.tail == qNode) {
                UNSAFE.compareAndSwapObject(this, tailOffset, qNode, qNode2);
            }
        }

        boolean casCleanMe(QNode qNode, QNode qNode2) {
            return this.cleanMe == qNode && UNSAFE.compareAndSwapObject(this, cleanMeOffset, qNode, qNode2);
        }

        @Override
        Object transfer(Object object, boolean bl, long l) {
            Object object2;
            QNode qNode;
            QNode qNode2;
            QNode qNode3 = null;
            boolean bl2 = object != null;
            while (true) {
                QNode qNode4 = this.tail;
                qNode2 = this.head;
                if (qNode4 == null || qNode2 == null) continue;
                if (qNode2 == qNode4 || qNode4.isData == bl2) {
                    qNode = qNode4.next;
                    if (qNode4 != this.tail) continue;
                    if (qNode != null) {
                        this.advanceTail(qNode4, qNode);
                        continue;
                    }
                    if (bl && l <= 0L) {
                        return null;
                    }
                    if (qNode3 == null) {
                        qNode3 = new QNode(object, bl2);
                    }
                    if (!qNode4.casNext(null, qNode3)) continue;
                    this.advanceTail(qNode4, qNode3);
                    object2 = this.awaitFulfill(qNode3, object, bl, l);
                    if (object2 == qNode3) {
                        this.clean(qNode4, qNode3);
                        return null;
                    }
                    if (!qNode3.isOffList()) {
                        this.advanceHead(qNode4, qNode3);
                        if (object2 != null) {
                            qNode3.item = qNode3;
                        }
                        qNode3.waiter = null;
                    }
                    return object2 != null ? object2 : object;
                }
                qNode = qNode2.next;
                if (qNode4 != this.tail || qNode == null || qNode2 != this.head) continue;
                object2 = qNode.item;
                if (bl2 != (object2 != null) && object2 != qNode && qNode.casItem(object2, object)) break;
                this.advanceHead(qNode2, qNode);
            }
            this.advanceHead(qNode2, qNode);
            LockSupport.unpark(qNode.waiter);
            return object2 != null ? object2 : object;
        }

        Object awaitFulfill(QNode qNode, Object object, boolean bl, long l) {
            int n;
            long l2 = bl ? System.nanoTime() : 0L;
            Thread thread = Thread.currentThread();
            int n2 = this.head.next == qNode ? (bl ? maxTimedSpins : maxUntimedSpins) : (n = 0);
            while (true) {
                long l3;
                Object object2;
                if (thread.isInterrupted()) {
                    qNode.tryCancel(object);
                }
                if ((object2 = qNode.item) != object) {
                    return object2;
                }
                if (bl && (l -= (l3 = System.nanoTime()) - (l2 = l3)) <= 0L) {
                    qNode.tryCancel(object);
                    continue;
                }
                if (n > 0) {
                    --n;
                    continue;
                }
                if (qNode.waiter == null) {
                    qNode.waiter = thread;
                    continue;
                }
                if (!bl) {
                    LockSupport.park(this);
                    continue;
                }
                if (l <= 1000L) continue;
                LockSupport.parkNanos(this, l);
            }
        }

        void clean(QNode qNode, QNode qNode2) {
            qNode2.waiter = null;
            while (qNode.next == qNode2) {
                QNode qNode3;
                QNode qNode4 = this.head;
                QNode qNode5 = qNode4.next;
                if (qNode5 != null && qNode5.isCancelled()) {
                    this.advanceHead(qNode4, qNode5);
                    continue;
                }
                QNode qNode6 = this.tail;
                if (qNode6 == qNode4) {
                    return;
                }
                QNode qNode7 = qNode6.next;
                if (qNode6 != this.tail) continue;
                if (qNode7 != null) {
                    this.advanceTail(qNode6, qNode7);
                    continue;
                }
                if (qNode2 != qNode6 && ((qNode3 = qNode2.next) == qNode2 || qNode.casNext(qNode2, qNode3))) {
                    return;
                }
                qNode3 = this.cleanMe;
                if (qNode3 != null) {
                    QNode qNode8;
                    QNode qNode9 = qNode3.next;
                    if (qNode9 == null || qNode9 == qNode3 || !qNode9.isCancelled() || qNode9 != qNode6 && (qNode8 = qNode9.next) != null && qNode8 != qNode9 && qNode3.casNext(qNode9, qNode8)) {
                        this.casCleanMe(qNode3, null);
                    }
                    if (qNode3 != qNode) continue;
                    return;
                }
                if (!this.casCleanMe(null, qNode)) continue;
                return;
            }
        }

        static {
            try {
                UNSAFE = Unsafe.getUnsafe();
                Class<TransferQueue> clazz = TransferQueue.class;
                headOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("head"));
                tailOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("tail"));
                cleanMeOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("cleanMe"));
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
        }

        static final class QNode {
            volatile QNode next;
            volatile Object item;
            volatile Thread waiter;
            final boolean isData;
            private static final Unsafe UNSAFE;
            private static final long itemOffset;
            private static final long nextOffset;

            QNode(Object object, boolean bl) {
                this.item = object;
                this.isData = bl;
            }

            boolean casNext(QNode qNode, QNode qNode2) {
                return this.next == qNode && UNSAFE.compareAndSwapObject(this, nextOffset, qNode, qNode2);
            }

            boolean casItem(Object object, Object object2) {
                return this.item == object && UNSAFE.compareAndSwapObject(this, itemOffset, object, object2);
            }

            void tryCancel(Object object) {
                UNSAFE.compareAndSwapObject(this, itemOffset, object, this);
            }

            boolean isCancelled() {
                return this.item == this;
            }

            boolean isOffList() {
                return this.next == this;
            }

            static {
                try {
                    UNSAFE = Unsafe.getUnsafe();
                    Class<QNode> clazz = QNode.class;
                    itemOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("item"));
                    nextOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("next"));
                }
                catch (Exception exception) {
                    throw new Error(exception);
                }
            }
        }
    }

    static final class TransferStack
    extends Transferer {
        static final int REQUEST = 0;
        static final int DATA = 1;
        static final int FULFILLING = 2;
        volatile SNode head;
        private static final Unsafe UNSAFE;
        private static final long headOffset;

        TransferStack() {
        }

        static boolean isFulfilling(int n) {
            return (n & 2) != 0;
        }

        boolean casHead(SNode sNode, SNode sNode2) {
            return sNode == this.head && UNSAFE.compareAndSwapObject(this, headOffset, sNode, sNode2);
        }

        static SNode snode(SNode sNode, Object object, SNode sNode2, int n) {
            if (sNode == null) {
                sNode = new SNode(object);
            }
            sNode.mode = n;
            sNode.next = sNode2;
            return sNode;
        }

        @Override
        Object transfer(Object object, boolean bl, long l) {
            int n;
            SNode sNode = null;
            int n2 = n = object == null ? 0 : 1;
            block0: while (true) {
                SNode sNode2;
                SNode sNode3;
                SNode sNode4;
                if ((sNode4 = this.head) == null || sNode4.mode == n) {
                    if (bl && l <= 0L) {
                        if (sNode4 != null && sNode4.isCancelled()) {
                            this.casHead(sNode4, sNode4.next);
                            continue;
                        }
                        return null;
                    }
                    if (!this.casHead(sNode4, sNode = TransferStack.snode(sNode, object, sNode4, n))) continue;
                    sNode3 = this.awaitFulfill(sNode, bl, l);
                    if (sNode3 == sNode) {
                        this.clean(sNode);
                        return null;
                    }
                    sNode4 = this.head;
                    if (sNode4 != null && sNode4.next == sNode) {
                        this.casHead(sNode4, sNode.next);
                    }
                    return n == 0 ? sNode3.item : sNode.item;
                }
                if (!TransferStack.isFulfilling(sNode4.mode)) {
                    if (sNode4.isCancelled()) {
                        this.casHead(sNode4, sNode4.next);
                        continue;
                    }
                    if (!this.casHead(sNode4, sNode = TransferStack.snode(sNode, object, sNode4, 2 | n))) continue;
                    while (true) {
                        if ((sNode3 = sNode.next) == null) {
                            this.casHead(sNode, null);
                            sNode = null;
                            continue block0;
                        }
                        sNode2 = sNode3.next;
                        if (sNode3.tryMatch(sNode)) {
                            this.casHead(sNode, sNode2);
                            return n == 0 ? sNode3.item : sNode.item;
                        }
                        sNode.casNext(sNode3, sNode2);
                    }
                }
                sNode3 = sNode4.next;
                if (sNode3 == null) {
                    this.casHead(sNode4, null);
                    continue;
                }
                sNode2 = sNode3.next;
                if (sNode3.tryMatch(sNode4)) {
                    this.casHead(sNode4, sNode2);
                    continue;
                }
                sNode4.casNext(sNode3, sNode2);
            }
        }

        SNode awaitFulfill(SNode sNode, boolean bl, long l) {
            int n;
            long l2 = bl ? System.nanoTime() : 0L;
            Thread thread = Thread.currentThread();
            SNode sNode2 = this.head;
            int n2 = this.shouldSpin(sNode) ? (bl ? maxTimedSpins : maxUntimedSpins) : (n = 0);
            while (true) {
                long l3;
                SNode sNode3;
                if (thread.isInterrupted()) {
                    sNode.tryCancel();
                }
                if ((sNode3 = sNode.match) != null) {
                    return sNode3;
                }
                if (bl && (l -= (l3 = System.nanoTime()) - (l2 = l3)) <= 0L) {
                    sNode.tryCancel();
                    continue;
                }
                if (n > 0) {
                    n = this.shouldSpin(sNode) ? n - 1 : 0;
                    continue;
                }
                if (sNode.waiter == null) {
                    sNode.waiter = thread;
                    continue;
                }
                if (!bl) {
                    LockSupport.park(this);
                    continue;
                }
                if (l <= 1000L) continue;
                LockSupport.parkNanos(this, l);
            }
        }

        boolean shouldSpin(SNode sNode) {
            SNode sNode2 = this.head;
            return sNode2 == sNode || sNode2 == null || TransferStack.isFulfilling(sNode2.mode);
        }

        void clean(SNode sNode) {
            SNode sNode2;
            sNode.item = null;
            sNode.waiter = null;
            SNode sNode3 = sNode.next;
            if (sNode3 != null && sNode3.isCancelled()) {
                sNode3 = sNode3.next;
            }
            while ((sNode2 = this.head) != null && sNode2 != sNode3 && sNode2.isCancelled()) {
                this.casHead(sNode2, sNode2.next);
            }
            while (sNode2 != null && sNode2 != sNode3) {
                SNode sNode4 = sNode2.next;
                if (sNode4 != null && sNode4.isCancelled()) {
                    sNode2.casNext(sNode4, sNode4.next);
                    continue;
                }
                sNode2 = sNode4;
            }
        }

        static {
            try {
                UNSAFE = Unsafe.getUnsafe();
                Class<TransferStack> clazz = TransferStack.class;
                headOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("head"));
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
        }

        static final class SNode {
            volatile SNode next;
            volatile SNode match;
            volatile Thread waiter;
            Object item;
            int mode;
            private static final Unsafe UNSAFE;
            private static final long matchOffset;
            private static final long nextOffset;

            SNode(Object object) {
                this.item = object;
            }

            boolean casNext(SNode sNode, SNode sNode2) {
                return sNode == this.next && UNSAFE.compareAndSwapObject(this, nextOffset, sNode, sNode2);
            }

            boolean tryMatch(SNode sNode) {
                if (this.match == null && UNSAFE.compareAndSwapObject(this, matchOffset, null, sNode)) {
                    Thread thread = this.waiter;
                    if (thread != null) {
                        this.waiter = null;
                        LockSupport.unpark(thread);
                    }
                    return true;
                }
                return this.match == sNode;
            }

            void tryCancel() {
                UNSAFE.compareAndSwapObject(this, matchOffset, null, this);
            }

            boolean isCancelled() {
                return this.match == this;
            }

            static {
                try {
                    UNSAFE = Unsafe.getUnsafe();
                    Class<SNode> clazz = SNode.class;
                    matchOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("match"));
                    nextOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("next"));
                }
                catch (Exception exception) {
                    throw new Error(exception);
                }
            }
        }
    }

    static abstract class Transferer {
        Transferer() {
        }

        abstract Object transfer(Object var1, boolean var2, long var3);
    }

    static class WaitQueue
    implements Serializable {
        WaitQueue() {
        }
    }
}

