/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.DirectionalGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.EmbeddedPlanarGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Face;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Logger;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.OrthogonalRepresentation;

public class RectangularCompactor {
    private static int startOfNextBar;

    public void compact(Collection<OrthogonalRepresentation> collection) {
        startOfNextBar = 0;
        for (OrthogonalRepresentation orthogonalRepresentation : collection) {
            this.compact(orthogonalRepresentation);
        }
    }

    private void compact(OrthogonalRepresentation orthogonalRepresentation) {
        this.insertBendVertices(orthogonalRepresentation);
        this.assignEdgeDirections(orthogonalRepresentation);
        this.refineShapes(orthogonalRepresentation);
        DirectionalGraph directionalGraph = DirectionalGraph.createGraph(orthogonalRepresentation, MGraph.Edge.Direction.HORIZONTAL);
        Collection<DirectionalGraph.Bar> collection = directionalGraph.getBars();
        Object[] objectArray = new DirectionalGraph.Bar[collection.size()];
        collection.toArray(objectArray);
        Arrays.sort(objectArray);
        int n = startOfNextBar;
        int n2 = -1;
        for (Object objectArray2 : objectArray) {
            n += n2 + 55;
            n2 = -1;
            for (MGraph.Vertex vertex : ((DirectionalGraph.Bar)objectArray2).getVertices()) {
                int n3;
                if (vertex instanceof MGraph.DummyVertex) continue;
                vertex.setX(n);
                Object object = vertex.getSize();
                if (object == null || (n3 = ((Dimension)object).width) <= n2) continue;
                n2 = n3;
            }
        }
        startOfNextBar = n + n2;
        DirectionalGraph directionalGraph2 = DirectionalGraph.createGraph(orthogonalRepresentation, MGraph.Edge.Direction.VERTICAL);
        collection = directionalGraph2.getBars();
        objectArray = new DirectionalGraph.Bar[collection.size()];
        collection.toArray(objectArray);
        Arrays.sort(objectArray);
        int n4 = 0;
        int n5 = 0;
        for (Object object : objectArray) {
            n4 += n5 + 55;
            n5 = -1;
            for (MGraph.Vertex vertex : ((DirectionalGraph.Bar)object).getVertices()) {
                int n6;
                if (vertex instanceof MGraph.DummyVertex) continue;
                vertex.setY(n4);
                Dimension dimension = vertex.getSize();
                if (dimension == null || (n6 = dimension.height) <= n5) continue;
                n5 = n6;
            }
        }
    }

    private void insertBendVertices(OrthogonalRepresentation orthogonalRepresentation) {
        MGraph mGraph = orthogonalRepresentation.getOriginalGraph().getOriginalGraph();
        HashMap<MGraph.Edge, ArrayList<MGraph.Edge>> hashMap = new HashMap<MGraph.Edge, ArrayList<MGraph.Edge>>();
        for (OrthogonalRepresentation.OrthogonalShape orthogonalShape : orthogonalRepresentation.getShapes()) {
            Face face = orthogonalShape.getFace();
            ArrayList<Face.Dart> arrayList = new ArrayList<Face.Dart>(face.getDarts());
            for (Face.Dart dart : arrayList) {
                OrthogonalRepresentation.Tuple tuple = orthogonalShape.getTuple(dart);
                if (tuple == null) continue;
                BitSet bitSet = tuple.getBends();
                int n = tuple.getNumberOfBends();
                if (n == 0) continue;
                MGraph.Edge edge = dart.getEdge();
                ArrayList<MGraph.Edge> arrayList2 = (ArrayList<MGraph.Edge>)hashMap.get(edge);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<MGraph.Edge>();
                    hashMap.put(edge, arrayList2);
                    MGraph.Vertex vertex = dart.getV();
                    MGraph.Vertex vertex2 = dart.getW();
                    for (int i = 0; i < n; ++i) {
                        MGraph.DummyVertex dummyVertex = mGraph.insertDummyVertex(edge, MGraph.DummyVertex.Type.BEND);
                        arrayList2.add(vertex.getEdge(dummyVertex));
                        edge = dummyVertex.getEdge(vertex2);
                        vertex = dummyVertex;
                    }
                    arrayList2.add(edge);
                }
                orthogonalShape.updateTuple(tuple, arrayList2);
            }
        }
    }

    private void assignEdgeDirections(OrthogonalRepresentation orthogonalRepresentation) {
        Face face = orthogonalRepresentation.getOriginalGraph().getFaces().get(0);
        HashSet<Face> hashSet = new HashSet<Face>();
        OrthogonalRepresentation.OrthogonalShape orthogonalShape = orthogonalRepresentation.getShape(face);
        MGraph.Edge edge = orthogonalShape.getFace().getDarts().get(0).getEdge();
        edge.setDirection(MGraph.Edge.Direction.HORIZONTAL);
        this.assignEdgeDirections(orthogonalShape, edge, orthogonalRepresentation, hashSet);
    }

    private void assignEdgeDirections(OrthogonalRepresentation.OrthogonalShape orthogonalShape, MGraph.Edge edge, OrthogonalRepresentation orthogonalRepresentation, Set<Face> set) {
        int n;
        Face face = orthogonalShape.getFace();
        set.add(face);
        EmbeddedPlanarGraph embeddedPlanarGraph = orthogonalRepresentation.getOriginalGraph();
        List<Face.Dart> list = face.getDarts();
        int n2 = 0;
        int n3 = list.size();
        for (n = 0; n < n3; ++n) {
            if (edge != list.get(n).getEdge()) continue;
            n2 = n;
            break;
        }
        n = n2;
        MGraph.Edge.Direction direction = null;
        do {
            Object object;
            Face.Dart dart;
            MGraph.Edge edge2;
            MGraph.Edge.Direction direction2;
            if ((direction2 = (edge2 = (dart = list.get(n)).getEdge()).getDirection()) == null) {
                object = orthogonalShape.getTuple(dart);
                int n4 = ((OrthogonalRepresentation.Tuple)object).getAngles();
                direction2 = this.computeDirection(direction, n4);
                edge2.setDirection(direction2);
            }
            if (!((Face)(object = embeddedPlanarGraph.getOppositeFace(face, dart))).isOuterFace() && !set.contains(object)) {
                this.assignEdgeDirections(orthogonalRepresentation.getShape((Face)object), edge2, orthogonalRepresentation, set);
            }
            direction = direction2;
            if (++n != n3) continue;
            n = 0;
        } while (n != n2);
    }

    private MGraph.Edge.Direction computeDirection(MGraph.Edge.Direction direction, int n) {
        for (int i = 0; i < n; ++i) {
            direction = direction == MGraph.Edge.Direction.HORIZONTAL ? MGraph.Edge.Direction.VERTICAL : MGraph.Edge.Direction.HORIZONTAL;
        }
        return direction;
    }

    private void refineShapes(OrthogonalRepresentation orthogonalRepresentation) {
        HashMap<MGraph.Edge, Collection<MGraph.Edge>> hashMap = new HashMap<MGraph.Edge, Collection<MGraph.Edge>>();
        OrthogonalRepresentation.OrthogonalShape orthogonalShape = null;
        for (OrthogonalRepresentation.OrthogonalShape orthogonalShape2 : orthogonalRepresentation.getShapes()) {
            Face face = orthogonalShape2.getFace();
            if (face.isOuterFace()) {
                orthogonalShape = orthogonalShape2;
                continue;
            }
            this.refineShape(orthogonalShape2, orthogonalRepresentation, hashMap);
        }
        this.refineShape(orthogonalShape, orthogonalRepresentation, hashMap);
        this.addDummyOuterFace(orthogonalShape, orthogonalRepresentation);
    }

    private void updateShape(OrthogonalRepresentation.OrthogonalShape orthogonalShape, Map<MGraph.Edge, Collection<MGraph.Edge>> map) {
        if (map.isEmpty()) {
            return;
        }
        Face face = orthogonalShape.getFace();
        Face.Dart dart = face.getDarts().get(0);
        while (true) {
            MGraph.Edge edge;
            Collection<MGraph.Edge> collection;
            if ((collection = map.get(edge = dart.getEdge())) != null) {
                OrthogonalRepresentation.Tuple tuple = orthogonalShape.getTuple(dart);
                orthogonalShape.updateTuple(tuple, collection);
                dart = face.getDarts().get(0);
                continue;
            }
            if ((dart = face.getNextDart(dart)) == face.getDarts().get(0)) break;
        }
    }

    private void refineShape(OrthogonalRepresentation.OrthogonalShape orthogonalShape, OrthogonalRepresentation orthogonalRepresentation, Map<MGraph.Edge, Collection<MGraph.Edge>> map) {
        this.updateShape(orthogonalShape, map);
        MGraph mGraph = orthogonalRepresentation.getOriginalGraph().getOriginalGraph();
        while (this.refineShapeSub(orthogonalShape, mGraph, map)) {
        }
    }

    private boolean refineShapeSub(OrthogonalRepresentation.OrthogonalShape orthogonalShape, MGraph mGraph, Map<MGraph.Edge, Collection<MGraph.Edge>> map) {
        Face.Dart dart;
        Face face = orthogonalShape.getFace();
        Logger.log(0, "refining face " + face);
        ArrayList<Face.Dart> arrayList = new ArrayList<Face.Dart>(face.getDarts());
        Face.Dart dart2 = dart = arrayList.get(0);
        do {
            Object object;
            int n = 0;
            Face.Dart dart3 = face.getNextDart(dart2);
            Face.Dart dart4 = null;
            int n2 = 0;
            Logger.log(0, "currentDart = " + dart2);
            while (true) {
                Logger.log(0, "nextDart = " + dart3);
                object = orthogonalShape.getTuple(dart3);
                int n3 = ((OrthogonalRepresentation.Tuple)object).getAngles();
                Logger.log(0, "angles = " + n3);
                ++n2;
                if (n3 == 1) {
                    --n;
                    Logger.log(0, "right turn");
                } else if (n3 == 3) {
                    ++n;
                    Logger.log(0, "left turn");
                } else if (n3 == 4) {
                    n += 2;
                    Logger.log(0, "2 right turns");
                } else {
                    if (n2 == 0) {
                        Logger.log(0, "break");
                        break;
                    }
                    --n2;
                    Logger.log(0, "straight");
                }
                if (n == -1 && n2 > 1) {
                    dart4 = dart3;
                    Logger.log(0, "FRONT DART = " + dart4);
                    Logger.log(0, "CURRENT DART = " + dart2);
                    break;
                }
                if (n2 == 4 || n == 0 || dart3 == dart2) break;
                dart3 = face.getNextDart(dart3);
            }
            if (dart4 == null) continue;
            object = dart2.getEdge();
            MGraph.Edge.Direction direction = ((MGraph.Edge)object).getDirection();
            OrthogonalRepresentation.Tuple tuple = orthogonalShape.getTuple(dart2);
            if (tuple.getAngles() != -1) {
                ArrayList<MGraph.Edge> arrayList2 = new ArrayList<MGraph.Edge>();
                map.put((MGraph.Edge)object, arrayList2);
                MGraph.DummyVertex dummyVertex = mGraph.insertDummyVertex((MGraph.Edge)object, MGraph.DummyVertex.Type.TEMPORARY);
                MGraph.DummyEdge dummyEdge = mGraph.addDummyEdge(dummyVertex, dart4.getV());
                if (direction == MGraph.Edge.Direction.VERTICAL) {
                    dummyEdge.setDirection(MGraph.Edge.Direction.HORIZONTAL);
                } else {
                    dummyEdge.setDirection(MGraph.Edge.Direction.VERTICAL);
                }
                MGraph.Vertex vertex = dart2.getV();
                MGraph.Edge edge = vertex.getEdge(dummyVertex);
                edge.setDirection(direction);
                arrayList2.add(edge);
                MGraph.Vertex vertex2 = dart2.getW();
                MGraph.Edge edge2 = dummyVertex.getEdge(vertex2);
                edge2.setDirection(direction);
                arrayList2.add(edge2);
                orthogonalShape.updateTuple(orthogonalShape.getTuple(dart2), arrayList2);
                orthogonalShape.insertEdge(dummyEdge);
            } else {
                MGraph.DummyEdge dummyEdge = mGraph.addDummyEdge(dart2.getV(), dart4.getV());
                if (direction == MGraph.Edge.Direction.VERTICAL) {
                    dummyEdge.setDirection(MGraph.Edge.Direction.HORIZONTAL);
                } else {
                    dummyEdge.setDirection(MGraph.Edge.Direction.VERTICAL);
                }
                orthogonalShape.insertEdge(dummyEdge);
            }
            return true;
        } while ((dart2 = face.getNextDart(dart2)) != dart);
        return false;
    }

    private void addDummyOuterFace(OrthogonalRepresentation.OrthogonalShape orthogonalShape, OrthogonalRepresentation orthogonalRepresentation) {
        MGraph.Edge edge;
        Object object;
        MGraph mGraph = orthogonalRepresentation.getOriginalGraph().getOriginalGraph();
        ArrayList<MGraph.Edge> arrayList = new ArrayList<MGraph.Edge>();
        ArrayList<MGraph.Edge> arrayList2 = new ArrayList<MGraph.Edge>();
        Object object2 = mGraph.addDummyVertex(MGraph.DummyVertex.Type.TEMPORARY);
        MGraph.DummyVertex dummyVertex = object2;
        for (int i = 0; i < 4; ++i) {
            object = null;
            object = i < 3 ? mGraph.addDummyVertex(MGraph.DummyVertex.Type.TEMPORARY) : dummyVertex;
            edge = mGraph.addDummyEdge((MGraph.Vertex)object2, (MGraph.Vertex)object);
            arrayList.add(edge);
            if (i == 0 || i == 2) {
                edge.setDirection(MGraph.Edge.Direction.VERTICAL);
            } else {
                edge.setDirection(MGraph.Edge.Direction.HORIZONTAL);
            }
            arrayList2.add(null);
            object2 = object;
        }
        Face face = orthogonalShape.getFace();
        object = face.getDarts();
        edge = (Face.Dart)object.get(0);
        Face.Dart dart = (Face.Dart)object.get(object.size() - 1);
        MGraph.Edge edge2 = edge;
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (((Face.Dart)edge).getDirection() == MGraph.Edge.Direction.VERTICAL) {
            n = 1;
        }
        while (true) {
            Face.Dart dart2;
            int n4;
            if ((n4 = orthogonalShape.getTuple(dart2 = face.getNextDart((Face.Dart)edge2)).getAngles()) == 3 || n4 == 4) {
                int n5 = 0;
                while (true) {
                    OrthogonalRepresentation.Tuple tuple;
                    if ((n4 = (tuple = orthogonalShape.getTuple(dart2)).getAngles()) == 1) {
                        --n5;
                    } else if (n4 == 3) {
                        ++n5;
                    } else if (n4 == 4) {
                        n5 += 2;
                    }
                    if (n5 == 4) {
                        bl3 = true;
                        if (n3 == -1) {
                            n3 = n;
                        }
                        MGraph.Edge edge3 = (MGraph.Edge)arrayList.get(n);
                        MGraph.Edge.Direction direction = edge3.getDirection();
                        MGraph.Vertex vertex = edge3.getV();
                        MGraph.Vertex vertex2 = edge3.getW();
                        object2 = mGraph.insertDummyVertex(edge3, MGraph.DummyVertex.Type.TEMPORARY);
                        edge3 = mGraph.addDummyEdge(edge2.getW(), (MGraph.Vertex)object2);
                        if (direction == MGraph.Edge.Direction.HORIZONTAL) {
                            edge3.setDirection(MGraph.Edge.Direction.VERTICAL);
                        } else {
                            edge3.setDirection(MGraph.Edge.Direction.HORIZONTAL);
                        }
                        MGraph.Edge edge4 = ((MGraph.Vertex)object2).getEdge(vertex2);
                        edge4.setDirection(direction);
                        arrayList.set(n, edge4);
                        MGraph.Edge edge5 = vertex.getEdge((MGraph.Vertex)object2);
                        edge5.setDirection(direction);
                        if (arrayList2.get(n) != null) break;
                        arrayList2.set(n, edge5);
                        break;
                    }
                    if (dart2 == edge2) break;
                    dart2 = face.getNextDart(dart2);
                }
            }
            if ((edge2 = face.getNextDart((Face.Dart)edge2)) == edge) break;
            n4 = orthogonalShape.getTuple((Face.Dart)edge2).getAngles();
            if (n4 == 1) {
                if (--n == -1) {
                    n = 3;
                }
                --n2;
            } else if (n4 == 3) {
                if (++n == 4) {
                    n = 0;
                }
                ++n2;
            } else if (n4 == 4) {
                if ((n += 2) >= 4) {
                    n -= 4;
                }
                n2 += 2;
            }
            if (n2 == 3 && !bl) {
                bl = true;
            }
            if (!bl || bl2 || n != n3) continue;
            bl2 = true;
            MGraph.Edge edge6 = (MGraph.Edge)arrayList2.get(n3);
            if (edge6 == null) continue;
            arrayList.set(n3, edge6);
        }
        if (bl3) {
            orthogonalRepresentation.setCornerVertex(dummyVertex);
        }
    }
}

