/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.anchor;

import java.awt.Point;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.model.StateModel;
import org.netbeans.api.visual.widget.Widget;

public final class ProxyAnchor
extends Anchor
implements StateModel.Listener {
    private StateModel model;
    private Anchor[] anchors;
    private int index;

    public ProxyAnchor(StateModel stateModel, Anchor ... anchorArray) {
        super(null);
        this.model = stateModel;
        this.anchors = anchorArray;
        this.index = stateModel.getState();
    }

    public StateModel getModel() {
        return this.model;
    }

    @Override
    protected void notifyEntryAdded(Anchor.Entry entry) {
        this.anchors[this.index].addEntry(entry);
    }

    @Override
    protected void notifyEntryRemoved(Anchor.Entry entry) {
        this.anchors[this.index].removeEntry(entry);
    }

    @Override
    protected void notifyUsed() {
        this.model.addListener(this);
    }

    @Override
    protected void notifyUnused() {
        this.model.removeListener(this);
    }

    @Override
    public void stateChanged() {
        int n = this.getModel().getState();
        if (this.index == n) {
            return;
        }
        this.anchors[this.index].removeEntries(this.getEntries());
        this.index = n;
        this.anchors[this.index].addEntries(this.getEntries());
        this.revalidateDependency();
    }

    @Override
    public Point getRelatedSceneLocation() {
        return this.anchors[this.index].getRelatedSceneLocation();
    }

    @Override
    public Widget getRelatedWidget() {
        return this.anchors[this.index].getRelatedWidget();
    }

    @Override
    public Anchor.Result compute(Anchor.Entry entry) {
        return this.anchors[this.index].compute(entry);
    }
}

