/*
 * Decompiled with CFR 0.152.
 */
package sun.security.smartcardio;

import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardNotPresentException;
import javax.smartcardio.CardPermission;
import javax.smartcardio.CardTerminal;
import sun.security.smartcardio.CardImpl;
import sun.security.smartcardio.PCSC;
import sun.security.smartcardio.PCSCException;

final class TerminalImpl
extends CardTerminal {
    final long contextId;
    final String name;
    private CardImpl card;

    TerminalImpl(long l, String string) {
        this.contextId = l;
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized Card connect(String string) throws CardException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new CardPermission(this.name, "connect"));
        }
        if (this.card != null) {
            if (this.card.isValid()) {
                String string2 = this.card.getProtocol();
                if (string.equals("*") || string.equalsIgnoreCase(string2)) {
                    return this.card;
                }
                throw new CardException("Cannot connect using " + string + ", connection already established using " + string2);
            }
            this.card = null;
        }
        try {
            this.card = new CardImpl(this, string);
            return this.card;
        }
        catch (PCSCException pCSCException) {
            if (pCSCException.code == -2146434967) {
                throw new CardNotPresentException("No card present", pCSCException);
            }
            throw new CardException("connect() failed", pCSCException);
        }
    }

    @Override
    public boolean isCardPresent() throws CardException {
        try {
            int[] nArray = PCSC.SCardGetStatusChange(this.contextId, 0L, new int[]{0}, new String[]{this.name});
            return (nArray[0] & 0x20) != 0;
        }
        catch (PCSCException pCSCException) {
            throw new CardException("isCardPresent() failed", pCSCException);
        }
    }

    private boolean waitForCard(boolean bl, long l) throws CardException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout must not be negative");
        }
        if (l == 0L) {
            l = -1L;
        }
        int[] nArray = new int[]{0};
        String[] stringArray = new String[]{this.name};
        try {
            boolean bl2;
            nArray = PCSC.SCardGetStatusChange(this.contextId, 0L, nArray, stringArray);
            boolean bl3 = bl2 = (nArray[0] & 0x20) != 0;
            if (bl == bl2) {
                return true;
            }
            long l2 = System.currentTimeMillis() + l;
            while (bl != bl2 && l != 0L) {
                if (l != -1L) {
                    l = Math.max(l2 - System.currentTimeMillis(), 0L);
                }
                bl2 = ((nArray = PCSC.SCardGetStatusChange(this.contextId, l, nArray, stringArray))[0] & 0x20) != 0;
            }
            return bl == bl2;
        }
        catch (PCSCException pCSCException) {
            if (pCSCException.code == -2146435062) {
                return false;
            }
            throw new CardException("waitForCard() failed", pCSCException);
        }
    }

    @Override
    public boolean waitForCardPresent(long l) throws CardException {
        return this.waitForCard(true, l);
    }

    @Override
    public boolean waitForCardAbsent(long l) throws CardException {
        return this.waitForCard(false, l);
    }

    public String toString() {
        return "PC/SC terminal " + this.name;
    }
}

