/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.GapContent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.Map;
import javax.swing.text.html.Option;
import javax.swing.text.html.OptionComboBoxModel;
import javax.swing.text.html.OptionListModel;
import javax.swing.text.html.StyleSheet;
import javax.swing.text.html.TextAreaDocument;
import javax.swing.undo.UndoableEdit;
import sun.swing.SwingUtilities2;

public class HTMLDocument
extends DefaultStyledDocument {
    private boolean frameDocument = false;
    private boolean preservesUnknownTags = true;
    private HashMap<String, ButtonGroup> radioButtonGroupsMap;
    static final String TokenThreshold = "token threshold";
    private static final int MaxThreshold = 10000;
    private static final int StepThreshold = 5;
    public static final String AdditionalComments = "AdditionalComments";
    static final String StyleType = "StyleType";
    URL base;
    boolean hasBaseTag = false;
    private String baseTarget = null;
    private HTMLEditorKit.Parser parser;
    private static AttributeSet contentAttributeSet;
    static String MAP_PROPERTY;
    private static char[] NEWLINE;
    private boolean insertInBody = false;
    private static final String I18NProperty = "i18n";

    public HTMLDocument() {
        this((AbstractDocument.Content)new GapContent(4096), new StyleSheet());
    }

    public HTMLDocument(StyleSheet styleSheet) {
        this((AbstractDocument.Content)new GapContent(4096), styleSheet);
    }

    public HTMLDocument(AbstractDocument.Content content, StyleSheet styleSheet) {
        super(content, styleSheet);
    }

    public HTMLEditorKit.ParserCallback getReader(int n) {
        Object object = this.getProperty("stream");
        if (object instanceof URL) {
            this.setBase((URL)object);
        }
        HTMLReader hTMLReader = new HTMLReader(n);
        return hTMLReader;
    }

    public HTMLEditorKit.ParserCallback getReader(int n, int n2, int n3, HTML.Tag tag) {
        return this.getReader(n, n2, n3, tag, true);
    }

    HTMLEditorKit.ParserCallback getReader(int n, int n2, int n3, HTML.Tag tag, boolean bl) {
        Object object = this.getProperty("stream");
        if (object instanceof URL) {
            this.setBase((URL)object);
        }
        HTMLReader hTMLReader = new HTMLReader(n, n2, n3, tag, bl, false, true);
        return hTMLReader;
    }

    public URL getBase() {
        return this.base;
    }

    public void setBase(URL uRL) {
        this.base = uRL;
        this.getStyleSheet().setBase(uRL);
    }

    @Override
    protected void insert(int n, DefaultStyledDocument.ElementSpec[] elementSpecArray) throws BadLocationException {
        super.insert(n, elementSpecArray);
    }

    @Override
    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        if (attributeSet == null) {
            attributeSet = contentAttributeSet;
        } else if (attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) {
            ((MutableAttributeSet)attributeSet).addAttributes(contentAttributeSet);
        }
        if (attributeSet.isDefined("CR")) {
            ((MutableAttributeSet)attributeSet).removeAttribute("CR");
        }
        super.insertUpdate(defaultDocumentEvent, attributeSet);
    }

    @Override
    protected void create(DefaultStyledDocument.ElementSpec[] elementSpecArray) {
        super.create(elementSpecArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParagraphAttributes(int n, int n2, AttributeSet attributeSet, boolean bl) {
        try {
            this.writeLock();
            int n3 = Math.min(n + n2, this.getLength());
            Element element = this.getParagraphElement(n);
            n = element.getStartOffset();
            element = this.getParagraphElement(n3);
            n2 = Math.max(0, element.getEndOffset() - n);
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, n, n2, DocumentEvent.EventType.CHANGE);
            AttributeSet attributeSet2 = attributeSet.copyAttributes();
            int n4 = Integer.MAX_VALUE;
            int n5 = n;
            while (n5 <= n3) {
                Element element2 = this.getParagraphElement(n5);
                n4 = n4 == element2.getEndOffset() ? ++n4 : element2.getEndOffset();
                MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element2.getAttributes();
                defaultDocumentEvent.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(element2, attributeSet2, bl));
                if (bl) {
                    mutableAttributeSet.removeAttributes(mutableAttributeSet);
                }
                mutableAttributeSet.addAttributes(attributeSet);
                n5 = n4;
            }
            defaultDocumentEvent.end();
            this.fireChangedUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
        finally {
            this.writeUnlock();
        }
    }

    public StyleSheet getStyleSheet() {
        return (StyleSheet)this.getAttributeContext();
    }

    public Iterator getIterator(HTML.Tag tag) {
        if (tag.isBlock()) {
            return null;
        }
        return new LeafIterator(tag, this);
    }

    @Override
    protected Element createLeafElement(Element element, AttributeSet attributeSet, int n, int n2) {
        return new RunElement(element, attributeSet, n, n2);
    }

    @Override
    protected Element createBranchElement(Element element, AttributeSet attributeSet) {
        return new BlockElement(element, attributeSet);
    }

    @Override
    protected AbstractDocument.AbstractElement createDefaultRoot() {
        this.writeLock();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.HTML);
        BlockElement blockElement = new BlockElement(null, simpleAttributeSet.copyAttributes());
        simpleAttributeSet.removeAttributes(simpleAttributeSet);
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.BODY);
        BlockElement blockElement2 = new BlockElement((Element)blockElement, simpleAttributeSet.copyAttributes());
        simpleAttributeSet.removeAttributes(simpleAttributeSet);
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.P);
        this.getStyleSheet().addCSSAttributeFromHTML(simpleAttributeSet, CSS.Attribute.MARGIN_TOP, "0");
        BlockElement blockElement3 = new BlockElement((Element)blockElement2, simpleAttributeSet.copyAttributes());
        simpleAttributeSet.removeAttributes(simpleAttributeSet);
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
        RunElement runElement = new RunElement((Element)blockElement3, (AttributeSet)simpleAttributeSet, 0, 1);
        Element[] elementArray = new Element[]{runElement};
        blockElement3.replace(0, 0, elementArray);
        elementArray[0] = blockElement3;
        blockElement2.replace(0, 0, elementArray);
        elementArray[0] = blockElement2;
        blockElement.replace(0, 0, elementArray);
        this.writeUnlock();
        return blockElement;
    }

    public void setTokenThreshold(int n) {
        this.putProperty(TokenThreshold, new Integer(n));
    }

    public int getTokenThreshold() {
        Integer n = (Integer)this.getProperty(TokenThreshold);
        if (n != null) {
            return n;
        }
        return Integer.MAX_VALUE;
    }

    public void setPreservesUnknownTags(boolean bl) {
        this.preservesUnknownTags = bl;
    }

    public boolean getPreservesUnknownTags() {
        return this.preservesUnknownTags;
    }

    public void processHTMLFrameHyperlinkEvent(HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent) {
        String string = hTMLFrameHyperlinkEvent.getTarget();
        Element element = hTMLFrameHyperlinkEvent.getSourceElement();
        String string2 = hTMLFrameHyperlinkEvent.getURL().toString();
        if (string.equals("_self")) {
            this.updateFrame(element, string2);
        } else if (string.equals("_parent")) {
            this.updateFrameSet(element.getParentElement(), string2);
        } else {
            Element element2 = this.findFrame(string);
            if (element2 != null) {
                this.updateFrame(element2, string2);
            }
        }
    }

    private Element findFrame(String string) {
        String string2;
        AttributeSet attributeSet;
        Element element;
        ElementIterator elementIterator = new ElementIterator(this);
        while (!((element = elementIterator.next()) == null || HTMLDocument.matchNameAttribute(attributeSet = element.getAttributes(), HTML.Tag.FRAME) && (string2 = (String)attributeSet.getAttribute(HTML.Attribute.NAME)) != null && string2.equals(string))) {
        }
        return element;
    }

    static boolean matchNameAttribute(AttributeSet attributeSet, HTML.Tag tag) {
        HTML.Tag tag2;
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        return object instanceof HTML.Tag && (tag2 = (HTML.Tag)object) == tag;
    }

    private void updateFrameSet(Element element, String string) {
        try {
            int n = element.getStartOffset();
            int n2 = Math.min(this.getLength(), element.getEndOffset());
            String string2 = "<frame";
            if (string != null) {
                string2 = string2 + " src=\"" + string + "\"";
            }
            string2 = string2 + ">";
            this.installParserIfNecessary();
            this.setOuterHTML(element, string2);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFrame(Element element, String string) {
        try {
            this.writeLock();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, element.getStartOffset(), 1, DocumentEvent.EventType.CHANGE);
            AttributeSet attributeSet = element.getAttributes().copyAttributes();
            MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element.getAttributes();
            defaultDocumentEvent.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(element, attributeSet, false));
            mutableAttributeSet.removeAttribute(HTML.Attribute.SRC);
            mutableAttributeSet.addAttribute(HTML.Attribute.SRC, string);
            defaultDocumentEvent.end();
            this.fireChangedUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
        finally {
            this.writeUnlock();
        }
    }

    boolean isFrameDocument() {
        return this.frameDocument;
    }

    void setFrameDocumentState(boolean bl) {
        this.frameDocument = bl;
    }

    void addMap(Map map) {
        String string = map.getName();
        if (string != null) {
            Hashtable<String, Map> hashtable = this.getProperty(MAP_PROPERTY);
            if (hashtable == null) {
                hashtable = new Hashtable<String, Map>(11);
                this.putProperty(MAP_PROPERTY, hashtable);
            }
            if (hashtable instanceof Hashtable) {
                hashtable.put("#" + string, map);
            }
        }
    }

    void removeMap(Map map) {
        Object object;
        String string = map.getName();
        if (string != null && (object = this.getProperty(MAP_PROPERTY)) instanceof Hashtable) {
            ((Hashtable)object).remove("#" + string);
        }
    }

    Map getMap(String string) {
        Object object;
        if (string != null && (object = this.getProperty(MAP_PROPERTY)) != null && object instanceof Hashtable) {
            return (Map)((Hashtable)object).get(string);
        }
        return null;
    }

    Enumeration getMaps() {
        Object object = this.getProperty(MAP_PROPERTY);
        if (object instanceof Hashtable) {
            return ((Hashtable)object).elements();
        }
        return null;
    }

    void setDefaultStyleSheetType(String string) {
        this.putProperty(StyleType, string);
    }

    String getDefaultStyleSheetType() {
        String string = (String)this.getProperty(StyleType);
        if (string == null) {
            return "text/css";
        }
        return string;
    }

    public void setParser(HTMLEditorKit.Parser parser) {
        this.parser = parser;
        this.putProperty("__PARSER__", null);
    }

    public HTMLEditorKit.Parser getParser() {
        Object object = this.getProperty("__PARSER__");
        if (object instanceof HTMLEditorKit.Parser) {
            return (HTMLEditorKit.Parser)object;
        }
        return this.parser;
    }

    public void setInnerHTML(Element element, String string) throws BadLocationException, IOException {
        this.verifyParser();
        if (element != null && element.isLeaf()) {
            throw new IllegalArgumentException("Can not set inner HTML of a leaf");
        }
        if (element != null && string != null) {
            int n = element.getElementCount();
            int n2 = element.getStartOffset();
            this.insertHTML(element, element.getStartOffset(), string, true);
            if (element.getElementCount() > n) {
                this.removeElements(element, element.getElementCount() - n, n);
            }
        }
    }

    public void setOuterHTML(Element element, String string) throws BadLocationException, IOException {
        this.verifyParser();
        if (element != null && element.getParentElement() != null && string != null) {
            boolean bl;
            int n = element.getStartOffset();
            int n2 = element.getEndOffset();
            int n3 = this.getLength();
            boolean bl2 = bl = !element.isLeaf();
            if (!(bl || n2 <= n3 && this.getText(n2 - 1, 1).charAt(0) != NEWLINE[0])) {
                bl = true;
            }
            Element element2 = element.getParentElement();
            int n4 = element2.getElementCount();
            this.insertHTML(element2, n, string, bl);
            int n5 = this.getLength();
            if (n4 != element2.getElementCount()) {
                int n6 = element2.getElementIndex(n + n5 - n3);
                this.removeElements(element2, n6, 1);
            }
        }
    }

    public void insertAfterStart(Element element, String string) throws BadLocationException, IOException {
        this.verifyParser();
        if (element != null && element.isLeaf()) {
            throw new IllegalArgumentException("Can not insert HTML after start of a leaf");
        }
        this.insertHTML(element, element.getStartOffset(), string, false);
    }

    public void insertBeforeEnd(Element element, String string) throws BadLocationException, IOException {
        this.verifyParser();
        if (element != null && element.isLeaf()) {
            throw new IllegalArgumentException("Can not set inner HTML before end of leaf");
        }
        if (element != null) {
            int n = element.getEndOffset();
            if (element.getElement(element.getElementIndex(n - 1)).isLeaf() && this.getText(n - 1, 1).charAt(0) == NEWLINE[0]) {
                --n;
            }
            this.insertHTML(element, n, string, false);
        }
    }

    public void insertBeforeStart(Element element, String string) throws BadLocationException, IOException {
        Element element2;
        this.verifyParser();
        if (element != null && (element2 = element.getParentElement()) != null) {
            this.insertHTML(element2, element.getStartOffset(), string, false);
        }
    }

    public void insertAfterEnd(Element element, String string) throws BadLocationException, IOException {
        Element element2;
        this.verifyParser();
        if (element != null && (element2 = element.getParentElement()) != null) {
            int n;
            if (HTML.Tag.BODY.name.equals(element2.getName())) {
                this.insertInBody = true;
            }
            if ((n = element.getEndOffset()) > this.getLength() + 1) {
                --n;
            } else if (element.isLeaf() && this.getText(n - 1, 1).charAt(0) == NEWLINE[0]) {
                --n;
            }
            this.insertHTML(element2, n, string, false);
            if (this.insertInBody) {
                this.insertInBody = false;
            }
        }
    }

    public Element getElement(String string) {
        if (string == null) {
            return null;
        }
        return this.getElement(this.getDefaultRootElement(), HTML.Attribute.ID, string, true);
    }

    public Element getElement(Element element, Object object, Object object2) {
        return this.getElement(element, object, object2, true);
    }

    private Element getElement(Element element, Object object, Object object2, boolean bl) {
        block4: {
            Enumeration<?> enumeration;
            AttributeSet attributeSet;
            block3: {
                attributeSet = element.getAttributes();
                if (attributeSet != null && attributeSet.isDefined(object) && object2.equals(attributeSet.getAttribute(object))) {
                    return element;
                }
                if (element.isLeaf()) break block3;
                int n = element.getElementCount();
                for (int i = 0; i < n; ++i) {
                    Element element2 = this.getElement(element.getElement(i), object, object2, bl);
                    if (element2 == null) continue;
                    return element2;
                }
                break block4;
            }
            if (!bl || attributeSet == null || (enumeration = attributeSet.getAttributeNames()) == null) break block4;
            while (enumeration.hasMoreElements()) {
                AttributeSet attributeSet2;
                Object obj = enumeration.nextElement();
                if (!(obj instanceof HTML.Tag) || !(attributeSet.getAttribute(obj) instanceof AttributeSet) || !(attributeSet2 = (AttributeSet)attributeSet.getAttribute(obj)).isDefined(object) || !object2.equals(attributeSet2.getAttribute(object))) continue;
                return element;
            }
        }
        return null;
    }

    private void verifyParser() {
        if (this.getParser() == null) {
            throw new IllegalStateException("No HTMLEditorKit.Parser");
        }
    }

    private void installParserIfNecessary() {
        if (this.getParser() == null) {
            this.setParser(new HTMLEditorKit().getParser());
        }
    }

    private void insertHTML(Element element, int n, String string, boolean bl) throws BadLocationException, IOException {
        HTMLEditorKit.Parser parser;
        if (element != null && string != null && (parser = this.getParser()) != null) {
            int n2 = Math.max(0, n - 1);
            Element element2 = this.getCharacterElement(n2);
            Element element3 = element;
            int n3 = 0;
            int n4 = 0;
            if (element.getStartOffset() > n2) {
                while (element3 != null && element3.getStartOffset() > n2) {
                    element3 = element3.getParentElement();
                    ++n4;
                }
                if (element3 == null) {
                    throw new BadLocationException("No common parent", n);
                }
            }
            while (element2 != null && element2 != element3) {
                ++n3;
                element2 = element2.getParentElement();
            }
            if (element2 != null) {
                HTMLReader hTMLReader = new HTMLReader(n, n3 - 1, n4, null, false, true, bl);
                parser.parse(new StringReader(string), hTMLReader, true);
                hTMLReader.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeElements(Element element, int n, int n2) throws BadLocationException {
        this.writeLock();
        try {
            int n3 = element.getElement(n).getStartOffset();
            int n4 = element.getElement(n + n2 - 1).getEndOffset();
            if (n4 > this.getLength()) {
                this.removeElementsAtEnd(element, n, n2, n3, n4);
            } else {
                this.removeElements(element, n, n2, n3, n4);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private void removeElementsAtEnd(Element element, int n, int n2, int n3, int n4) throws BadLocationException {
        boolean bl = element.getElement(n - 1).isLeaf();
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, n3 - 1, n4 - n3 + 1, DocumentEvent.EventType.REMOVE);
        if (bl) {
            Element element2 = this.getCharacterElement(this.getLength());
            --n;
            if (element2.getParentElement() != element) {
                this.replace(defaultDocumentEvent, element, n, ++n2, n3, n4, true, true);
            } else {
                this.replace(defaultDocumentEvent, element, n, n2, n3, n4, true, false);
            }
        } else {
            Element element3 = element.getElement(n - 1);
            while (!element3.isLeaf()) {
                element3 = element3.getElement(element3.getElementCount() - 1);
            }
            element3 = element3.getParentElement();
            this.replace(defaultDocumentEvent, element, n, n2, n3, n4, false, false);
            this.replace(defaultDocumentEvent, element3, element3.getElementCount() - 1, 1, n3, n4, true, true);
        }
        this.postRemoveUpdate(defaultDocumentEvent);
        defaultDocumentEvent.end();
        this.fireRemoveUpdate(defaultDocumentEvent);
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
    }

    private void replace(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, Element element, int n, int n2, int n3, int n4, boolean bl, boolean bl2) throws BadLocationException {
        UndoableEdit undoableEdit;
        AttributeSet attributeSet = element.getElement(n).getAttributes();
        Element[] elementArray = new Element[n2];
        for (int i = 0; i < n2; ++i) {
            elementArray[i] = element.getElement(i + n);
        }
        if (bl && (undoableEdit = this.getContent().remove(n3 - 1, n4 - n3)) != null) {
            defaultDocumentEvent.addEdit(undoableEdit);
        }
        Element[] elementArray2 = bl2 ? new Element[]{this.createLeafElement(element, attributeSet, n3 - 1, n3)} : new Element[]{};
        defaultDocumentEvent.addEdit(new AbstractDocument.ElementEdit(element, n, elementArray, elementArray2));
        ((AbstractDocument.BranchElement)element).replace(n, elementArray.length, elementArray2);
    }

    private void removeElements(Element element, int n, int n2, int n3, int n4) throws BadLocationException {
        Element[] elementArray = new Element[n2];
        Element[] elementArray2 = new Element[]{};
        for (int i = 0; i < n2; ++i) {
            elementArray[i] = element.getElement(i + n);
        }
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, n3, n4 - n3, DocumentEvent.EventType.REMOVE);
        ((AbstractDocument.BranchElement)element).replace(n, elementArray.length, elementArray2);
        defaultDocumentEvent.addEdit(new AbstractDocument.ElementEdit(element, n, elementArray, elementArray2));
        UndoableEdit undoableEdit = this.getContent().remove(n3, n4 - n3);
        if (undoableEdit != null) {
            defaultDocumentEvent.addEdit(undoableEdit);
        }
        this.postRemoveUpdate(defaultDocumentEvent);
        defaultDocumentEvent.end();
        this.fireRemoveUpdate(defaultDocumentEvent);
        if (undoableEdit != null) {
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
    }

    void obtainLock() {
        this.writeLock();
    }

    void releaseLock() {
        this.writeUnlock();
    }

    @Override
    protected void fireChangedUpdate(DocumentEvent documentEvent) {
        super.fireChangedUpdate(documentEvent);
    }

    @Override
    protected void fireUndoableEditUpdate(UndoableEditEvent undoableEditEvent) {
        super.fireUndoableEditUpdate(undoableEditEvent);
    }

    boolean hasBaseTag() {
        return this.hasBaseTag;
    }

    String getBaseTarget() {
        return this.baseTarget;
    }

    static {
        MAP_PROPERTY = "__MAP__";
        contentAttributeSet = new SimpleAttributeSet();
        ((MutableAttributeSet)contentAttributeSet).addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
        NEWLINE = new char[1];
        HTMLDocument.NEWLINE[0] = 10;
    }

    public class BlockElement
    extends AbstractDocument.BranchElement {
        public BlockElement(Element element, AttributeSet attributeSet) {
            super(HTMLDocument.this, element, attributeSet);
        }

        @Override
        public String getName() {
            Object object = this.getAttribute(StyleConstants.NameAttribute);
            if (object != null) {
                return object.toString();
            }
            return super.getName();
        }

        @Override
        public AttributeSet getResolveParent() {
            return null;
        }
    }

    private static class FixedLengthDocument
    extends PlainDocument {
        private int maxLength;

        public FixedLengthDocument(int n) {
            this.maxLength = n;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string != null && string.length() + this.getLength() <= this.maxLength) {
                super.insertString(n, string, attributeSet);
            }
        }
    }

    public class HTMLReader
    extends HTMLEditorKit.ParserCallback {
        private boolean receivedEndHTML;
        private int flushCount;
        private boolean insertAfterImplied;
        private boolean wantsTrailingNewline;
        int threshold;
        int offset;
        boolean inParagraph = false;
        boolean impliedP = false;
        boolean inPre = false;
        boolean inTextArea = false;
        TextAreaDocument textAreaDocument = null;
        boolean inTitle = false;
        boolean lastWasNewline = true;
        boolean emptyAnchor;
        boolean midInsert;
        boolean inBody;
        HTML.Tag insertTag;
        boolean insertInsertTag;
        boolean foundInsertTag;
        int insertTagDepthDelta;
        int popDepth;
        int pushDepth;
        Map lastMap;
        boolean inStyle = false;
        String defaultStyle;
        Vector<Object> styles;
        boolean inHead = false;
        boolean isStyleCSS;
        boolean emptyDocument;
        AttributeSet styleAttributes;
        Option option;
        protected Vector<DefaultStyledDocument.ElementSpec> parseBuffer = new Vector();
        protected MutableAttributeSet charAttr = new TaggedAttributeSet();
        Stack<AttributeSet> charAttrStack = new Stack();
        Hashtable<HTML.Tag, TagAction> tagMap;
        int inBlock = 0;
        private HTML.Tag nextTagAfterPImplied = null;

        public HTMLReader(int n) {
            this(n, 0, 0, null);
        }

        public HTMLReader(int n, int n2, int n3, HTML.Tag tag) {
            this(n, n2, n3, tag, true, false, true);
        }

        HTMLReader(int n, int n2, int n3, HTML.Tag tag, boolean bl, boolean bl2, boolean bl3) {
            this.emptyDocument = HTMLDocument.this.getLength() == 0;
            this.isStyleCSS = "text/css".equals(HTMLDocument.this.getDefaultStyleSheetType());
            this.offset = n;
            this.threshold = HTMLDocument.this.getTokenThreshold();
            this.tagMap = new Hashtable(57);
            TagAction tagAction = new TagAction();
            BlockAction blockAction = new BlockAction();
            ParagraphAction paragraphAction = new ParagraphAction();
            CharacterAction characterAction = new CharacterAction();
            SpecialAction specialAction = new SpecialAction();
            FormAction formAction = new FormAction();
            HiddenAction hiddenAction = new HiddenAction();
            ConvertAction convertAction = new ConvertAction();
            this.tagMap.put(HTML.Tag.A, new AnchorAction());
            this.tagMap.put(HTML.Tag.ADDRESS, characterAction);
            this.tagMap.put(HTML.Tag.APPLET, hiddenAction);
            this.tagMap.put(HTML.Tag.AREA, new AreaAction());
            this.tagMap.put(HTML.Tag.B, convertAction);
            this.tagMap.put(HTML.Tag.BASE, new BaseAction());
            this.tagMap.put(HTML.Tag.BASEFONT, characterAction);
            this.tagMap.put(HTML.Tag.BIG, characterAction);
            this.tagMap.put(HTML.Tag.BLOCKQUOTE, blockAction);
            this.tagMap.put(HTML.Tag.BODY, blockAction);
            this.tagMap.put(HTML.Tag.BR, specialAction);
            this.tagMap.put(HTML.Tag.CAPTION, blockAction);
            this.tagMap.put(HTML.Tag.CENTER, blockAction);
            this.tagMap.put(HTML.Tag.CITE, characterAction);
            this.tagMap.put(HTML.Tag.CODE, characterAction);
            this.tagMap.put(HTML.Tag.DD, blockAction);
            this.tagMap.put(HTML.Tag.DFN, characterAction);
            this.tagMap.put(HTML.Tag.DIR, blockAction);
            this.tagMap.put(HTML.Tag.DIV, blockAction);
            this.tagMap.put(HTML.Tag.DL, blockAction);
            this.tagMap.put(HTML.Tag.DT, paragraphAction);
            this.tagMap.put(HTML.Tag.EM, characterAction);
            this.tagMap.put(HTML.Tag.FONT, convertAction);
            this.tagMap.put(HTML.Tag.FORM, new FormTagAction());
            this.tagMap.put(HTML.Tag.FRAME, specialAction);
            this.tagMap.put(HTML.Tag.FRAMESET, blockAction);
            this.tagMap.put(HTML.Tag.H1, paragraphAction);
            this.tagMap.put(HTML.Tag.H2, paragraphAction);
            this.tagMap.put(HTML.Tag.H3, paragraphAction);
            this.tagMap.put(HTML.Tag.H4, paragraphAction);
            this.tagMap.put(HTML.Tag.H5, paragraphAction);
            this.tagMap.put(HTML.Tag.H6, paragraphAction);
            this.tagMap.put(HTML.Tag.HEAD, new HeadAction());
            this.tagMap.put(HTML.Tag.HR, specialAction);
            this.tagMap.put(HTML.Tag.HTML, blockAction);
            this.tagMap.put(HTML.Tag.I, convertAction);
            this.tagMap.put(HTML.Tag.IMG, specialAction);
            this.tagMap.put(HTML.Tag.INPUT, formAction);
            this.tagMap.put(HTML.Tag.ISINDEX, new IsindexAction());
            this.tagMap.put(HTML.Tag.KBD, characterAction);
            this.tagMap.put(HTML.Tag.LI, blockAction);
            this.tagMap.put(HTML.Tag.LINK, new LinkAction());
            this.tagMap.put(HTML.Tag.MAP, new MapAction());
            this.tagMap.put(HTML.Tag.MENU, blockAction);
            this.tagMap.put(HTML.Tag.META, new MetaAction());
            this.tagMap.put(HTML.Tag.NOBR, characterAction);
            this.tagMap.put(HTML.Tag.NOFRAMES, blockAction);
            this.tagMap.put(HTML.Tag.OBJECT, specialAction);
            this.tagMap.put(HTML.Tag.OL, blockAction);
            this.tagMap.put(HTML.Tag.OPTION, formAction);
            this.tagMap.put(HTML.Tag.P, paragraphAction);
            this.tagMap.put(HTML.Tag.PARAM, new ObjectAction());
            this.tagMap.put(HTML.Tag.PRE, new PreAction());
            this.tagMap.put(HTML.Tag.SAMP, characterAction);
            this.tagMap.put(HTML.Tag.SCRIPT, hiddenAction);
            this.tagMap.put(HTML.Tag.SELECT, formAction);
            this.tagMap.put(HTML.Tag.SMALL, characterAction);
            this.tagMap.put(HTML.Tag.SPAN, characterAction);
            this.tagMap.put(HTML.Tag.STRIKE, convertAction);
            this.tagMap.put(HTML.Tag.S, characterAction);
            this.tagMap.put(HTML.Tag.STRONG, characterAction);
            this.tagMap.put(HTML.Tag.STYLE, new StyleAction());
            this.tagMap.put(HTML.Tag.SUB, convertAction);
            this.tagMap.put(HTML.Tag.SUP, convertAction);
            this.tagMap.put(HTML.Tag.TABLE, blockAction);
            this.tagMap.put(HTML.Tag.TD, blockAction);
            this.tagMap.put(HTML.Tag.TEXTAREA, formAction);
            this.tagMap.put(HTML.Tag.TH, blockAction);
            this.tagMap.put(HTML.Tag.TITLE, new TitleAction());
            this.tagMap.put(HTML.Tag.TR, blockAction);
            this.tagMap.put(HTML.Tag.TT, characterAction);
            this.tagMap.put(HTML.Tag.U, convertAction);
            this.tagMap.put(HTML.Tag.UL, blockAction);
            this.tagMap.put(HTML.Tag.VAR, characterAction);
            if (tag != null) {
                this.insertTag = tag;
                this.popDepth = n2;
                this.pushDepth = n3;
                this.insertInsertTag = bl;
                this.foundInsertTag = false;
            } else {
                this.foundInsertTag = true;
            }
            if (bl2) {
                this.popDepth = n2;
                this.pushDepth = n3;
                this.insertAfterImplied = true;
                this.foundInsertTag = false;
                this.midInsert = false;
                this.insertInsertTag = true;
                this.wantsTrailingNewline = bl3;
            } else {
                boolean bl4 = this.midInsert = !this.emptyDocument && tag == null;
                if (this.midInsert) {
                    this.generateEndsSpecsForMidInsert();
                }
            }
            if (!this.emptyDocument && !this.midInsert) {
                HTML.Tag tag2;
                int n4;
                int n5 = Math.max(this.offset - 1, 0);
                Element element = HTMLDocument.this.getCharacterElement(n5);
                for (n4 = 0; n4 <= this.popDepth; ++n4) {
                    element = element.getParentElement();
                }
                for (n4 = 0; n4 < this.pushDepth; ++n4) {
                    int n6 = element.getElementIndex(this.offset);
                    element = element.getElement(n6);
                }
                AttributeSet attributeSet = element.getAttributes();
                if (attributeSet != null && (tag2 = (HTML.Tag)attributeSet.getAttribute(StyleConstants.NameAttribute)) != null) {
                    this.inParagraph = tag2.isParagraph();
                }
            }
        }

        private void generateEndsSpecsForMidInsert() {
            int n = this.heightToElementWithName(HTML.Tag.BODY, Math.max(0, this.offset - 1));
            boolean bl = false;
            if (n == -1 && this.offset > 0 && (n = this.heightToElementWithName(HTML.Tag.BODY, this.offset)) != -1) {
                n = this.depthTo(this.offset - 1) - 1;
                bl = true;
            }
            if (n == -1) {
                throw new RuntimeException("Must insert new content into body element-");
            }
            if (n != -1) {
                Object object;
                try {
                    if (!bl && this.offset > 0 && !HTMLDocument.this.getText(this.offset - 1, 1).equals("\n")) {
                        object = new SimpleAttributeSet();
                        ((SimpleAttributeSet)object).addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                        DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec((AttributeSet)object, 3, NEWLINE, 0, 1);
                        this.parseBuffer.addElement(elementSpec);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                while (n-- > 0) {
                    this.parseBuffer.addElement(new DefaultStyledDocument.ElementSpec(null, 2));
                }
                if (bl) {
                    object = new DefaultStyledDocument.ElementSpec(null, 1);
                    ((DefaultStyledDocument.ElementSpec)object).setDirection((short)5);
                    this.parseBuffer.addElement((DefaultStyledDocument.ElementSpec)object);
                }
            }
        }

        private int depthTo(int n) {
            Element element = HTMLDocument.this.getDefaultRootElement();
            int n2 = 0;
            while (!element.isLeaf()) {
                ++n2;
                element = element.getElement(element.getElementIndex(n));
            }
            return n2;
        }

        private int heightToElementWithName(Object object, int n) {
            Element element;
            int n2 = 0;
            for (element = HTMLDocument.this.getCharacterElement(n).getParentElement(); element != null && element.getAttributes().getAttribute(StyleConstants.NameAttribute) != object; element = element.getParentElement()) {
                ++n2;
            }
            return element == null ? -1 : n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void adjustEndElement() {
            int n = HTMLDocument.this.getLength();
            if (n == 0) {
                return;
            }
            HTMLDocument.this.obtainLock();
            try {
                Element[] elementArray = this.getPathTo(n - 1);
                int n2 = elementArray.length;
                if (n2 > 1 && elementArray[1].getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.BODY && elementArray[1].getEndOffset() == n) {
                    String string = HTMLDocument.this.getText(n - 1, 1);
                    Element[] elementArray2 = new Element[]{};
                    Element[] elementArray3 = new Element[1];
                    int n3 = elementArray[0].getElementIndex(n);
                    elementArray3[0] = elementArray[0].getElement(n3);
                    ((AbstractDocument.BranchElement)elementArray[0]).replace(n3, 1, elementArray2);
                    AbstractDocument.ElementEdit elementEdit = new AbstractDocument.ElementEdit(elementArray[0], n3, elementArray3, elementArray2);
                    SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                    simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                    simpleAttributeSet.addAttribute("CR", Boolean.TRUE);
                    elementArray2 = new Element[]{HTMLDocument.this.createLeafElement(elementArray[n2 - 1], simpleAttributeSet, n, n + 1)};
                    n3 = elementArray[n2 - 1].getElementCount();
                    ((AbstractDocument.BranchElement)elementArray[n2 - 1]).replace(n3, 0, elementArray2);
                    AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(HTMLDocument.this, n, 1, DocumentEvent.EventType.CHANGE);
                    defaultDocumentEvent.addEdit(new AbstractDocument.ElementEdit(elementArray[n2 - 1], n3, new Element[0], elementArray2));
                    defaultDocumentEvent.addEdit(elementEdit);
                    defaultDocumentEvent.end();
                    HTMLDocument.this.fireChangedUpdate(defaultDocumentEvent);
                    HTMLDocument.this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
                    if (string.equals("\n")) {
                        defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(HTMLDocument.this, n - 1, 1, DocumentEvent.EventType.REMOVE);
                        HTMLDocument.this.removeUpdate(defaultDocumentEvent);
                        UndoableEdit undoableEdit = HTMLDocument.this.getContent().remove(n - 1, 1);
                        if (undoableEdit != null) {
                            defaultDocumentEvent.addEdit(undoableEdit);
                        }
                        HTMLDocument.this.postRemoveUpdate(defaultDocumentEvent);
                        defaultDocumentEvent.end();
                        HTMLDocument.this.fireRemoveUpdate(defaultDocumentEvent);
                        HTMLDocument.this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
                    }
                }
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                HTMLDocument.this.releaseLock();
            }
        }

        private Element[] getPathTo(int n) {
            Stack<Element> stack = new Stack<Element>();
            Element element = HTMLDocument.this.getDefaultRootElement();
            while (!element.isLeaf()) {
                stack.push(element);
                element = element.getElement(element.getElementIndex(n));
            }
            Object[] objectArray = new Element[stack.size()];
            stack.copyInto(objectArray);
            return objectArray;
        }

        @Override
        public void flush() throws BadLocationException {
            if (this.emptyDocument && !this.insertAfterImplied) {
                if (HTMLDocument.this.getLength() > 0 || this.parseBuffer.size() > 0) {
                    this.flushBuffer(true);
                    this.adjustEndElement();
                }
            } else {
                this.flushBuffer(true);
            }
        }

        @Override
        public void handleText(char[] cArray, int n) {
            if (this.receivedEndHTML || this.midInsert && !this.inBody) {
                return;
            }
            if (HTMLDocument.this.getProperty(HTMLDocument.I18NProperty).equals(Boolean.FALSE)) {
                Object object = HTMLDocument.this.getProperty(TextAttribute.RUN_DIRECTION);
                if (object != null && object.equals(TextAttribute.RUN_DIRECTION_RTL)) {
                    HTMLDocument.this.putProperty(HTMLDocument.I18NProperty, Boolean.TRUE);
                } else if (SwingUtilities2.isComplexLayout(cArray, 0, cArray.length)) {
                    HTMLDocument.this.putProperty(HTMLDocument.I18NProperty, Boolean.TRUE);
                }
            }
            if (this.inTextArea) {
                this.textAreaContent(cArray);
            } else if (this.inPre) {
                this.preContent(cArray);
            } else if (this.inTitle) {
                HTMLDocument.this.putProperty("title", new String(cArray));
            } else if (this.option != null) {
                this.option.setLabel(new String(cArray));
            } else if (this.inStyle) {
                if (this.styles != null) {
                    this.styles.addElement(new String(cArray));
                }
            } else if (this.inBlock > 0) {
                if (!this.foundInsertTag && this.insertAfterImplied) {
                    this.foundInsertTag(false);
                    this.foundInsertTag = true;
                    this.impliedP = !HTMLDocument.this.insertInBody;
                    this.inParagraph = this.impliedP;
                }
                if (cArray.length >= 1) {
                    this.addContent(cArray, 0, cArray.length);
                }
            }
        }

        @Override
        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            Object object;
            if (this.receivedEndHTML) {
                return;
            }
            if (this.midInsert && !this.inBody) {
                if (tag == HTML.Tag.BODY) {
                    this.inBody = true;
                    ++this.inBlock;
                }
                return;
            }
            if (!this.inBody && tag == HTML.Tag.BODY) {
                this.inBody = true;
            }
            if (this.isStyleCSS && mutableAttributeSet.isDefined(HTML.Attribute.STYLE)) {
                object = (String)mutableAttributeSet.getAttribute(HTML.Attribute.STYLE);
                mutableAttributeSet.removeAttribute(HTML.Attribute.STYLE);
                this.styleAttributes = HTMLDocument.this.getStyleSheet().getDeclaration((String)object);
                mutableAttributeSet.addAttributes(this.styleAttributes);
            } else {
                this.styleAttributes = null;
            }
            object = this.tagMap.get(tag);
            if (object != null) {
                ((TagAction)object).start(tag, mutableAttributeSet);
            }
        }

        @Override
        public void handleComment(char[] cArray, int n) {
            Object object;
            if (this.receivedEndHTML) {
                this.addExternalComment(new String(cArray));
                return;
            }
            if (this.inStyle) {
                if (this.styles != null) {
                    this.styles.addElement(new String(cArray));
                }
            } else if (HTMLDocument.this.getPreservesUnknownTags()) {
                if (this.inBlock == 0 && (this.foundInsertTag || this.insertTag != HTML.Tag.COMMENT)) {
                    this.addExternalComment(new String(cArray));
                    return;
                }
                object = new SimpleAttributeSet();
                ((SimpleAttributeSet)object).addAttribute(HTML.Attribute.COMMENT, new String(cArray));
                this.addSpecialElement(HTML.Tag.COMMENT, (MutableAttributeSet)object);
            }
            if ((object = this.tagMap.get(HTML.Tag.COMMENT)) != null) {
                ((TagAction)object).start(HTML.Tag.COMMENT, new SimpleAttributeSet());
                ((TagAction)object).end(HTML.Tag.COMMENT);
            }
        }

        private void addExternalComment(String string) {
            Vector vector = HTMLDocument.this.getProperty(HTMLDocument.AdditionalComments);
            if (vector != null && !(vector instanceof Vector)) {
                return;
            }
            if (vector == null) {
                vector = new Vector();
                HTMLDocument.this.putProperty(HTMLDocument.AdditionalComments, vector);
            }
            ((Vector)vector).addElement(string);
        }

        @Override
        public void handleEndTag(HTML.Tag tag, int n) {
            TagAction tagAction;
            if (this.receivedEndHTML || this.midInsert && !this.inBody) {
                return;
            }
            if (tag == HTML.Tag.HTML) {
                this.receivedEndHTML = true;
            }
            if (tag == HTML.Tag.BODY) {
                this.inBody = false;
                if (this.midInsert) {
                    --this.inBlock;
                }
            }
            if ((tagAction = this.tagMap.get(tag)) != null) {
                tagAction.end(tag);
            }
        }

        @Override
        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            Object object;
            if (this.receivedEndHTML || this.midInsert && !this.inBody) {
                return;
            }
            if (this.isStyleCSS && mutableAttributeSet.isDefined(HTML.Attribute.STYLE)) {
                object = (String)mutableAttributeSet.getAttribute(HTML.Attribute.STYLE);
                mutableAttributeSet.removeAttribute(HTML.Attribute.STYLE);
                this.styleAttributes = HTMLDocument.this.getStyleSheet().getDeclaration((String)object);
                mutableAttributeSet.addAttributes(this.styleAttributes);
            } else {
                this.styleAttributes = null;
            }
            object = this.tagMap.get(tag);
            if (object != null) {
                ((TagAction)object).start(tag, mutableAttributeSet);
                ((TagAction)object).end(tag);
            } else if (HTMLDocument.this.getPreservesUnknownTags()) {
                this.addSpecialElement(tag, mutableAttributeSet);
            }
        }

        @Override
        public void handleEndOfLineString(String string) {
            if (this.emptyDocument && string != null) {
                HTMLDocument.this.putProperty("__EndOfLine__", string);
            }
        }

        protected void registerTag(HTML.Tag tag, TagAction tagAction) {
            this.tagMap.put(tag, tagAction);
        }

        protected void pushCharacterStyle() {
            this.charAttrStack.push(this.charAttr.copyAttributes());
        }

        protected void popCharacterStyle() {
            if (!this.charAttrStack.empty()) {
                this.charAttr = (MutableAttributeSet)this.charAttrStack.peek();
                this.charAttrStack.pop();
            }
        }

        protected void textAreaContent(char[] cArray) {
            try {
                this.textAreaDocument.insertString(this.textAreaDocument.getLength(), new String(cArray), null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        protected void preContent(char[] cArray) {
            int n = 0;
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] != '\n') continue;
                this.addContent(cArray, n, i - n + 1);
                this.blockClose(HTML.Tag.IMPLIED);
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                simpleAttributeSet.addAttribute(CSS.Attribute.WHITE_SPACE, "pre");
                this.blockOpen(HTML.Tag.IMPLIED, simpleAttributeSet);
                n = i + 1;
            }
            if (n < cArray.length) {
                this.addContent(cArray, n, cArray.length - n);
            }
        }

        protected void blockOpen(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            if (this.impliedP) {
                this.blockClose(HTML.Tag.IMPLIED);
            }
            ++this.inBlock;
            if (!this.canInsertTag(tag, mutableAttributeSet, true)) {
                return;
            }
            if (mutableAttributeSet.isDefined(IMPLIED)) {
                mutableAttributeSet.removeAttribute(IMPLIED);
            }
            this.lastWasNewline = false;
            mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, tag);
            DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(mutableAttributeSet.copyAttributes(), 1);
            this.parseBuffer.addElement(elementSpec);
        }

        protected void blockClose(HTML.Tag tag) {
            Object object;
            DefaultStyledDocument.ElementSpec elementSpec;
            --this.inBlock;
            if (!this.foundInsertTag) {
                return;
            }
            if (!this.lastWasNewline) {
                this.pushCharacterStyle();
                this.charAttr.addAttribute("CR", Boolean.TRUE);
                this.addContent(NEWLINE, 0, 1, true);
                this.popCharacterStyle();
                this.lastWasNewline = true;
            }
            if (this.impliedP) {
                this.impliedP = false;
                this.inParagraph = false;
                if (tag != HTML.Tag.IMPLIED) {
                    this.blockClose(HTML.Tag.IMPLIED);
                }
            }
            DefaultStyledDocument.ElementSpec elementSpec2 = elementSpec = this.parseBuffer.size() > 0 ? this.parseBuffer.lastElement() : null;
            if (elementSpec != null && elementSpec.getType() == 1) {
                object = new char[1];
                object[0] = 32;
                this.addContent((char[])object, 0, 1);
            }
            object = new DefaultStyledDocument.ElementSpec(null, 2);
            this.parseBuffer.addElement((DefaultStyledDocument.ElementSpec)object);
        }

        protected void addContent(char[] cArray, int n, int n2) {
            this.addContent(cArray, n, n2, true);
        }

        protected void addContent(char[] cArray, int n, int n2, boolean bl) {
            if (!this.foundInsertTag) {
                return;
            }
            if (bl && !this.inParagraph && !this.inPre) {
                this.blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
                this.inParagraph = true;
                this.impliedP = true;
            }
            this.emptyAnchor = false;
            this.charAttr.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            AttributeSet attributeSet = this.charAttr.copyAttributes();
            DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(attributeSet, 3, cArray, n, n2);
            this.parseBuffer.addElement(elementSpec);
            if (this.parseBuffer.size() > this.threshold) {
                if (this.threshold <= 10000) {
                    this.threshold *= 5;
                }
                try {
                    this.flushBuffer(false);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (n2 > 0) {
                this.lastWasNewline = cArray[n + n2 - 1] == '\n';
            }
        }

        protected void addSpecialElement(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            if (tag != HTML.Tag.FRAME && !this.inParagraph && !this.inPre) {
                this.nextTagAfterPImplied = tag;
                this.blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
                this.nextTagAfterPImplied = null;
                this.inParagraph = true;
                this.impliedP = true;
            }
            if (!this.canInsertTag(tag, mutableAttributeSet, tag.isBlock())) {
                return;
            }
            if (mutableAttributeSet.isDefined(IMPLIED)) {
                mutableAttributeSet.removeAttribute(IMPLIED);
            }
            this.emptyAnchor = false;
            mutableAttributeSet.addAttributes(this.charAttr);
            mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, tag);
            char[] cArray = new char[]{' '};
            DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(mutableAttributeSet.copyAttributes(), 3, cArray, 0, 1);
            this.parseBuffer.addElement(elementSpec);
            if (tag == HTML.Tag.FRAME) {
                this.lastWasNewline = true;
            }
        }

        void flushBuffer(boolean bl) throws BadLocationException {
            int n = HTMLDocument.this.getLength();
            int n2 = this.parseBuffer.size();
            if (bl && (this.insertTag != null || this.insertAfterImplied) && n2 > 0) {
                this.adjustEndSpecsForPartialInsert();
                n2 = this.parseBuffer.size();
            }
            Object[] objectArray = new DefaultStyledDocument.ElementSpec[n2];
            this.parseBuffer.copyInto(objectArray);
            if (n == 0 && this.insertTag == null && !this.insertAfterImplied) {
                HTMLDocument.this.create((DefaultStyledDocument.ElementSpec[])objectArray);
            } else {
                HTMLDocument.this.insert(this.offset, (DefaultStyledDocument.ElementSpec[])objectArray);
            }
            this.parseBuffer.removeAllElements();
            this.offset += HTMLDocument.this.getLength() - n;
            ++this.flushCount;
        }

        private void adjustEndSpecsForPartialInsert() {
            int n;
            int n2 = this.parseBuffer.size();
            if (this.insertTagDepthDelta < 0) {
                for (n = this.insertTagDepthDelta; n < 0 && n2 >= 0 && this.parseBuffer.elementAt(n2 - 1).getType() == 2; ++n) {
                    this.parseBuffer.removeElementAt(--n2);
                }
            }
            if (!(this.flushCount != 0 || this.insertAfterImplied && this.wantsTrailingNewline)) {
                n = 0;
                if (this.pushDepth > 0 && this.parseBuffer.elementAt(0).getType() == 3) {
                    ++n;
                }
                int n3 = 0;
                int n4 = n += this.popDepth + this.pushDepth;
                while (n < n2 && this.parseBuffer.elementAt(n).getType() == 3) {
                    ++n;
                    ++n3;
                }
                if (n3 > 1) {
                    char[] cArray;
                    while (n < n2 && this.parseBuffer.elementAt(n).getType() == 2) {
                        ++n;
                    }
                    if (n == n2 && (cArray = this.parseBuffer.elementAt(n4 + n3 - 1).getArray()).length == 1 && cArray[0] == NEWLINE[0]) {
                        n = n4 + n3 - 1;
                        while (n2 > n) {
                            this.parseBuffer.removeElementAt(--n2);
                        }
                    }
                }
            }
            if (this.wantsTrailingNewline) {
                for (n = this.parseBuffer.size() - 1; n >= 0; --n) {
                    DefaultStyledDocument.ElementSpec elementSpec = this.parseBuffer.elementAt(n);
                    if (elementSpec.getType() != 3) continue;
                    if (elementSpec.getArray()[elementSpec.getLength() - 1] == '\n') break;
                    SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                    simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                    this.parseBuffer.insertElementAt(new DefaultStyledDocument.ElementSpec(simpleAttributeSet, 3, NEWLINE, 0, 1), n + 1);
                    break;
                }
            }
        }

        void addCSSRules(String string) {
            StyleSheet styleSheet = HTMLDocument.this.getStyleSheet();
            styleSheet.addRule(string);
        }

        void linkCSSStyleSheet(String string) {
            URL uRL;
            try {
                uRL = new URL(HTMLDocument.this.base, string);
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException2) {
                    uRL = null;
                }
            }
            if (uRL != null) {
                HTMLDocument.this.getStyleSheet().importStyleSheet(uRL);
            }
        }

        private boolean canInsertTag(HTML.Tag tag, AttributeSet attributeSet, boolean bl) {
            if (!this.foundInsertTag) {
                boolean bl2;
                boolean bl3;
                boolean bl4 = bl3 = tag == HTML.Tag.IMPLIED && !this.inParagraph && !this.inPre;
                if (bl3 && this.nextTagAfterPImplied != null ? this.insertTag != null && (!(bl2 = this.isInsertTag(this.nextTagAfterPImplied)) || !this.insertInsertTag) : this.insertTag != null && !this.isInsertTag(tag) || this.insertAfterImplied && (attributeSet == null || attributeSet.isDefined(IMPLIED) || tag == HTML.Tag.IMPLIED)) {
                    return false;
                }
                this.foundInsertTag(bl);
                if (!this.insertInsertTag) {
                    return false;
                }
            }
            return true;
        }

        private boolean isInsertTag(HTML.Tag tag) {
            return this.insertTag == tag;
        }

        private void foundInsertTag(boolean bl) {
            int n;
            this.foundInsertTag = true;
            if (!(this.insertAfterImplied || this.popDepth <= 0 && this.pushDepth <= 0)) {
                try {
                    if (this.offset == 0 || !HTMLDocument.this.getText(this.offset - 1, 1).equals("\n")) {
                        Object object;
                        SimpleAttributeSet simpleAttributeSet = null;
                        boolean bl2 = true;
                        if (this.offset != 0) {
                            object = HTMLDocument.this.getCharacterElement(this.offset - 1);
                            AttributeSet attributeSet = object.getAttributes();
                            if (attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) {
                                bl2 = false;
                            } else {
                                HTML.Tag tag;
                                Object object2 = attributeSet.getAttribute(StyleConstants.NameAttribute);
                                if (object2 instanceof HTML.Tag && ((tag = (HTML.Tag)object2) == HTML.Tag.IMG || tag == HTML.Tag.HR || tag == HTML.Tag.COMMENT || tag instanceof HTML.UnknownTag)) {
                                    bl2 = false;
                                }
                            }
                        }
                        if (!bl2) {
                            simpleAttributeSet = new SimpleAttributeSet();
                            simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                        }
                        object = new DefaultStyledDocument.ElementSpec(simpleAttributeSet, 3, NEWLINE, 0, NEWLINE.length);
                        if (bl2) {
                            ((DefaultStyledDocument.ElementSpec)object).setDirection((short)4);
                        }
                        this.parseBuffer.addElement((DefaultStyledDocument.ElementSpec)object);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            for (n = 0; n < this.popDepth; ++n) {
                this.parseBuffer.addElement(new DefaultStyledDocument.ElementSpec(null, 2));
            }
            for (n = 0; n < this.pushDepth; ++n) {
                DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(null, 1);
                elementSpec.setDirection((short)5);
                this.parseBuffer.addElement(elementSpec);
            }
            this.insertTagDepthDelta = this.depthTo(Math.max(0, this.offset - 1)) - this.popDepth + this.pushDepth - this.inBlock;
            if (bl) {
                ++this.insertTagDepthDelta;
            } else {
                --this.insertTagDepthDelta;
                this.inParagraph = true;
                this.lastWasNewline = false;
            }
        }

        class AnchorAction
        extends CharacterAction {
            AnchorAction() {
            }

            @Override
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.emptyAnchor = true;
                super.start(tag, mutableAttributeSet);
            }

            @Override
            public void end(HTML.Tag tag) {
                if (HTMLReader.this.emptyAnchor) {
                    char[] cArray = new char[]{'\n'};
                    HTMLReader.this.addContent(cArray, 0, 1);
                }
                super.end(tag);
            }
        }

        class AreaAction
        extends TagAction {
            AreaAction() {
            }

            @Override
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                if (HTMLReader.this.lastMap != null) {
                    HTMLReader.this.lastMap.addArea(mutableAttributeSet.copyAttributes());
                }
            }

            @Override
            public void end(HTML.Tag tag) {
            }
        }

        class BaseAction
        extends TagAction {
            BaseAction() {
            }

            @Override
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                String string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.HREF);
                if (string != null) {
                    try {
                        URL uRL = new URL(HTMLDocument.this.base, string);
                        HTMLDocument.this.setBase(uRL);
                        HTMLDocument.this.hasBaseTag = true;
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                HTMLDocument.this.baseTarget = (String)mutableAttributeSet.getAttribute(HTML.Attribute.TARGET);
            }
        }

        public class BlockAction
        extends TagAction {
            @Override
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.blockOpen(tag, mutableAttributeSet);
            }

            @Override
            public void end(HTML.Tag tag) {
                HTMLReader.this.blockClose(tag);
            }
        }

        public class CharacterAction
        extends TagAction {
            @Override
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.pushCharacterStyle();
                if (!HTMLReader.this.foundInsertTag) {
                    boolean bl = HTMLReader.this.canInsertTag(tag, mutableAttributeSet, false);
                    if (HTMLReader.this.foundInsertTag && !HTMLReader.this.inParagraph) {
                        HTMLReader.this.impliedP = true;
                        HTMLReader.this.inParagraph = true;
                    }
                    if (!bl) {
                        return;
                    }
                }
                if (mutableAttributeSet.isDefined(HTMLEditorKit.ParserCallback.IMPLIED)) {
                    mutableAttributeSet.removeAttribute(HTMLEditorKit.ParserCallback.IMPLIED);
                }
                HTMLReader.this.charAttr.addAttribute(tag, mutableAttributeSet.copyAttributes());
                if (HTMLReader.this.styleAttributes != null) {
                    HTMLReader.this.charAttr.addAttributes(HTMLReader.this.styleAttributes);
                }
            }

            @Override
            public void end(HTML.Tag tag) {
                HTMLReader.this.popCharacterStyle();
            }
        }

        class ConvertAction
        extends TagAction {
            ConvertAction() {
            }

            @Override
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.pushCharacterStyle();
                if (!HTMLReader.this.foundInsertTag) {
                    boolean bl = HTMLReader.this.canInsertTag(tag, mutableAttributeSet, false);
                    if (HTMLReader.this.foundInsertTag && !HTMLReader.this.inParagraph) {
                        HTMLReader.this.impliedP = true;
                        HTMLReader.this.inParagraph = true;
                    }
                    if (!bl) {
                        return;
                    }
                }
                if (mutableAttributeSet.isDefined(HTMLEditorKit.ParserCallback.IMPLIED)) {
                    mutableAttributeSet.removeAttribute(HTMLEditorKit.ParserCallback.IMPLIED);
                }
                if (HTMLReader.this.styleAttributes != null) {
                    HTMLReader.this.charAttr.addAttributes(HTMLReader.this.styleAttributes);
                }
                HTMLReader.this.charAttr.addAttribute(tag, mutableAttributeSet.copyAttributes());
                StyleSheet styleSheet = HTMLDocument.this.getStyleSheet();
                if (tag == HTML.Tag.B) {
                    styleSheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.FONT_WEIGHT, "bold");
                } else if (tag == HTML.Tag.I) {
                    styleSheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.FONT_STYLE, "italic");
                } else if (tag == HTML.Tag.U) {
                    Object object = HTMLReader.this.charAttr.getAttribute(CSS.Attribute.TEXT_DECORATION);
                    String string = "underline";
                    string = object != null ? string + "," + object.toString() : string;
                    styleSheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.TEXT_DECORATION, string);
                } else if (tag == HTML.Tag.STRIKE) {
                    Object object = HTMLReader.this.charAttr.getAttribute(CSS.Attribute.TEXT_DECORATION);
                    String string = "line-through";
                    string = object != null ? string + "," + object.toString() : string;
                    styleSheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.TEXT_DECORATION, string);
                } else if (tag == HTML.Tag.SUP) {
                    Object object = HTMLReader.this.charAttr.getAttribute(CSS.Attribute.VERTICAL_ALIGN);
                    String string = "sup";
                    string = object != null ? string + "," + object.toString() : string;
                    styleSheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.VERTICAL_ALIGN, string);
                } else if (tag == HTML.Tag.SUB) {
                    Object object = HTMLReader.this.charAttr.getAttribute(CSS.Attribute.VERTICAL_ALIGN);
                    String string = "sub";
                    string = object != null ? string + "," + object.toString() : string;
                    styleSheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.VERTICAL_ALIGN, string);
                } else if (tag == HTML.Tag.FONT) {
                    String string;
                    String string2;
                    String string3 = (String)mutableAttributeSet.getAttribute(HTML.Attribute.COLOR);
                    if (string3 != null) {
                        styleSheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.COLOR, string3);
                    }
                    if ((string2 = (String)mutableAttributeSet.getAttribute(HTML.Attribute.FACE)) != null) {
                        styleSheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.FONT_FAMILY, string2);
                    }
                    if ((string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.SIZE)) != null) {
                        styleSheet.addCSSAttributeFromHTML(HTMLReader.this.charAttr, CSS.Attribute.FONT_SIZE, string);
                    }
                }
            }

            @Override
            public void end(HTML.Tag tag) {
                HTMLReader.this.popCharacterStyle();
            }
        }

        public class FormAction
        extends SpecialAction {
            Object selectModel;
            int optionCount;

            @Override
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                if (tag == HTML.Tag.INPUT) {
                    String string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.TYPE);
                    if (string == null) {
                        string = "text";
                        mutableAttributeSet.addAttribute(HTML.Attribute.TYPE, "text");
                    }
                    this.setModel(string, mutableAttributeSet);
                } else if (tag == HTML.Tag.TEXTAREA) {
                    HTMLReader.this.inTextArea = true;
                    HTMLReader.this.textAreaDocument = new TextAreaDocument();
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, HTMLReader.this.textAreaDocument);
                } else if (tag == HTML.Tag.SELECT) {
                    boolean bl;
                    int n = HTML.getIntegerAttributeValue(mutableAttributeSet, HTML.Attribute.SIZE, 1);
                    boolean bl2 = bl = mutableAttributeSet.getAttribute(HTML.Attribute.MULTIPLE) != null;
                    if (n > 1 || bl) {
                        OptionListModel optionListModel = new OptionListModel();
                        if (bl) {
                            optionListModel.setSelectionMode(2);
                        }
                        this.selectModel = optionListModel;
                    } else {
                        this.selectModel = new OptionComboBoxModel();
                    }
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, this.selectModel);
                }
                if (tag == HTML.Tag.OPTION) {
                    HTMLReader.this.option = new Option(mutableAttributeSet);
                    if (this.selectModel instanceof OptionListModel) {
                        OptionListModel optionListModel = (OptionListModel)this.selectModel;
                        optionListModel.addElement(HTMLReader.this.option);
                        if (HTMLReader.this.option.isSelected()) {
                            optionListModel.addSelectionInterval(this.optionCount, this.optionCount);
                            optionListModel.setInitialSelection(this.optionCount);
                        }
                    } else if (this.selectModel instanceof OptionComboBoxModel) {
                        OptionComboBoxModel optionComboBoxModel = (OptionComboBoxModel)this.selectModel;
                        optionComboBoxModel.addElement(HTMLReader.this.option);
                        if (HTMLReader.this.option.isSelected()) {
                            optionComboBoxModel.setSelectedItem(HTMLReader.this.option);
                            optionComboBoxModel.setInitialSelection(HTMLReader.this.option);
                        }
                    }
                    ++this.optionCount;
                } else {
                    super.start(tag, mutableAttributeSet);
                }
            }

            @Override
            public void end(HTML.Tag tag) {
                if (tag == HTML.Tag.OPTION) {
                    HTMLReader.this.option = null;
                } else {
                    if (tag == HTML.Tag.SELECT) {
                        this.selectModel = null;
                        this.optionCount = 0;
                    } else if (tag == HTML.Tag.TEXTAREA) {
                        HTMLReader.this.inTextArea = false;
                        HTMLReader.this.textAreaDocument.storeInitialText();
                    }
                    super.end(tag);
                }
            }

            void setModel(String string, MutableAttributeSet mutableAttributeSet) {
                if (string.equals("submit") || string.equals("reset") || string.equals("image")) {
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, new DefaultButtonModel());
                } else if (string.equals("text") || string.equals("password")) {
                    int n = HTML.getIntegerAttributeValue(mutableAttributeSet, HTML.Attribute.MAXLENGTH, -1);
                    PlainDocument plainDocument = n > 0 ? new FixedLengthDocument(n) : new PlainDocument();
                    String string2 = (String)mutableAttributeSet.getAttribute(HTML.Attribute.VALUE);
                    try {
                        plainDocument.insertString(0, string2, null);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, plainDocument);
                } else if (string.equals("file")) {
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, new PlainDocument());
                } else if (string.equals("checkbox") || string.equals("radio")) {
                    JToggleButton.ToggleButtonModel toggleButtonModel = new JToggleButton.ToggleButtonModel();
                    if (string.equals("radio")) {
                        ButtonGroup buttonGroup;
                        String string3 = (String)mutableAttributeSet.getAttribute(HTML.Attribute.NAME);
                        if (HTMLDocument.this.radioButtonGroupsMap == null) {
                            HTMLDocument.this.radioButtonGroupsMap = new HashMap();
                        }
                        if ((buttonGroup = (ButtonGroup)HTMLDocument.this.radioButtonGroupsMap.get(string3)) == null) {
                            buttonGroup = new ButtonGroup();
                            HTMLDocument.this.radioButtonGroupsMap.put(string3, buttonGroup);
                        }
                        toggleButtonModel.setGroup(buttonGroup);
                    }
                    boolean bl = mutableAttributeSet.getAttribute(HTML.Attribute.CHECKED) != null;
                    toggleButtonModel.setSelected(bl);
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, toggleButtonModel);
                }
            }
        }

        private class FormTagAction
        extends BlockAction {
            private FormTagAction() {
            }

            @Override
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                super.start(tag, mutableAttributeSet);
                HTMLDocument.this.radioButtonGroupsMap = new HashMap();
            }

            @Override
            public void end(HTML.Tag tag) {
                super.end(tag);
                HTMLDocument.this.radioButtonGroupsMap = null;
            }
        }

        class HeadAction
        extends BlockAction {
            HeadAction() {
            }

            @Override
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.inHead = true;
                if (HTMLReader.this.insertTag == null && !HTMLReader.this.insertAfterImplied || HTMLReader.this.insertTag == HTML.Tag.HEAD || HTMLReader.this.insertAfterImplied && (HTMLReader.this.foundInsertTag || !mutableAttributeSet.isDefined(HTMLEditorKit.ParserCallback.IMPLIED))) {
                    super.start(tag, mutableAttributeSet);
                }
            }

            @Override
            public void end(HTML.Tag tag) {
                HTMLReader.this.inStyle = false;
                HTMLReader.this.inHead = false;
                if (HTMLReader.this.styles != null) {
                    boolean bl = HTMLReader.this.isStyleCSS;
                    int n = 0;
                    int n2 = HTMLReader.this.styles.size();
                    while (n < n2) {
                        String string;
                        boolean bl2;
                        Object object = HTMLReader.this.styles.elementAt(n);
                        if (object == HTML.Tag.LINK) {
                            this.handleLink((AttributeSet)HTMLReader.this.styles.elementAt(++n));
                            ++n;
                            continue;
                        }
                        boolean bl3 = bl2 = (string = (String)HTMLReader.this.styles.elementAt(++n)) == null ? bl : string.equals("text/css");
                        while (++n < n2 && HTMLReader.this.styles.elementAt(n) instanceof String) {
                            if (!bl2) continue;
                            HTMLReader.this.addCSSRules((String)HTMLReader.this.styles.elementAt(n));
                        }
                    }
                }
                if (HTMLReader.this.insertTag == null && !HTMLReader.this.insertAfterImplied || HTMLReader.this.insertTag == HTML.Tag.HEAD || HTMLReader.this.insertAfterImplied && HTMLReader.this.foundInsertTag) {
                    super.end(tag);
                }
            }

            boolean isEmpty(HTML.Tag tag) {
                return false;
            }

            private void handleLink(AttributeSet attributeSet) {
                String string = (String)attributeSet.getAttribute(HTML.Attribute.TYPE);
                if (string == null) {
                    string = HTMLDocument.this.getDefaultStyleSheetType();
                }
                if (string.equals("text/css")) {
                    String string2 = (String)attributeSet.getAttribute(HTML.Attribute.REL);
                    String string3 = (String)attributeSet.getAttribute(HTML.Attribute.TITLE);
                    String string4 = (String)attributeSet.getAttribute(HTML.Attribute.MEDIA);
                    string4 = string4 == null ? "all" : string4.toLowerCase();
                    if (string2 != null) {
                        string2 = string2.toLowerCase();
                        if ((string4.indexOf("all") != -1 || string4.indexOf("screen") != -1) && (string2.equals("stylesheet") || string2.equals("alternate stylesheet") && string3.equals(HTMLReader.this.defaultStyle))) {
                            HTMLReader.this.linkCSSStyleSheet((String)attributeSet.getAttribute(HTML.Attribute.HREF));
                        }
                    }
                }
            }
        }

        public class HiddenAction
        extends TagAction {
            @Override
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.addSpecialElement(tag, mutableAttributeSet);
            }

            @Override
            public void end(HTML.Tag tag) {
                if (!this.isEmpty(tag)) {
                    SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                    simpleAttributeSet.addAttribute(HTML.Attribute.ENDTAG, "true");
                    HTMLReader.this.addSpecialElement(tag, simpleAttributeSet);
                }
            }

            boolean isEmpty(HTML.Tag tag) {
                return tag != HTML.Tag.APPLET && tag != HTML.Tag.SCRIPT;
            }
        }

        public class IsindexAction
        extends TagAction {
            @Override
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
                HTMLReader.this.addSpecialElement(tag, mutableAttributeSet);
                HTMLReader.this.blockClose(HTML.Tag.IMPLIED);
            }
        }

        class LinkAction
        extends HiddenAction {
            LinkAction() {
            }

            @Override
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                String string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.REL);
                if (string != null && ((string = string.toLowerCase()).equals("stylesheet") || string.equals("alternate stylesheet"))) {
                    if (HTMLReader.this.styles == null) {
                        HTMLReader.this.styles = new Vector(3);
                    }
                    HTMLReader.this.styles.addElement(tag);
                    HTMLReader.this.styles.addElement(mutableAttributeSet.copyAttributes());
                }
                super.start(tag, mutableAttributeSet);
            }
        }

        class MapAction
        extends TagAction {
            MapAction() {
            }

            @Override
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.lastMap = new Map((String)mutableAttributeSet.getAttribute(HTML.Attribute.NAME));
                HTMLDocument.this.addMap(HTMLReader.this.lastMap);
            }

            @Override
            public void end(HTML.Tag tag) {
            }
        }

        class MetaAction
        extends HiddenAction {
            MetaAction() {
            }

            @Override
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                Object object = mutableAttributeSet.getAttribute(HTML.Attribute.HTTPEQUIV);
                if (object != null) {
                    if ((object = ((String)object).toLowerCase()).equals("content-style-type")) {
                        String string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.CONTENT);
                        HTMLDocument.this.setDefaultStyleSheetType(string);
                        HTMLReader.this.isStyleCSS = "text/css".equals(HTMLDocument.this.getDefaultStyleSheetType());
                    } else if (object.equals("default-style")) {
                        HTMLReader.this.defaultStyle = (String)mutableAttributeSet.getAttribute(HTML.Attribute.CONTENT);
                    }
                }
                super.start(tag, mutableAttributeSet);
            }

            @Override
            boolean isEmpty(HTML.Tag tag) {
                return true;
            }
        }

        class ObjectAction
        extends SpecialAction {
            ObjectAction() {
            }

            @Override
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                if (tag == HTML.Tag.PARAM) {
                    this.addParameter(mutableAttributeSet);
                } else {
                    super.start(tag, mutableAttributeSet);
                }
            }

            @Override
            public void end(HTML.Tag tag) {
                if (tag != HTML.Tag.PARAM) {
                    super.end(tag);
                }
            }

            void addParameter(AttributeSet attributeSet) {
                String string = (String)attributeSet.getAttribute(HTML.Attribute.NAME);
                String string2 = (String)attributeSet.getAttribute(HTML.Attribute.VALUE);
                if (string != null && string2 != null) {
                    DefaultStyledDocument.ElementSpec elementSpec = HTMLReader.this.parseBuffer.lastElement();
                    MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)elementSpec.getAttributes();
                    mutableAttributeSet.addAttribute(string, string2);
                }
            }
        }

        public class ParagraphAction
        extends BlockAction {
            @Override
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                super.start(tag, mutableAttributeSet);
                HTMLReader.this.inParagraph = true;
            }

            @Override
            public void end(HTML.Tag tag) {
                super.end(tag);
                HTMLReader.this.inParagraph = false;
            }
        }

        public class PreAction
        extends BlockAction {
            @Override
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.inPre = true;
                HTMLReader.this.blockOpen(tag, mutableAttributeSet);
                mutableAttributeSet.addAttribute(CSS.Attribute.WHITE_SPACE, "pre");
                HTMLReader.this.blockOpen(HTML.Tag.IMPLIED, mutableAttributeSet);
            }

            @Override
            public void end(HTML.Tag tag) {
                HTMLReader.this.blockClose(HTML.Tag.IMPLIED);
                HTMLReader.this.inPre = false;
                HTMLReader.this.blockClose(tag);
            }
        }

        public class SpecialAction
        extends TagAction {
            @Override
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.addSpecialElement(tag, mutableAttributeSet);
            }
        }

        class StyleAction
        extends TagAction {
            StyleAction() {
            }

            @Override
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                if (HTMLReader.this.inHead) {
                    if (HTMLReader.this.styles == null) {
                        HTMLReader.this.styles = new Vector(3);
                    }
                    HTMLReader.this.styles.addElement(tag);
                    HTMLReader.this.styles.addElement(mutableAttributeSet.getAttribute(HTML.Attribute.TYPE));
                    HTMLReader.this.inStyle = true;
                }
            }

            @Override
            public void end(HTML.Tag tag) {
                HTMLReader.this.inStyle = false;
            }

            boolean isEmpty(HTML.Tag tag) {
                return false;
            }
        }

        public class TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            }

            public void end(HTML.Tag tag) {
            }
        }

        class TitleAction
        extends HiddenAction {
            TitleAction() {
            }

            @Override
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.inTitle = true;
                super.start(tag, mutableAttributeSet);
            }

            @Override
            public void end(HTML.Tag tag) {
                HTMLReader.this.inTitle = false;
                super.end(tag);
            }

            @Override
            boolean isEmpty(HTML.Tag tag) {
                return false;
            }
        }
    }

    public static abstract class Iterator {
        public abstract AttributeSet getAttributes();

        public abstract int getStartOffset();

        public abstract int getEndOffset();

        public abstract void next();

        public abstract boolean isValid();

        public abstract HTML.Tag getTag();
    }

    static class LeafIterator
    extends Iterator {
        private int endOffset;
        private HTML.Tag tag;
        private ElementIterator pos;

        LeafIterator(HTML.Tag tag, Document document) {
            this.tag = tag;
            this.pos = new ElementIterator(document);
            this.endOffset = 0;
            this.next();
        }

        @Override
        public AttributeSet getAttributes() {
            Element element = this.pos.current();
            if (element != null) {
                AttributeSet attributeSet = (AttributeSet)element.getAttributes().getAttribute(this.tag);
                if (attributeSet == null) {
                    attributeSet = element.getAttributes();
                }
                return attributeSet;
            }
            return null;
        }

        @Override
        public int getStartOffset() {
            Element element = this.pos.current();
            if (element != null) {
                return element.getStartOffset();
            }
            return -1;
        }

        @Override
        public int getEndOffset() {
            return this.endOffset;
        }

        @Override
        public void next() {
            this.nextLeaf(this.pos);
            while (this.isValid()) {
                AttributeSet attributeSet;
                Element element = this.pos.current();
                if (element.getStartOffset() >= this.endOffset && ((attributeSet = this.pos.current().getAttributes()).isDefined(this.tag) || attributeSet.getAttribute(StyleConstants.NameAttribute) == this.tag)) {
                    this.setEndOffset();
                    break;
                }
                this.nextLeaf(this.pos);
            }
        }

        @Override
        public HTML.Tag getTag() {
            return this.tag;
        }

        @Override
        public boolean isValid() {
            return this.pos.current() != null;
        }

        void nextLeaf(ElementIterator elementIterator) {
            Element element;
            elementIterator.next();
            while (elementIterator.current() != null && !(element = elementIterator.current()).isLeaf()) {
                elementIterator.next();
            }
        }

        void setEndOffset() {
            Element element;
            AttributeSet attributeSet;
            AttributeSet attributeSet2 = this.getAttributes();
            this.endOffset = this.pos.current().getEndOffset();
            ElementIterator elementIterator = (ElementIterator)this.pos.clone();
            this.nextLeaf(elementIterator);
            while (elementIterator.current() != null && (attributeSet = (AttributeSet)(element = elementIterator.current()).getAttributes().getAttribute(this.tag)) != null && attributeSet.equals(attributeSet2)) {
                this.endOffset = element.getEndOffset();
                this.nextLeaf(elementIterator);
            }
        }
    }

    public class RunElement
    extends AbstractDocument.LeafElement {
        public RunElement(Element element, AttributeSet attributeSet, int n, int n2) {
            super(HTMLDocument.this, element, attributeSet, n, n2);
        }

        @Override
        public String getName() {
            Object object = this.getAttribute(StyleConstants.NameAttribute);
            if (object != null) {
                return object.toString();
            }
            return super.getName();
        }

        @Override
        public AttributeSet getResolveParent() {
            return null;
        }
    }

    static class TaggedAttributeSet
    extends SimpleAttributeSet {
        TaggedAttributeSet() {
        }
    }
}

