/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ChoicePeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class Choice
extends Component
implements ItemSelectable,
Accessible {
    Vector pItems;
    int selectedIndex = -1;
    transient ItemListener itemListener;
    private static final String base = "choice";
    private static int nameCounter = 0;
    private static final long serialVersionUID = -4075310674757313071L;
    private int choiceSerializedDataVersion = 1;

    public Choice() throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.pItems = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String constructComponentName() {
        Class<Choice> clazz = Choice.class;
        synchronized (Choice.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createChoice(this);
            }
            super.addNotify();
        }
    }

    public int getItemCount() {
        return this.countItems();
    }

    @Deprecated
    public int countItems() {
        return this.pItems.size();
    }

    public String getItem(int n) {
        return this.getItemImpl(n);
    }

    final String getItemImpl(int n) {
        return (String)this.pItems.elementAt(n);
    }

    public void add(String string) {
        this.addItem(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(String string) {
        Choice choice = this;
        synchronized (choice) {
            this.insertNoInvalidate(string, this.pItems.size());
        }
        this.invalidateIfValid();
    }

    private void insertNoInvalidate(String string, int n) {
        if (string == null) {
            throw new NullPointerException("cannot add null item to Choice");
        }
        this.pItems.insertElementAt(string, n);
        ChoicePeer choicePeer = (ChoicePeer)this.peer;
        if (choicePeer != null) {
            choicePeer.add(string, n);
        }
        if (this.selectedIndex < 0 || this.selectedIndex >= n) {
            this.select(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(String string, int n) {
        Choice choice = this;
        synchronized (choice) {
            if (n < 0) {
                throw new IllegalArgumentException("index less than zero.");
            }
            n = Math.min(n, this.pItems.size());
            this.insertNoInvalidate(string, n);
        }
        this.invalidateIfValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String string) {
        Choice choice = this;
        synchronized (choice) {
            int n = this.pItems.indexOf(string);
            if (n < 0) {
                throw new IllegalArgumentException("item " + string + " not found in choice");
            }
            this.removeNoInvalidate(n);
        }
        this.invalidateIfValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n) {
        Choice choice = this;
        synchronized (choice) {
            this.removeNoInvalidate(n);
        }
        this.invalidateIfValid();
    }

    private void removeNoInvalidate(int n) {
        this.pItems.removeElementAt(n);
        ChoicePeer choicePeer = (ChoicePeer)this.peer;
        if (choicePeer != null) {
            choicePeer.remove(n);
        }
        if (this.pItems.size() == 0) {
            this.selectedIndex = -1;
        } else if (this.selectedIndex == n) {
            this.select(0);
        } else if (this.selectedIndex > n) {
            this.select(this.selectedIndex - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Choice choice = this;
        synchronized (choice) {
            if (this.peer != null) {
                ((ChoicePeer)this.peer).removeAll();
            }
            this.pItems.removeAllElements();
            this.selectedIndex = -1;
        }
        this.invalidateIfValid();
    }

    public synchronized String getSelectedItem() {
        return this.selectedIndex >= 0 ? this.getItem(this.selectedIndex) : null;
    }

    @Override
    public synchronized Object[] getSelectedObjects() {
        if (this.selectedIndex >= 0) {
            Object[] objectArray = new Object[]{this.getItem(this.selectedIndex)};
            return objectArray;
        }
        return null;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public synchronized void select(int n) {
        if (n >= this.pItems.size() || n < 0) {
            throw new IllegalArgumentException("illegal Choice item position: " + n);
        }
        if (this.pItems.size() > 0) {
            this.selectedIndex = n;
            ChoicePeer choicePeer = (ChoicePeer)this.peer;
            if (choicePeer != null) {
                choicePeer.select(n);
            }
        }
    }

    public synchronized void select(String string) {
        int n = this.pItems.indexOf(string);
        if (n >= 0) {
            this.select(n);
        }
    }

    @Override
    public synchronized void addItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
        this.newEventsOnly = true;
    }

    @Override
    public synchronized void removeItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public synchronized ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(ItemListener.class);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        ItemListener itemListener = null;
        if (clazz != ItemListener.class) {
            return super.getListeners(clazz);
        }
        itemListener = this.itemListener;
        return AWTEventMulticaster.getListeners((EventListener)itemListener, clazz);
    }

    @Override
    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 701) {
            return (this.eventMask & 0x200L) != 0L || this.itemListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        ItemListener itemListener = this.itemListener;
        if (itemListener != null) {
            itemListener.itemStateChanged(itemEvent);
        }
    }

    @Override
    protected String paramString() {
        return super.paramString() + ",current=" + this.getSelectedItem();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "itemL", this.itemListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        Object object;
        GraphicsEnvironment.checkHeadless();
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            String string = ((String)object).intern();
            if ("itemL" == string) {
                this.addItemListener((ItemListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTChoice();
        }
        return this.accessibleContext;
    }

    protected class AccessibleAWTChoice
    extends Component.AccessibleAWTComponent
    implements AccessibleAction {
        private static final long serialVersionUID = 7175603582428509322L;

        public AccessibleAWTChoice() {
            super(Choice.this);
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COMBO_BOX;
        }

        @Override
        public int getAccessibleActionCount() {
            return 0;
        }

        @Override
        public String getAccessibleActionDescription(int n) {
            return null;
        }

        @Override
        public boolean doAccessibleAction(int n) {
            return false;
        }
    }
}

