/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.code;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMReg;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.CStringUtilities;

public class VMRegImpl {
    private static VMReg stack0;
    private static int stack0Val;
    private static Address stack0Addr;
    private static AddressField regNameField;

    private static void initialize(TypeDataBase db) {
        Type type = db.lookupType("VMRegImpl");
        AddressField stack0Field = type.getAddressField("stack0");
        stack0Addr = stack0Field.getValue();
        stack0Val = ((Object)stack0Addr).hashCode();
        stack0 = new VMReg(stack0Val);
        regNameField = type.getAddressField("regName[0]");
    }

    public static VMReg getStack0() {
        return stack0;
    }

    public static String getRegisterName(int index) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(index >= 0 && index < stack0Val, "invalid index : " + index);
        }
        Address regName = regNameField.getStaticFieldAddress();
        long addrSize = VM.getVM().getAddressSize();
        return CStringUtilities.getString(regName.getAddressAt((long)index * addrSize));
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                VMRegImpl.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

