/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.classfile;

public class ClassLoaderTable {
    private static final boolean DEBUG = System.getProperty("org.netbeans.lib.profiler.classfile.ClassLoaderTable") != null;
    private static int[] parentLoaderIds;

    public static int getParentLoader(int n) {
        if (DEBUG) {
            System.err.println("ClassLoaderTable.DEBUG: getParent loader: " + n);
        }
        if (n >= parentLoaderIds.length) {
            return -1;
        }
        return parentLoaderIds[n];
    }

    public static void addChildAndParent(int[] nArray) {
        int n = nArray[2];
        if (n == 0) {
            ClassLoaderTable.addChildAndParent(nArray[0], nArray[1]);
        } else {
            int n2 = nArray[0];
            for (int i = 0; i < n; ++i) {
                ClassLoaderTable.addChildAndParent(n2, n2 + 1);
                ++n2;
            }
            ClassLoaderTable.addChildAndParent(n2, nArray[1]);
        }
    }

    public static void initTable(int[] nArray) {
        int n;
        if (DEBUG) {
            System.err.println("ClassLoaderTable.DEBUG: init patent loader ids: " + nArray.length);
            for (n = 0; n < nArray.length; ++n) {
                System.err.println("ClassLoaderTable.DEBUG: inParentLoaderIds[" + n + "]=" + nArray[n]);
            }
        }
        parentLoaderIds = nArray;
        for (n = 0; n < parentLoaderIds.length; ++n) {
            if (parentLoaderIds[n] != -1) continue;
            ClassLoaderTable.parentLoaderIds[n] = 0;
        }
    }

    private static void addChildAndParent(int n, int n2) {
        int n3;
        if (DEBUG) {
            System.err.println("ClassLoaderTable.DEBUG: add child and parent: child: " + n + ", parent: " + n2);
        }
        int n4 = n3 = n > n2 ? n : n2;
        if (parentLoaderIds.length < n3 + 1) {
            int[] nArray = parentLoaderIds;
            parentLoaderIds = new int[n * 2 + 1];
            System.arraycopy(nArray, 0, parentLoaderIds, 0, nArray.length);
        }
        if (n2 == -1) {
            n2 = 0;
        }
        ClassLoaderTable.parentLoaderIds[n] = n2;
    }
}

