/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.tableProviders.objectstatistics;

import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IField;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.ui.components.custom.IEventRow;
import com.jrockit.mc.flightrecorder.ui.components.custom.IEventTable;
import com.jrockit.mc.flightrecorder.ui.tableProviders.objectstatistics.ClassStatistics;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class TopGrowersTable
implements IEventTable {
    private static final String SIZE_ATTRIBUTE = "totalSize";
    private static final String COUNT_ATTRIBUTE = "count";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String ID_ATTRIBUTE = "gcId";

    @Override
    public IEventRow[] createRows(Iterable<IEvent> eventSource, ITimeRange timeRange) {
        Iterator<IEvent> it = eventSource.iterator();
        if (it.hasNext()) {
            IEvent event = it.next();
            IField clazzField = event.getEventType().getField(CLASS_ATTRIBUTE);
            IField countField = event.getEventType().getField(COUNT_ATTRIBUTE);
            IField sizeField = event.getEventType().getField(SIZE_ATTRIBUTE);
            IField idField = event.getEventType().getField(ID_ATTRIBUTE);
            if (clazzField != null && countField != null && sizeField != null && idField != null) {
                return this.createRows(eventSource, clazzField, countField, sizeField, idField);
            }
        }
        return new IEventRow[0];
    }

    private IEventRow[] createRows(Iterable<IEvent> eventSource, IField clazzField, IField countField, IField sizeField, IField idField) {
        long firstSnapshotId = -1L;
        long lastSnapshotId = 0L;
        LinkedHashMap<Object, ClassStatistics> map = new LinkedHashMap<Object, ClassStatistics>();
        for (IEvent event : eventSource) {
            ClassStatistics cs;
            Object clazz = clazzField.getValue(event);
            Number count = (Number)countField.getValue(event);
            Number size = (Number)sizeField.getValue(event);
            Number id = (Number)idField.getValue(event);
            if (clazz == null || count == null || size == null || id == null) continue;
            if (firstSnapshotId == -1L) {
                firstSnapshotId = id.longValue();
            }
            if ((cs = (ClassStatistics)map.get(clazz)) == null) {
                cs = new ClassStatistics(clazz, eventSource, clazzField);
                if (id.longValue() == firstSnapshotId) {
                    cs.setInitialCount(count.longValue());
                    cs.setInitialSize(size.longValue());
                }
                map.put(clazz, cs);
            }
            cs.setLastSnapshotId(id.longValue());
            cs.setLastCount(count.longValue());
            cs.setLastSize(size.longValue());
            lastSnapshotId = id.longValue();
        }
        for (ClassStatistics cs : map.values()) {
            if (cs.getLastSnapshotId() == lastSnapshotId) continue;
            cs.setLastCount(0L);
            cs.setLastSize(0L);
        }
        return map.values().toArray(new ClassStatistics[map.values().size()]);
    }
}

