/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.range;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import se.hirt.greychart.TickFormatter;

public class NanoTimeFormatter
implements TickFormatter {
    private static final long NANOS_PER_SECOND = 1000000000L;
    private final String m_pretext;
    private final NumberFormat m_format;
    private Precision m_precision = Precision.AUTOMATIC;
    private boolean m_lineBreak;
    private boolean m_alwaysShowdate = true;

    public NanoTimeFormatter() {
        this("");
    }

    public NanoTimeFormatter(String preText) {
        this.m_pretext = preText;
        this.m_format = NumberFormat.getInstance();
    }

    public void setPrecision(Precision precision) {
        this.m_precision = precision;
    }

    public Precision getPrecision() {
        return this.m_precision;
    }

    public String format(long value, long startTimestamp, long endTimestamp) {
        return this.format(value, startTimestamp, endTimestamp, null);
    }

    public String format(Number value, Number min, Number max, Number labelDistance) {
        long timeStanmp = value.longValue();
        long duration = max.longValue() - min.longValue();
        Precision precision = this.m_precision == Precision.AUTOMATIC ? NanoTimeFormatter.lookupPrecisionForRange(duration) : this.m_precision;
        String text = String.valueOf(this.m_pretext) + ' ';
        if (precision.isLargerThan(Precision.HOURS) || this.getAlwaysShowDate()) {
            text = String.valueOf(text) + this.formatDate(precision, new Date(timeStanmp / 1000000L));
            if (this.getUseLineBreak()) {
                text = String.valueOf(text) + this.formatLineBreak();
            }
        }
        if (precision.isLessThan(Precision.DAYS)) {
            text = String.valueOf(text) + this.formatTime(timeStanmp);
        }
        if (precision.isLessThan(Precision.MINUTES)) {
            text = String.valueOf(text) + this.formatSubSecond(precision, timeStanmp, duration);
        }
        return text;
    }

    public boolean getAlwaysShowDate() {
        return this.m_alwaysShowdate;
    }

    public void setALwaysShowData(boolean alwaysShow) {
        this.m_alwaysShowdate = alwaysShow;
    }

    public void setUseLineBreak(boolean useLineBreak) {
        this.m_lineBreak = useLineBreak;
    }

    public boolean getUseLineBreak() {
        return this.m_lineBreak;
    }

    public String getUnitString(Number min, Number max) {
        return "";
    }

    protected String formatLineBreak() {
        return "\n";
    }

    protected String formatSubSecond(Precision precision, long timestamp, long duration) {
        return String.valueOf(' ') + this.formatMillis(precision, (double)(timestamp % 1000000000L) / 1.0E12) + " ms";
    }

    protected String formatTime(long timestamp) {
        return new SimpleDateFormat("HH:mm:ss").format(new Date(timestamp / 1000000L));
    }

    protected String formatDate(Precision precision, Date date) {
        if (precision == Precision.YEAR) {
            return new SimpleDateFormat("yyyy").format(date);
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    protected String formatMillis(Precision precision, double millis) {
        switch (precision) {
            case MILLIS: {
                this.m_format.setMinimumFractionDigits(3);
                this.m_format.setMinimumFractionDigits(3);
                break;
            }
            case MICROS: {
                this.m_format.setMinimumFractionDigits(6);
                this.m_format.setMinimumFractionDigits(6);
                break;
            }
            case NANOS: {
                this.m_format.setMinimumFractionDigits(9);
                this.m_format.setMinimumFractionDigits(9);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown precision");
            }
        }
        return this.m_format.format(millis);
    }

    protected static Precision lookupPrecisionForRange(long duration) {
        if (duration > 60000000000L) {
            return Precision.MONTHS;
        }
        if (duration > 60000000000L) {
            return Precision.DAYS;
        }
        if (duration > 60000000000L) {
            return Precision.HOURS;
        }
        if (duration > 60000000000L) {
            return Precision.MINUTES;
        }
        if (duration > 60000000000L) {
            return Precision.SECONDS;
        }
        if (duration > 1000000000L) {
            return Precision.MILLIS;
        }
        if (duration > 1000000L) {
            return Precision.MICROS;
        }
        return Precision.NANOS;
    }

    public static enum Precision {
        YEAR,
        MONTHS,
        DAYS,
        HOURS,
        MINUTES,
        SECONDS,
        MILLIS,
        MICROS,
        NANOS,
        AUTOMATIC;


        public boolean isLargerThan(Precision precision) {
            return precision.ordinal() > this.ordinal();
        }

        public boolean isLessThan(Precision precision) {
            return precision.ordinal() < this.ordinal();
        }
    }
}

