/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.operativeset.menus;

import com.jrockit.mc.flightrecorder.ui.common.OperativeSetService;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.actions.AddAction;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.actions.AddConcurrent;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.actions.ClearAction;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.actions.RemoveAction;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.actions.SetAction;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.menus.RelatedEventsMenu;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.ui.handlers.MCContextMenuManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;

public class OperativeSetMenu
extends MCContextMenuManager {
    public OperativeSetMenu(final OperativeSetService oss) {
        super(Messages.OPERATIVE_SET_MENU_TEXT, "operative.set");
        this.setRemoveAllWhenShown(true);
        this.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                boolean hasEvents = oss.getEventFactory().iterator().hasNext();
                if (hasEvents) {
                    manager.add((IAction)new AddAction(oss));
                    manager.add((IAction)new AddConcurrent(oss));
                    manager.add((IAction)new RemoveAction(oss));
                    manager.add((IAction)new SetAction(oss));
                    manager.add((IAction)new ClearAction(oss));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IContributionItem)new RelatedEventsMenu(oss));
                } else {
                    manager.add((IAction)new ClearAction(oss));
                }
            }
        });
    }
}

