/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.information;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.LocalizedString;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.unit.UnitDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.AggregatorFactory;

public class InformationDescriptor {
    private static final String ATTRIBUTE_IDENTIFIER = "attributeIdentifier";
    private static final String AGGREGATOR_IDENTIFIER = "aggregatorIdentifier";
    private static final String NAME = "name";
    private static final String UNIT = "unit";
    private static final String DESCRIPTION = "description";
    private static final String EMPHASIZED = "emphasized";
    private static final String CAPTION = "caption";
    private static final String DISABLE_LINE_WRAP = "disableLineWrap";
    protected final Setting m_setting;

    static {
        PersistenceToolkit.registerFetcher(InformationDescriptor.class, (ISettingFetcher)new ISettingFetcher<InformationDescriptor>(){

            public Setting getSetting(InformationDescriptor information) {
                return information.m_setting;
            }
        });
    }

    public InformationDescriptor() {
        this("informationDescriptor");
    }

    public InformationDescriptor(String name) {
        this.m_setting = new Setting(name);
        this.setAggregatorIdentifier(AggregatorFactory.getAggregators().get(0).getIdentifier());
        this.setUnit(new UnitDescriptor());
    }

    public final String getName() {
        return ((LocalizedString)this.m_setting.getChildObject(NAME, LocalizedString.class)).getText();
    }

    public final void setName(String name) {
        ((LocalizedString)this.m_setting.getChildObject(NAME, LocalizedString.class)).setText(name);
    }

    public final String getDescription() {
        return ((LocalizedString)this.m_setting.getChildObject(DESCRIPTION, LocalizedString.class)).getText();
    }

    public final void setDescription(String description) {
        ((LocalizedString)this.m_setting.getChildObject(DESCRIPTION, LocalizedString.class)).setText(description);
    }

    public final String getAttributeIdentifier() {
        return (String)this.m_setting.getChildObject(ATTRIBUTE_IDENTIFIER, String.class);
    }

    public final void setAttributeIdentifier(String description) {
        this.m_setting.setChildObject(ATTRIBUTE_IDENTIFIER, (Object)description);
    }

    public final String getEmphasized() {
        return (String)this.m_setting.getChildObject(EMPHASIZED, String.class);
    }

    public final void setEmphasized(boolean emphasized) {
        this.m_setting.setChildObject(EMPHASIZED, (Object)emphasized);
    }

    public final boolean getCaption() {
        return (Boolean)this.m_setting.getChildObject(CAPTION, Boolean.class);
    }

    public final void setCaption(boolean caption) {
        this.m_setting.setChildObject(CAPTION, (Object)caption);
    }

    public final UnitDescriptor getUnit() {
        return (UnitDescriptor)this.m_setting.getChildObject(UNIT, UnitDescriptor.class);
    }

    public final void setUnit(UnitDescriptor unit) {
        this.m_setting.setChildObject(UNIT, (Object)unit);
    }

    public final String getAggregatorIdentifier() {
        return (String)this.m_setting.getChildObject(AGGREGATOR_IDENTIFIER, String.class);
    }

    public final void setAggregatorIdentifier(String identifier) {
        this.m_setting.setChildObject(AGGREGATOR_IDENTIFIER, (Object)identifier);
    }

    public boolean getDisableLineWrap() {
        return (Boolean)this.m_setting.getChildObject(DISABLE_LINE_WRAP, Boolean.class);
    }
}

