/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.renderer;

import com.jrockit.mc.flightrecorder.ui.FlightRecorderUI;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.IVisitor;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.Visitable;
import java.util.logging.Level;

public class ObjectLocator {
    private Visitable[] m_objects = new Visitable[0];

    public ObjectLocator(int size) {
        this.resize(size);
    }

    public int getSize() {
        return this.m_objects.length;
    }

    public void traverse(IVisitor visitor) {
        int size = this.getSize();
        int n = 0;
        while (n < size) {
            this.m_objects[n].accept(visitor);
            ++n;
        }
    }

    public void setObjectAtPosition(int position, Visitable object) {
        if (position >= 0 && position < this.m_objects.length) {
            this.m_objects[position] = object;
        }
    }

    public void resize(int height) {
        if (height <= this.m_objects.length) {
            this.clear();
        } else {
            this.m_objects = new Visitable[height];
        }
    }

    public void clear() {
        int n = 0;
        while (n < this.getSize()) {
            this.setObjectAtPosition(n, null);
            ++n;
        }
    }

    public Visitable getObjectAt(int index) {
        if (index < this.m_objects.length) {
            return this.m_objects[index];
        }
        FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Trying to locate object out of range.");
        return null;
    }
}

