/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.dial;

import com.jrockit.mc.components.ui.base.AbstractUIConfigurer;
import com.jrockit.mc.components.ui.settings.ColorInput;
import com.jrockit.mc.components.ui.settings.CompositeInput;
import com.jrockit.mc.components.ui.settings.DoubleInput;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.InputControl;
import com.jrockit.mc.components.ui.settings.TabFolderInput;
import com.jrockit.mc.flightrecorder.ui.components.dial.DialDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.dial.DialInput;
import com.jrockit.mc.flightrecorder.ui.components.inputs.InputFactory;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class DialConfigurer
extends AbstractUIConfigurer {
    static final String DIAL_CONFIGURATION = "dialDescriptorRepository";

    public final Control createPart(Composite parent) {
        return new InputControl(parent, this.getStatusProvider(), (Object)this.getDialDescriptorRepository(), this.createInput());
    }

    private IInput createInput() {
        TabFolderInput folder = new TabFolderInput();
        folder.addInput(this.createGeneralInput());
        folder.addInput(this.createDialMasterDetailInput());
        return folder;
    }

    private IInput createDialMasterDetailInput() {
        return new DialInput(this.getServiceLocator(), this.getDialDescriptorRepository());
    }

    public IInput createGeneralInput() {
        CompositeInput input = new CompositeInput(Messages.COMPONENT_GENERAL_TITLE);
        input.addInput(InputFactory.createRole(Role.INDEPENDENT));
        input.addInput(this.createGradientBeginValue());
        input.addInput(this.createGradientBeginColor());
        input.addInput(this.createGradientEndValue());
        input.addInput(this.createGradientEndColor());
        input.addInput(InputFactory.createUnit(true));
        input.addInput(InputFactory.createOperativeSetEnabled());
        return input;
    }

    private IInput createGradientEndColor() {
        return new ColorInput("gradientEndColor", Messages.DIAL_COMPONENT_GRADIENT_END_COLOR_TEXT);
    }

    private IInput createGradientEndValue() {
        return new DoubleInput("gradientEndValue", Messages.DIAL_COMPONENT_GRADIENT_END_VALUE_TEXT);
    }

    private IInput createGradientBeginValue() {
        return new DoubleInput("gradientBeginValue", Messages.DIAL_COMPONENT_GRADIENT_START_VALUE_TEXT);
    }

    private IInput createGradientBeginColor() {
        return new ColorInput("gradientBeginColor", Messages.DIAL_COMPONENT_GRADIENT_START_COLOR_TEXT);
    }

    private DialDescriptorRepository getDialDescriptorRepository() {
        return (DialDescriptorRepository)this.getComponentSettings().getChildObject(DIAL_CONFIGURATION, DialDescriptorRepository.class);
    }
}

