/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.StyleableObjectProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.EnumConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.control.Control;

public class Separator
extends Control {
    private ObjectProperty<Orientation> orientation = new StyleableObjectProperty<Orientation>(Orientation.HORIZONTAL){

        @Override
        protected void invalidated() {
            Separator.this.impl_pseudoClassStateChanged(Separator.PSEUDO_CLASS_VERTICAL);
            Separator.this.impl_pseudoClassStateChanged(Separator.PSEUDO_CLASS_HORIZONTAL);
        }

        @Override
        public StyleableProperty getStyleableProperty() {
            return StyleableProperties.ORIENTATION;
        }

        @Override
        public Object getBean() {
            return Separator.this;
        }

        @Override
        public String getName() {
            return "orientation";
        }
    };
    private ObjectProperty<HPos> halignment;
    private ObjectProperty<VPos> valignment;
    private static final String DEFAULT_STYLE_CLASS = "separator";
    private static final String PSEUDO_CLASS_VERTICAL = "vertical";
    private static final String PSEUDO_CLASS_HORIZONTAL = "horizontal";
    private static final long VERTICAL_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("vertical");
    private static final long HORIZONTAL_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("horizontal");

    public Separator() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        StyleableProperty styleableProperty = StyleableProperty.getStyleableProperty(this.focusTraversableProperty());
        styleableProperty.set(this, Boolean.FALSE);
    }

    public Separator(Orientation orientation) {
        this();
        this.setOrientation(orientation);
    }

    public final void setOrientation(Orientation orientation) {
        this.orientation.set(orientation);
    }

    public final Orientation getOrientation() {
        return (Orientation)((Object)this.orientation.get());
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        return this.orientation;
    }

    public final void setHalignment(HPos hPos) {
        this.halignmentProperty().set(hPos);
    }

    public final HPos getHalignment() {
        return this.halignment == null ? HPos.CENTER : (HPos)((Object)this.halignment.get());
    }

    public final ObjectProperty<HPos> halignmentProperty() {
        if (this.halignment == null) {
            this.halignment = new StyleableObjectProperty((Object)HPos.CENTER){

                @Override
                public Object getBean() {
                    return Separator.this;
                }

                @Override
                public String getName() {
                    return "halignment";
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.HALIGNMENT;
                }
            };
        }
        return this.halignment;
    }

    public final void setValignment(VPos vPos) {
        this.valignmentProperty().set(vPos);
    }

    public final VPos getValignment() {
        return this.valignment == null ? VPos.CENTER : (VPos)((Object)this.valignment.get());
    }

    public final ObjectProperty<VPos> valignmentProperty() {
        if (this.valignment == null) {
            this.valignment = new StyleableObjectProperty((Object)VPos.CENTER){

                @Override
                public Object getBean() {
                    return Separator.this;
                }

                @Override
                public String getName() {
                    return "valignment";
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.VALIGNMENT;
                }
            };
        }
        return this.valignment;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return Separator.impl_CSS_STYLEABLES();
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        return l |= this.getOrientation() == Orientation.VERTICAL ? VERTICAL_PSEUDOCLASS_STATE : HORIZONTAL_PSEUDOCLASS_STATE;
    }

    @Override
    @Deprecated
    protected Boolean impl_cssGetFocusTraversableInitialValue() {
        return Boolean.FALSE;
    }

    private static class StyleableProperties {
        private static final StyleableProperty<Separator, Orientation> ORIENTATION = new StyleableProperty<Separator, Orientation>("-fx-orientation", new EnumConverter(Orientation.class), Orientation.HORIZONTAL){

            @Override
            public Orientation getInitialValue(Separator separator) {
                return separator.getOrientation();
            }

            @Override
            public boolean isSettable(Separator separator) {
                return separator.orientation == null || !separator.orientation.isBound();
            }

            @Override
            public WritableValue<Orientation> getWritableValue(Separator separator) {
                return separator.orientationProperty();
            }
        };
        private static final StyleableProperty<Separator, HPos> HALIGNMENT = new StyleableProperty<Separator, HPos>("-fx-halignment", new EnumConverter(HPos.class), HPos.CENTER){

            @Override
            public boolean isSettable(Separator separator) {
                return separator.halignment == null || !separator.halignment.isBound();
            }

            @Override
            public WritableValue<HPos> getWritableValue(Separator separator) {
                return separator.halignmentProperty();
            }
        };
        private static final StyleableProperty<Separator, VPos> VALIGNMENT = new StyleableProperty<Separator, VPos>("-fx-valignment", new EnumConverter(VPos.class), VPos.CENTER){

            @Override
            public boolean isSettable(Separator separator) {
                return separator.valignment == null || !separator.valignment.isBound();
            }

            @Override
            public WritableValue<VPos> getWritableValue(Separator separator) {
                return separator.valignmentProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Control.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, ORIENTATION, HALIGNMENT, VALIGNMENT);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

