/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.netbeans.lib.uihandler.Decorable;
import org.netbeans.lib.uihandler.LogRecords;
import org.netbeans.modules.uihandler.VisualData;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

final class UINode
extends AbstractNode
implements VisualData,
Decorable {
    private static final SimpleFormatter FORMATTER = new SimpleFormatter();
    private LogRecord log;
    private String htmlKey;

    private UINode(LogRecord logRecord, Children children) {
        super(children, Lookups.fixed((Object[])new Object[]{logRecord}));
        this.log = logRecord;
        LogRecords.decorate((LogRecord)logRecord, (Decorable)this);
    }

    @Override
    public long getMillis() {
        return this.log.getMillis();
    }

    @Override
    public String getLoggerName() {
        return this.log.getLoggerName();
    }

    @Override
    public String getMessage() {
        return FORMATTER.format(this.log);
    }

    public String getHtmlDisplayName() {
        if (this.htmlKey == null) {
            return null;
        }
        return NbBundle.getMessage(UINode.class, (String)this.htmlKey, (Object)this.getDisplayName());
    }

    static String getParam(LogRecord logRecord, int n) {
        Object[] objectArray = logRecord.getParameters();
        if (objectArray == null || objectArray.length <= n || !(objectArray[n] instanceof String)) {
            return "";
        }
        return (String)objectArray[n];
    }

    static Node create(LogRecord logRecord) {
        Children.Keys keys = logRecord.getThrown() != null ? new StackTraceChildren(logRecord.getThrown()) : ("UI_ENABLED_MODULES".equals(logRecord.getMessage()) || "UI_DISABLED_MODULES".equals(logRecord.getMessage()) ? new ModulesChildren(logRecord.getParameters()) : Children.LEAF);
        return new UINode(logRecord, (Children)keys);
    }

    private static String afterLastDot(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    private static <T> T getParam(LogRecord logRecord, int n, Class<T> clazz) {
        if (logRecord == null || logRecord.getParameters() == null || logRecord.getParameters().length <= n) {
            return null;
        }
        Object object = logRecord.getParameters()[n];
        return clazz.isInstance(object) ? (T)clazz.cast(object) : null;
    }

    private static final class ModulesChildren
    extends Children.Keys<Object> {
        private Object[] modules;

        public ModulesChildren(Object[] objectArray) {
            this.modules = objectArray;
        }

        protected void addNotify() {
            this.setKeys(this.modules);
        }

        protected Node[] createNodes(Object object) {
            AbstractNode abstractNode = new AbstractNode(Children.LEAF);
            abstractNode.setName((String)object);
            abstractNode.setIconBaseWithExtension("org/netbeans/lib/uihandler/module.gif");
            return new Node[]{abstractNode};
        }
    }

    private static final class StackTraceChildren
    extends Children.Keys<StackTraceElement> {
        private Throwable throwable;

        public StackTraceChildren(Throwable throwable) {
            this.throwable = throwable;
        }

        protected void addNotify() {
            this.setKeys(this.throwable.getStackTrace());
        }

        protected Node[] createNodes(StackTraceElement stackTraceElement) {
            AbstractNode abstractNode = new AbstractNode(Children.LEAF);
            abstractNode.setName(stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName());
            abstractNode.setDisplayName(NbBundle.getMessage(UINode.class, (String)"MSG_StackTraceElement", (Object[])new Object[]{stackTraceElement.getFileName(), stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getLineNumber(), UINode.afterLastDot(stackTraceElement.getClassName())}));
            abstractNode.setIconBaseWithExtension("org/netbeans/modules/uihandler/stackframe.gif");
            return new Node[]{abstractNode};
        }
    }
}

