/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.sampler.memory;

import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ThreadsMemoryInfo {
    private List<ThreadInfo> threads = new ArrayList<ThreadInfo>();
    private List<Long> allocatedBytes = new ArrayList<Long>();
    private Map<Long, Long> allocatedBytesMap = new HashMap<Long, Long>(this.threads.size() * 4 / 3);
    private long totalBytes = 0L;
    private long timestamp;
    private long totalDiffBytes;

    ThreadsMemoryInfo(long time, ThreadInfo[] tinfo, long[] minfo) {
        for (int i = 0; i < tinfo.length; ++i) {
            ThreadInfo ti = tinfo[i];
            if (ti == null) continue;
            this.threads.add(ti);
            this.allocatedBytes.add(minfo[i]);
            this.allocatedBytesMap.put(ti.getThreadId(), minfo[i]);
            this.totalBytes += minfo[i];
        }
        this.timestamp = time;
    }

    List<ThreadInfo> getThreads() {
        return this.threads;
    }

    List<Long> getAllocatedBytes() {
        return this.allocatedBytes;
    }

    long getTotalBytes() {
        return this.totalBytes;
    }

    List<Long> getAllocatedDiffBytes(ThreadsMemoryInfo info) {
        ArrayList<Long> allocDiff = new ArrayList<Long>(this.threads.size());
        List<ThreadInfo> newThreads = info.getThreads();
        List<Long> newAllocatedBytes = info.getAllocatedBytes();
        this.totalDiffBytes = 0L;
        for (int i = 0; i < newThreads.size(); ++i) {
            ThreadInfo ti = newThreads.get(i);
            Long oldAlloc = this.allocatedBytesMap.get(ti.getThreadId());
            if (oldAlloc == null) {
                oldAlloc = 0L;
            }
            long diff = newAllocatedBytes.get(i) - oldAlloc;
            allocDiff.add(diff);
            this.totalDiffBytes += diff;
        }
        return allocDiff;
    }

    long getTotalDiffBytes() {
        return this.totalDiffBytes;
    }

    List<Long> getAllocatedBytesPerSecond(ThreadsMemoryInfo newInfo) {
        assert (newInfo.timestamp >= this.timestamp);
        List<Long> diff = this.getAllocatedDiffBytes(newInfo);
        double secs = (double)(newInfo.timestamp - this.timestamp) / 1000.0;
        ArrayList<Long> diffPerSec = new ArrayList<Long>(diff.size());
        for (Long d : diff) {
            diffPerSec.add(new Long((long)((double)d.longValue() / secs)));
        }
        return diffPerSec;
    }
}

