/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.internal.toolkit.util;

import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.javafx.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.javafx.tools.doclets.internal.toolkit.util.DocletConstants;
import com.javafx.tools.doclets.internal.toolkit.util.SourcePath;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Type;
import com.sun.javadoc.TypeVariable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.annotation.Documented;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final String[][] HTML_ESCAPE_CHARS = new String[][]{{"&", "&amp;"}, {"<", "&lt;"}, {">", "&gt;"}};
    public static final String RESOURCESDIR = "resources";
    private static String whitespace;

    public static ProgramElementDoc[] excludeDeprecatedMembers(ProgramElementDoc[] members) {
        return Util.toProgramElementDocArray(Util.excludeDeprecatedMembersAsList(members));
    }

    public static List<ProgramElementDoc> excludeDeprecatedMembersAsList(ProgramElementDoc[] members) {
        ArrayList<ProgramElementDoc> list = new ArrayList<ProgramElementDoc>();
        for (int i = 0; i < members.length; ++i) {
            if (members[i].tags("deprecated").length != 0) continue;
            list.add(members[i]);
        }
        Collections.sort(list);
        return list;
    }

    public static ProgramElementDoc[] toProgramElementDocArray(List<ProgramElementDoc> list) {
        ProgramElementDoc[] pgmarr = new ProgramElementDoc[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            pgmarr[i] = list.get(i);
        }
        return pgmarr;
    }

    public static boolean nonPublicMemberFound(ProgramElementDoc[] members) {
        for (int i = 0; i < members.length; ++i) {
            if (members[i].isPublic()) continue;
            return true;
        }
        return false;
    }

    public static MethodDoc findMethod(ClassDoc cd, MethodDoc method) {
        MethodDoc[] methods = cd.methods();
        for (int i = 0; i < methods.length; ++i) {
            if (!Util.executableMembersEqual((ExecutableMemberDoc)method, (ExecutableMemberDoc)methods[i])) continue;
            return methods[i];
        }
        return null;
    }

    public static boolean executableMembersEqual(ExecutableMemberDoc member1, ExecutableMemberDoc member2) {
        if (!(member1 instanceof MethodDoc) || !(member2 instanceof MethodDoc)) {
            return false;
        }
        MethodDoc method1 = (MethodDoc)member1;
        MethodDoc method2 = (MethodDoc)member2;
        if (method1.isStatic() && method2.isStatic()) {
            Parameter[] currentParams;
            Parameter[] targetParams = method1.parameters();
            if (method1.name().equals(method2.name()) && (currentParams = method2.parameters()).length == targetParams.length) {
                int j;
                for (j = 0; j < targetParams.length && (targetParams[j].typeName().equals(currentParams[j].typeName()) || currentParams[j].type() instanceof TypeVariable || targetParams[j].type() instanceof TypeVariable); ++j) {
                }
                if (j == targetParams.length) {
                    return true;
                }
            }
            return false;
        }
        return method1.overrides(method2) || method2.overrides(method1) || member1 == member2;
    }

    public static boolean isCoreClass(ClassDoc cd) {
        return cd.containingClass() == null || cd.isStatic();
    }

    public static boolean matches(ProgramElementDoc doc1, ProgramElementDoc doc2) {
        if (doc1 instanceof ExecutableMemberDoc && doc2 instanceof ExecutableMemberDoc) {
            ExecutableMemberDoc ed1 = (ExecutableMemberDoc)doc1;
            ExecutableMemberDoc ed2 = (ExecutableMemberDoc)doc2;
            return Util.executableMembersEqual(ed1, ed2);
        }
        return doc1.name().equals(doc2.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File destfile, File srcfile) throws IOException {
        byte[] bytearr = new byte[512];
        int len = 0;
        FileInputStream input = new FileInputStream(srcfile);
        File destDir = destfile.getParentFile();
        destDir.mkdirs();
        FileOutputStream output = new FileOutputStream(destfile);
        try {
            while ((len = input.read(bytearr)) != -1) {
                output.write(bytearr, 0, len);
            }
        }
        catch (FileNotFoundException exc) {
        }
        catch (SecurityException exc) {
        }
        finally {
            input.close();
            output.close();
        }
    }

    public static void copyDocFiles(Configuration configuration, String path, String dir, boolean overwrite) {
        if (Util.checkCopyDocFilesErrors(configuration, path, dir)) {
            return;
        }
        String destname = configuration.docFileDestDirName;
        File srcdir = new File(path + dir);
        if (destname.length() > 0 && !destname.endsWith("/")) {
            destname = destname + "/";
        }
        String dest = destname + dir;
        try {
            File destdir = new File(dest);
            DirectoryManager.createDirectory(configuration, dest);
            String[] files = srcdir.list();
            for (int i = 0; i < files.length; ++i) {
                File srcfile = new File(srcdir, files[i]);
                File destfile = new File(destdir, files[i]);
                if (srcfile.isFile()) {
                    if (destfile.exists() && !overwrite) {
                        configuration.message.warning((SourcePosition)null, "doclet.Copy_Overwrite_warning", srcfile.toString(), destdir.toString());
                        continue;
                    }
                    configuration.message.notice("doclet.Copying_File_0_To_Dir_1", srcfile.toString(), destdir.toString());
                    Util.copyFile(destfile, srcfile);
                    continue;
                }
                if (!srcfile.isDirectory() || !configuration.copydocfilesubdirs || configuration.shouldExcludeDocFileDir(srcfile.getName())) continue;
                Util.copyDocFiles(configuration, path, dir + "/" + srcfile.getName(), overwrite);
            }
        }
        catch (SecurityException exc) {
            throw new DocletAbortException();
        }
        catch (IOException exc) {
            throw new DocletAbortException();
        }
    }

    private static boolean checkCopyDocFilesErrors(Configuration configuration, String path, String dirName) {
        if (!(configuration.sourcepath != null && configuration.sourcepath.length() != 0 || configuration.destDirName != null && configuration.destDirName.length() != 0)) {
            return true;
        }
        File destPath = new File(configuration.destDirName);
        StringTokenizer pathTokens = new StringTokenizer(configuration.sourcepath == null ? "" : configuration.sourcepath, File.pathSeparator);
        while (pathTokens.hasMoreTokens()) {
            File sourcePath = new File(pathTokens.nextToken());
            if (!destPath.equals(sourcePath)) continue;
            return true;
        }
        File srcdir = new File(path + dirName);
        return !srcdir.exists();
    }

    public static void copyResourceFile(Configuration configuration, String resourcefile, boolean overwrite) {
        String destresourcesdir = configuration.destDirName + RESOURCESDIR;
        Util.copyFile(configuration, resourcefile, RESOURCESDIR, destresourcesdir, overwrite, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(Configuration configuration, String file, String source, String destination, boolean overwrite, boolean replaceNewLine) {
        block13: {
            DirectoryManager.createDirectory(configuration, destination);
            File destfile = new File(destination, file);
            if (destfile.exists() && !overwrite) {
                return;
            }
            try {
                InputStream in = Configuration.class.getResourceAsStream(source + "/" + file);
                if (in == null) {
                    return;
                }
                FileOutputStream out = new FileOutputStream(destfile);
                try {
                    if (!replaceNewLine) {
                        int n;
                        byte[] buf = new byte[2048];
                        while ((n = in.read(buf)) > 0) {
                            ((OutputStream)out).write(buf, 0, n);
                        }
                        break block13;
                    }
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            writer.write(line);
                            writer.write(DocletConstants.NL);
                        }
                    }
                    finally {
                        reader.close();
                        writer.close();
                    }
                }
                finally {
                    in.close();
                    ((OutputStream)out).close();
                }
            }
            catch (IOException ie) {
                ie.printStackTrace(System.err);
                throw new DocletAbortException();
            }
        }
    }

    public static String getPackageSourcePath(Configuration configuration, PackageDoc pkgDoc) {
        try {
            String pkgPath = DirectoryManager.getDirectoryPath(pkgDoc);
            String completePath = new SourcePath(configuration.sourcepath).getDirectory(pkgPath) + "/";
            completePath = Util.replaceText(completePath, File.separator, "/");
            pkgPath = Util.replaceText(pkgPath, File.separator, "/");
            return completePath.substring(0, completePath.lastIndexOf(pkgPath));
        }
        catch (Exception e) {
            return "";
        }
    }

    public static List<Type> getAllInterfaces(Type type, Configuration configuration, boolean sort) {
        AbstractMap results = sort ? new TreeMap() : new LinkedHashMap();
        Type[] interfaceTypes = null;
        Type superType = null;
        if (type instanceof ParameterizedType) {
            interfaceTypes = ((ParameterizedType)type).interfaceTypes();
            superType = ((ParameterizedType)type).superclassType();
        } else if (type instanceof ClassDoc) {
            interfaceTypes = ((ClassDoc)type).interfaceTypes();
            superType = ((ClassDoc)type).superclassType();
        } else {
            interfaceTypes = type.asClassDoc().interfaceTypes();
            superType = type.asClassDoc().superclassType();
        }
        for (int i = 0; i < interfaceTypes.length; ++i) {
            Type interfaceType = interfaceTypes[i];
            ClassDoc interfaceClassDoc = interfaceType.asClassDoc();
            if (!interfaceClassDoc.isPublic() && configuration != null && !Util.isLinkable(interfaceClassDoc, configuration)) continue;
            results.put(interfaceClassDoc, interfaceType);
            List<Type> superInterfaces = Util.getAllInterfaces(interfaceType, configuration, sort);
            for (Type t : superInterfaces) {
                results.put(t.asClassDoc(), t);
            }
        }
        if (superType == null) {
            return new ArrayList<Type>(results.values());
        }
        Util.addAllInterfaceTypes(results, superType, superType instanceof ClassDoc ? ((ClassDoc)superType).interfaceTypes() : ((ParameterizedType)superType).interfaceTypes(), false, configuration);
        ArrayList<Type> resultsList = new ArrayList<Type>(results.values());
        if (sort) {
            Collections.sort(resultsList, new TypeComparator());
        }
        return resultsList;
    }

    public static List<Type> getAllInterfaces(Type type, Configuration configuration) {
        return Util.getAllInterfaces(type, configuration, true);
    }

    private static void findAllInterfaceTypes(Map<ClassDoc, Type> results, ClassDoc c, boolean raw, Configuration configuration) {
        Type superType = c.superclassType();
        if (superType == null) {
            return;
        }
        Util.addAllInterfaceTypes(results, superType, superType instanceof ClassDoc ? ((ClassDoc)superType).interfaceTypes() : ((ParameterizedType)superType).interfaceTypes(), raw, configuration);
    }

    private static void findAllInterfaceTypes(Map<ClassDoc, Type> results, ParameterizedType p, Configuration configuration) {
        Type superType = p.superclassType();
        if (superType == null) {
            return;
        }
        Util.addAllInterfaceTypes(results, superType, superType instanceof ClassDoc ? ((ClassDoc)superType).interfaceTypes() : ((ParameterizedType)superType).interfaceTypes(), false, configuration);
    }

    private static void addAllInterfaceTypes(Map<ClassDoc, Type> results, Type type, Type[] interfaceTypes, boolean raw, Configuration configuration) {
        for (int i = 0; i < interfaceTypes.length; ++i) {
            Type interfaceType = interfaceTypes[i];
            ClassDoc interfaceClassDoc = interfaceType.asClassDoc();
            if (!interfaceClassDoc.isPublic() && (configuration == null || !Util.isLinkable(interfaceClassDoc, configuration))) continue;
            if (raw) {
                interfaceType = interfaceType.asClassDoc();
            }
            results.put(interfaceClassDoc, interfaceType);
            List<Type> superInterfaces = Util.getAllInterfaces(interfaceType, configuration);
            for (Type superInterface : superInterfaces) {
                results.put(superInterface.asClassDoc(), superInterface);
            }
        }
        if (type instanceof ParameterizedType) {
            Util.findAllInterfaceTypes(results, (ParameterizedType)type, configuration);
        } else if (((ClassDoc)type).typeParameters().length == 0) {
            Util.findAllInterfaceTypes(results, (ClassDoc)type, raw, configuration);
        } else {
            Util.findAllInterfaceTypes(results, (ClassDoc)type, true, configuration);
        }
    }

    public static String quote(String filepath) {
        return "\"" + filepath + "\"";
    }

    public static String getPackageName(PackageDoc packageDoc) {
        return packageDoc == null || packageDoc.name().length() == 0 ? "&lt;Unnamed&gt;" : packageDoc.name();
    }

    public static String getPackageFileHeadName(PackageDoc packageDoc) {
        return packageDoc == null || packageDoc.name().length() == 0 ? "default" : packageDoc.name();
    }

    public static String replaceText(String originalStr, String oldStr, String newStr) {
        if (oldStr == null || newStr == null || oldStr.equals(newStr)) {
            return originalStr;
        }
        return originalStr.replace(oldStr, newStr);
    }

    public static String escapeHtmlChars(String s) {
        String result = s;
        for (int i = 0; i < HTML_ESCAPE_CHARS.length; ++i) {
            result = Util.replaceText(result, HTML_ESCAPE_CHARS[i][0], HTML_ESCAPE_CHARS[i][1]);
        }
        return result;
    }

    public static String stripHtml(String rawString) {
        rawString = rawString.replaceAll("\\<.*?>", " ");
        rawString = rawString.replaceAll("\\b\\s{2,}\\b", " ");
        return rawString.trim();
    }

    public static Writer genWriter(Configuration configuration, String path, String filename, String docencoding) throws IOException, UnsupportedEncodingException {
        FileOutputStream fos;
        if (path != null) {
            DirectoryManager.createDirectory(configuration, path);
            fos = new FileOutputStream((path.length() > 0 ? path + File.separator : "") + filename);
        } else {
            fos = new FileOutputStream(filename);
        }
        if (docencoding == null) {
            return new OutputStreamWriter(fos);
        }
        return new OutputStreamWriter((OutputStream)fos, docencoding);
    }

    public static boolean isDocumentedAnnotation(AnnotationTypeDoc annotationDoc) {
        AnnotationDesc[] annotationDescList = annotationDoc.annotations();
        for (int i = 0; i < annotationDescList.length; ++i) {
            if (!annotationDescList[i].annotationType().qualifiedName().equals(Documented.class.getName())) continue;
            return true;
        }
        return false;
    }

    public static String[] tokenize(String s, char separator, int maxTokens) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder token = new StringBuilder();
        boolean prevIsEscapeChar = false;
        for (int i = 0; i < s.length(); i += Character.charCount(i)) {
            int currentChar = s.codePointAt(i);
            if (prevIsEscapeChar) {
                token.appendCodePoint(currentChar);
                prevIsEscapeChar = false;
                continue;
            }
            if (currentChar == separator && tokens.size() < maxTokens - 1) {
                tokens.add(token.toString());
                token = new StringBuilder();
                continue;
            }
            if (currentChar == 92) {
                prevIsEscapeChar = true;
                continue;
            }
            token.appendCodePoint(currentChar);
        }
        if (token.length() > 0) {
            tokens.add(token.toString());
        }
        return tokens.toArray(new String[0]);
    }

    public static boolean isLinkable(ClassDoc classDoc, Configuration configuration) {
        return classDoc.isIncluded() && configuration.isGeneratedDoc(classDoc) || configuration.extern.isExternal((ProgramElementDoc)classDoc) && (classDoc.isPublic() || classDoc.isProtected());
    }

    public static Type getFirstVisibleSuperClass(ClassDoc classDoc, Configuration configuration) {
        if (classDoc == null) {
            return null;
        }
        Type sup = classDoc.superclassType();
        ClassDoc supClassDoc = classDoc.superclass();
        while (!(sup == null || supClassDoc.isPublic() || Util.isLinkable(supClassDoc, configuration) || supClassDoc.superclass().qualifiedName().equals(supClassDoc.qualifiedName()))) {
            sup = supClassDoc.superclassType();
            supClassDoc = supClassDoc.superclass();
        }
        if (classDoc.equals(supClassDoc)) {
            return null;
        }
        return sup;
    }

    public static ClassDoc getFirstVisibleSuperClassCD(ClassDoc classDoc, Configuration configuration) {
        ClassDoc supClassDoc;
        if (classDoc == null) {
            return null;
        }
        for (supClassDoc = classDoc.superclass(); supClassDoc != null && !supClassDoc.isPublic() && !Util.isLinkable(supClassDoc, configuration); supClassDoc = supClassDoc.superclass()) {
        }
        if (classDoc.equals(supClassDoc)) {
            return null;
        }
        return supClassDoc;
    }

    public static String getTypeName(Configuration config, ClassDoc cd, boolean lowerCaseOnly) {
        String typeName = "";
        if (cd.isOrdinaryClass()) {
            typeName = "doclet.Class";
        } else if (cd.isInterface()) {
            typeName = "doclet.Interface";
        } else if (cd.isException()) {
            typeName = "doclet.Exception";
        } else if (cd.isError()) {
            typeName = "doclet.Error";
        } else if (cd.isAnnotationType()) {
            typeName = "doclet.AnnotationType";
        } else if (cd.isEnum()) {
            typeName = "doclet.Enum";
        }
        return config.getText(lowerCaseOnly ? typeName.toLowerCase() : typeName);
    }

    public static void replaceTabs(int tabLength, StringBuilder s) {
        if (whitespace == null || whitespace.length() < tabLength) {
            whitespace = String.format("%" + tabLength + "s", " ");
        }
        int index = 0;
        while ((index = s.indexOf("\t", index)) != -1) {
            int spaceCount = tabLength - index % tabLength;
            s.replace(index, index + 1, whitespace.substring(0, spaceCount));
            index += spaceCount;
        }
    }

    public static void setEnumDocumentation(Configuration configuration, ClassDoc classDoc) {
        MethodDoc[] methods = classDoc.methods();
        for (int j = 0; j < methods.length; ++j) {
            Type paramType;
            MethodDoc currentMethod = methods[j];
            if (currentMethod.name().equals("values") && currentMethod.parameters().length == 0) {
                currentMethod.setRawCommentText(configuration.getText("doclet.enum_values_doc", classDoc.name()));
                continue;
            }
            if (!currentMethod.name().equals("valueOf") || currentMethod.parameters().length != 1 || (paramType = currentMethod.parameters()[0].type()) == null || !paramType.qualifiedTypeName().equals(String.class.getName())) continue;
            currentMethod.setRawCommentText(configuration.getText("doclet.enum_valueof_doc"));
        }
    }

    public static boolean isDeprecated(Doc doc) {
        if (doc.tags("deprecated").length > 0) {
            return true;
        }
        AnnotationDesc[] annotationDescList = doc instanceof PackageDoc ? ((PackageDoc)doc).annotations() : ((ProgramElementDoc)doc).annotations();
        for (int i = 0; i < annotationDescList.length; ++i) {
            if (!annotationDescList[i].annotationType().qualifiedName().equals(Deprecated.class.getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeComparator
    implements Comparator<Type> {
        private TypeComparator() {
        }

        @Override
        public int compare(Type type1, Type type2) {
            return type1.qualifiedTypeName().toLowerCase().compareTo(type2.qualifiedTypeName().toLowerCase());
        }
    }
}

