/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.settings;

import com.jrockit.mc.common.parsing.Tokenizer;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.settings.Input;
import com.jrockit.mc.components.ui.settings.TextControl;
import com.jrockit.mc.ui.model.fields.Field;
import java.text.MessageFormat;
import java.text.ParseException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class FieldInput
extends Input {
    protected final Field m_field;
    protected final ModifyListener m_textListener;
    protected TextControl m_text;
    protected String m_lastTyped;
    protected final Object m_defaultValue;
    private final Object m_maximum;
    private final Object m_minimum;
    private final String m_tooltip;

    public FieldInput(String key, String name, Field field, Object defaultValue, Object min, Object max) {
        this(key, name, null, field, defaultValue, min, max);
    }

    public FieldInput(String key, String name, String tooltip, Field field, Object defaultValue, Object min, Object max) {
        super(key, name);
        this.m_tooltip = tooltip;
        this.m_minimum = min;
        this.m_maximum = max;
        this.m_field = field;
        this.m_defaultValue = defaultValue;
        this.m_textListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FieldInput.this.isEnabled()) {
                    Text text = (Text)e.widget;
                    FieldInput.this.storeTypedValue(text.getText());
                    FieldInput.this.markStale();
                }
            }
        };
    }

    protected void storeTypedValue(String text) {
        this.m_lastTyped = text;
        try {
            Tokenizer t = new Tokenizer(text);
            Object o = this.m_field.parse(t);
            if (o != null && !t.hasNext()) {
                this.setPropertyValue(String.valueOf(o));
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Override
    public void create(Composite parent, int horizontalSpan) {
        GridData gdLabel = new GridData(4, 4, false, false);
        gdLabel.horizontalSpan = 1;
        Label label = this.createLabel(parent);
        label.setToolTipText(this.m_tooltip);
        label.setLayoutData((Object)gdLabel);
        GridData gdText = new GridData(4, 4, true, false);
        gdText.horizontalSpan = horizontalSpan - 1;
        this.m_text = new TextControl(parent, 2048);
        this.m_text.getControl().setLayoutData((Object)gdText);
        String formattedValue = this.m_field.formatObject(this.m_defaultValue);
        this.m_text.setText(formattedValue);
        this.m_text.getControl().setToolTipText(this.m_tooltip);
        this.hookTextListener();
    }

    protected final Label createLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(this.getName());
        return label;
    }

    protected void hookTextListener() {
        this.m_text.getControl().addModifyListener(this.m_textListener);
    }

    @Override
    public void refresh() {
        this.m_text.updateControlDecoration(this.getStatus());
    }

    @Override
    public IStatus getStatus() {
        try {
            if (this.m_lastTyped != null) {
                Tokenizer t = new Tokenizer(this.m_lastTyped);
                Object object = this.m_field.parse(t);
                if (t.hasNext()) {
                    return new Status(4, "com.jrockit.mc.components.ui", Messages.FIELD_INPUT_EXTRANEOUS_CHARACTERS_ERROR);
                }
                if (object instanceof Comparable) {
                    if (this.m_maximum != null) {
                        Object maxValue = this.m_maximum;
                        if (this.m_maximum instanceof String) {
                            maxValue = this.m_field.parse(new Tokenizer((String)this.m_maximum));
                        }
                        if (this.m_field.compare(object, maxValue, true) >= 1) {
                            String s = this.m_field.formatObject(object);
                            return new Status(4, "com.jrockit.mc.components.ui", MessageFormat.format(Messages.NUMBER_INPUT_VALUE_TOO_LARGE_TEXT, this.getName(), s, this.m_maximum));
                        }
                    }
                    if (this.m_minimum != null) {
                        Object minValue = this.m_minimum;
                        if (this.m_minimum instanceof String) {
                            minValue = this.m_field.parse(new Tokenizer((String)this.m_minimum));
                        }
                        if (this.m_field.compare(object, minValue, true) <= -1) {
                            String s = this.m_field.formatObject(object);
                            return new Status(4, "com.jrockit.mc.components.ui", MessageFormat.format(Messages.NUMBER_INPUT_VALUE_TOO_SMALL_TEXT, this.getName(), s, this.m_minimum));
                        }
                    }
                    return new Status(1, "com.jrockit.mc.components.ui", MessageFormat.format(Messages.NUMBER_INPUT_VALID_INPUT_TEXT, this.getName()));
                }
                return new Status(4, "com.jrockit.mc.components.ui", MessageFormat.format(Messages.NUMBER_INPUT_NOT_A_VALID_INPUT_TEXT, this.getName()));
            }
        }
        catch (ParseException e) {
            return new Status(4, "com.jrockit.mc.components.ui", String.valueOf(this.getName()) + "::" + e.getMessage());
        }
        return new Status(1, "com.jrockit.mc.components.ui", MessageFormat.format(Messages.NUMBER_INPUT_VALID_INPUT_TEXT, this.getName()));
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.m_text.getControl().setEnabled(enabled);
    }
}

