/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view.layout;

import com.jrockit.mc.components.ui.design.LayoutData;
import com.jrockit.mc.components.ui.design.LayoutItem;
import com.jrockit.mc.components.ui.design.LayoutNotifaction;
import com.jrockit.mc.components.ui.design.designelement.IDesignElement;
import com.jrockit.mc.components.ui.design.view.layout.ISliderChangeListener;
import com.jrockit.mc.components.ui.design.view.layout.LayoutSubPart;

public abstract class LayoutDataSliderListener
implements ISliderChangeListener {
    private final LayoutSubPart m_subPart;
    private double m_beginValue = Double.NEGATIVE_INFINITY;

    public LayoutDataSliderListener(LayoutSubPart sub) {
        this.m_subPart = sub;
    }

    @Override
    public void onChange(double value) {
        this.processValue(value, false);
    }

    protected final LayoutItem getLayoutItem() {
        IDesignElement element = this.m_subPart.getDesignElement();
        if (element != null) {
            return element.getLayoutItem();
        }
        return null;
    }

    private void processValue(double value, boolean released) {
        LayoutItem item = this.getLayoutItem();
        if (item != null) {
            double oldValue = this.getValue(item.getLayoutData());
            this.setValue(item.getLayoutData(), value);
            double newValue = this.getValue(item.getLayoutData());
            if (released) {
                item.setChanged();
                item.notifyObservers(this.createNotification(this.m_beginValue, newValue, released));
            } else if (newValue != oldValue) {
                item.setChanged();
                item.notifyObservers(this.createNotification(oldValue, newValue, released));
            }
        }
    }

    @Override
    public void onBeginChange(double value) {
        this.m_beginValue = value;
    }

    @Override
    public void onEndChange(double value) {
        if (this.m_beginValue != value) {
            this.processValue(value, true);
        }
        this.m_beginValue = Double.NEGATIVE_INFINITY;
    }

    abstract void setValue(LayoutData var1, double var2);

    abstract double getValue(LayoutData var1);

    abstract LayoutNotifaction createNotification(double var1, double var3, boolean var5);
}

