/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicLabelUI;

public class LabelRenderer
extends JLabel {
    private static final LabelRendererUI UI = new LabelRendererUI();
    private static final int DIRTY = Integer.MIN_VALUE;
    private int x;
    private int y;
    private Insets insets = new Insets(0, 0, 0, 0);
    private Dimension preferredSize;
    private FontMetrics fontMetrics;
    private String text;
    private Icon icon;
    private Color foreground;
    private boolean enabled;
    private int iconWidth;
    private int iconHeight;
    private int iconTextGap;
    private int textWidth;
    private int fontAscent;

    public LabelRenderer() {
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(1);
        this.setSize(Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.setOpaque(false);
        this.setEnabled(true);
        this.iconTextGap = super.getIconTextGap();
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    @Override
    public Insets getInsets(Insets insets) {
        return this.insets;
    }

    @Override
    public void setLocation(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            this.preferredSize = new Dimension(Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
        if (this.preferredSize.width == Integer.MIN_VALUE) {
            this.textWidth = this.text == null || this.text.isEmpty() ? 0 : this.fontMetrics.stringWidth(this.text);
            this.preferredSize.width = this.iconWidth + this.textWidth;
            if (this.iconWidth > 0 && this.textWidth > 0) {
                this.preferredSize.width += this.iconTextGap;
            }
        }
        if (this.preferredSize.height == Integer.MIN_VALUE) {
            this.fontAscent = this.fontMetrics.getAscent();
            this.preferredSize.height = this.fontAscent + this.fontMetrics.getDescent();
        }
        return this.preferredSize;
    }

    @Override
    public void setUI(LabelUI labelUI) {
        super.setUI(UI);
    }

    private void resetPreferredSize(boolean bl, boolean bl2) {
        if (this.preferredSize == null) {
            return;
        }
        if (bl) {
            this.preferredSize.width = Integer.MIN_VALUE;
        }
        if (bl2) {
            this.preferredSize.height = Integer.MIN_VALUE;
        }
    }

    protected void prePaint(Graphics graphics, int n, int n2) {
    }

    protected void postPaint(Graphics graphics, int n, int n2) {
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics graphics2 = this.getComponentGraphics(graphics);
        this.prePaint(graphics2, this.x, this.y);
        int n = this.x;
        if (this.iconWidth > 0) {
            int n2 = (this.preferredSize.height - this.iconHeight) / 2;
            this.icon.paintIcon(this, graphics2, n, this.y + n2);
            n += this.iconWidth + this.iconTextGap;
        }
        if (this.textWidth > 0) {
            UI.paintEnabledText(this, graphics2, this.text, n, this.y + this.fontAscent);
        }
        this.postPaint(graphics2, this.x, this.y);
    }

    @Override
    public void setText(String string) {
        this.text = string;
        this.resetPreferredSize(true, false);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setIcon(Icon icon) {
        int n = this.iconWidth;
        this.iconWidth = icon == null ? 0 : icon.getIconWidth();
        this.iconHeight = icon == null ? 0 : icon.getIconHeight();
        this.icon = icon;
        if (n != this.iconWidth) {
            this.resetPreferredSize(true, false);
        }
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void setForeground(Color color) {
        this.foreground = color;
    }

    @Override
    public Color getForeground() {
        return this.foreground;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int getDisplayedMnemonicIndex() {
        return -1;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this.fontMetrics;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = super.getFontMetrics(font);
        this.resetPreferredSize(true, true);
    }

    @Override
    public int getIconTextGap() {
        return this.iconTextGap;
    }

    @Override
    public void setIconTextGap(int n) {
        this.iconTextGap = n;
        this.resetPreferredSize(true, false);
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void setDisplayedMnemonic(int n) {
    }

    @Override
    public void setDisplayedMnemonic(char c) {
    }

    @Override
    public void setDisplayedMnemonicIndex(int n) {
    }

    @Override
    public void firePropertyChange(String string, byte by, byte by2) {
    }

    @Override
    public void firePropertyChange(String string, char c, char c2) {
    }

    @Override
    public void firePropertyChange(String string, short s, short s2) {
    }

    @Override
    public void firePropertyChange(String string, int n, int n2) {
    }

    @Override
    public void firePropertyChange(String string, long l, long l2) {
    }

    @Override
    public void firePropertyChange(String string, float f, float f2) {
    }

    @Override
    public void firePropertyChange(String string, double d, double d2) {
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
    }

    private static class LabelRendererUI
    extends BasicLabelUI {
        private LabelRendererUI() {
        }

        @Override
        protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
            super.paintEnabledText(jLabel, graphics, string, n, n2);
        }
    }
}

