/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.prefs;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.multitabs.impl.ProjectSupport;
import org.netbeans.core.multitabs.prefs.MultiTabsOptionsPanelController;
import org.netbeans.core.multitabs.prefs.SettingsImpl;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class InnerTabsPanel
extends JPanel {
    private final SettingsImpl settings = new SettingsImpl();
    private final MultiTabsOptionsPanelController controller;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    JCheckBox checkMultiRow;
    JCheckBox checkProjectColors;
    JCheckBox checkShowFolderName;
    JCheckBox checkShowFullPath;
    JCheckBox checkSortDocumentList;
    JLabel jLabel1;
    JRadioButton radioPlacementBottom;
    JRadioButton radioPlacementLeft;
    JRadioButton radioPlacementRight;
    JRadioButton radioPlacementTop;
    JRadioButton radioRowCount;
    JRadioButton radioRowPerProject;
    JSpinner spinRowCount;

    public InnerTabsPanel(MultiTabsOptionsPanelController multiTabsOptionsPanelController) {
        this.controller = multiTabsOptionsPanelController;
        this.initComponents();
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                InnerTabsPanel.this.fireChanged();
                InnerTabsPanel.this.enableControls();
            }
        };
        this.radioPlacementBottom.addItemListener(itemListener);
        this.radioPlacementLeft.addItemListener(itemListener);
        this.radioPlacementRight.addItemListener(itemListener);
        this.radioPlacementTop.addItemListener(itemListener);
        this.checkShowFolderName.addItemListener(itemListener);
        this.checkShowFullPath.addItemListener(itemListener);
        this.checkProjectColors.addItemListener(itemListener);
        this.checkSortDocumentList.addItemListener(itemListener);
        this.checkMultiRow.addItemListener(itemListener);
        this.radioRowCount.addItemListener(itemListener);
        this.radioRowPerProject.addItemListener(itemListener);
        this.spinRowCount.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                InnerTabsPanel.this.fireChanged();
            }
        });
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.radioRowCount = new JRadioButton();
        this.spinRowCount = new JSpinner();
        this.radioRowPerProject = new JRadioButton();
        this.checkSortDocumentList = new JCheckBox();
        this.checkMultiRow = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.checkProjectColors = new JCheckBox();
        this.radioPlacementRight = new JRadioButton();
        this.radioPlacementBottom = new JRadioButton();
        this.radioPlacementLeft = new JRadioButton();
        this.radioPlacementTop = new JRadioButton();
        this.checkShowFullPath = new JCheckBox();
        this.checkShowFolderName = new JCheckBox();
        this.buttonGroup2.add(this.radioRowCount);
        this.radioRowCount.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.radioRowCount, (String)NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.radioRowCount.text"));
        this.spinRowCount.setModel(new SpinnerNumberModel(3, 2, 10, 1));
        this.buttonGroup2.add(this.radioRowPerProject);
        Mnemonics.setLocalizedText((AbstractButton)this.radioRowPerProject, (String)NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.radioRowPerProject.text"));
        this.radioRowPerProject.setActionCommand(NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.radioRowPerProject.actionCommand"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkSortDocumentList, (String)NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.checkSortDocumentList.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkMultiRow, (String)NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.checkMultiRow.text"));
        this.checkMultiRow.setActionCommand(NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.checkMultiRow.actionCommand"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkProjectColors, (String)NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.checkProjectColors.text"));
        this.checkProjectColors.setActionCommand(NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.checkProjectColors.actionCommand"));
        this.buttonGroup1.add(this.radioPlacementRight);
        Mnemonics.setLocalizedText((AbstractButton)this.radioPlacementRight, (String)NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.radioPlacementRight.text"));
        this.buttonGroup1.add(this.radioPlacementBottom);
        Mnemonics.setLocalizedText((AbstractButton)this.radioPlacementBottom, (String)NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.radioPlacementBottom.text"));
        this.buttonGroup1.add(this.radioPlacementLeft);
        Mnemonics.setLocalizedText((AbstractButton)this.radioPlacementLeft, (String)NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.radioPlacementLeft.text"));
        this.buttonGroup1.add(this.radioPlacementTop);
        this.radioPlacementTop.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.radioPlacementTop, (String)NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.radioPlacementTop.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkShowFullPath, (String)NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.checkShowFullPath.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkShowFolderName, (String)NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.checkShowFolderName.text"));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkShowFolderName).addComponent(this.checkShowFullPath).addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 4, -2).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radioPlacementLeft).addComponent(this.radioPlacementTop).addComponent(this.radioPlacementBottom).addComponent(this.radioPlacementRight)))).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkMultiRow).addGroup(groupLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radioRowPerProject).addGroup(groupLayout.createSequentialGroup().addComponent(this.radioRowCount).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinRowCount, -2, -1, -2)))).addComponent(this.checkProjectColors).addComponent(this.checkSortDocumentList)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.radioPlacementTop)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioPlacementLeft).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioPlacementBottom).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioPlacementRight)).addGroup(groupLayout.createSequentialGroup().addComponent(this.checkMultiRow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spinRowCount, -2, -1, -2).addComponent(this.radioRowCount)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioRowPerProject))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.checkShowFolderName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkShowFullPath)).addGroup(groupLayout.createSequentialGroup().addComponent(this.checkProjectColors).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkSortDocumentList))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void fireChanged() {
        boolean bl = false;
        if (this.checkShowFolderName.isSelected() != this.settings.isShowFolderName() || this.checkShowFullPath.isSelected() != this.settings.isShowFullPath() || this.checkProjectColors.isSelected() != this.settings.isSameProjectSameColor() || this.checkSortDocumentList.isSelected() != this.settings.isSortDocumentListByProject()) {
            bl = true;
        }
        int n = this.settings.getRowCount();
        if (this.checkMultiRow.isSelected() && this.radioRowCount.isSelected()) {
            n = ((Number)this.spinRowCount.getValue()).intValue();
        }
        if (this.checkMultiRow.isSelected() != (n > 1 || this.settings.isTabRowPerProject())) {
            bl = true;
        }
        if (n != this.settings.getRowCount()) {
            bl = true;
        }
        if (this.radioRowPerProject.isSelected() != this.settings.isTabRowPerProject()) {
            bl = true;
        }
        if (this.radioPlacementBottom.isSelected() && this.settings.getTabsLocation() != 3 || this.radioPlacementLeft.isSelected() && this.settings.getTabsLocation() != 2 || this.radioPlacementRight.isSelected() && this.settings.getTabsLocation() != 4 || this.radioPlacementTop.isSelected() && this.settings.getTabsLocation() != 1) {
            bl = true;
        }
        this.controller.changed(null, bl);
    }

    void load() {
        ProjectSupport projectSupport = ProjectSupport.getDefault();
        switch (this.settings.getTabsLocation()) {
            case 2: {
                this.radioPlacementLeft.setSelected(true);
                break;
            }
            case 4: {
                this.radioPlacementRight.setSelected(true);
                break;
            }
            case 3: {
                this.radioPlacementBottom.setSelected(true);
                break;
            }
            default: {
                this.radioPlacementTop.setSelected(true);
            }
        }
        this.checkShowFolderName.setSelected(this.settings.isShowFolderName());
        this.checkShowFullPath.setSelected(this.settings.isShowFullPath());
        this.checkProjectColors.setSelected(this.settings.isSameProjectSameColor());
        this.checkSortDocumentList.setSelected(this.settings.isSortDocumentListByProject());
        int n = this.settings.getRowCount();
        this.checkMultiRow.setSelected(n > 1 || this.settings.isTabRowPerProject());
        if (n > 1) {
            this.spinRowCount.getModel().setValue(n);
        }
        this.radioRowPerProject.setSelected(this.settings.isTabRowPerProject());
        this.radioRowCount.setSelected(n > 1);
        this.radioRowPerProject.setVisible(projectSupport.isEnabled());
        this.checkProjectColors.setVisible(projectSupport.isEnabled());
        this.checkSortDocumentList.setVisible(projectSupport.isEnabled());
        this.enableControls();
    }

    boolean store() {
        boolean bl = false;
        int n = 1;
        if (this.radioPlacementBottom.isSelected()) {
            n = 3;
        } else if (this.radioPlacementLeft.isSelected()) {
            n = 2;
        } else if (this.radioPlacementRight.isSelected()) {
            n = 4;
        }
        bl |= this.settings.setTabsLocation(n);
        bl |= this.settings.setShowFullPath(this.checkShowFullPath.isSelected());
        bl |= this.settings.setSameProjectSameColor(this.checkProjectColors.isSelected());
        int n2 = 1;
        if (this.checkMultiRow.isSelected() && this.radioRowCount.isSelected()) {
            n2 = ((Number)this.spinRowCount.getValue()).intValue();
        }
        bl |= this.settings.setRowCount(n2);
        bl |= this.settings.setTabRowPerProject(this.radioRowPerProject.isSelected() && this.checkMultiRow.isSelected());
        bl |= this.settings.setShowFolderName(this.checkShowFolderName.isSelected());
        return bl |= this.settings.setSortDocumentListByProject(this.checkSortDocumentList.isSelected());
    }

    private void enableControls() {
        boolean bl = this.radioPlacementTop.isSelected() || this.radioPlacementBottom.isSelected();
        this.checkShowFullPath.setEnabled(bl);
        this.checkMultiRow.setEnabled(bl);
        if (!bl) {
            this.checkMultiRow.setSelected(false);
            this.checkShowFullPath.setSelected(false);
        }
        this.radioRowCount.setEnabled(this.checkMultiRow.isSelected());
        this.radioRowPerProject.setEnabled(this.checkMultiRow.isSelected());
        this.spinRowCount.setEnabled(this.checkMultiRow.isSelected() && bl && this.radioRowCount.isSelected());
    }
}

