/*
 * Decompiled with CFR 0.152.
 */
package utilAHT.datasUtilAHT;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import utilAHT.datasUtilAHT.ValueObjectDate;

public class DiferencaEntreDatasAHT {
    public static SimpleDateFormat simpleDateFormatData = new SimpleDateFormat("dd/MM/yyyy");
    public static SimpleDateFormat simpleDateFormatDataHoraDoisPontos = new SimpleDateFormat("dd/MM/yyyy HH:mm");
    public static SimpleDateFormat simpleDateFormatDataHoraHM = new SimpleDateFormat("dd/MM/yyyy HH'h'mm'm'");

    public static final String getStringDataAtual() {
        return simpleDateFormatData.format(new Date());
    }

    public static final String getStringDataHoraAtual() {
        return simpleDateFormatDataHoraDoisPontos.format(new Date());
    }

    public static ValueObjectDate calculaDiferencaCompletaEntreDatasAHT(Date data1, Date data2) {
        int difMeses;
        int difDias;
        Calendar dataFuturo = Calendar.getInstance();
        Calendar dataPassado = Calendar.getInstance();
        int[] monthDay = new int[]{31, -1, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (data1.after(data2)) {
            dataFuturo.setTime(data1);
            dataPassado.setTime(data2);
        } else {
            dataFuturo.setTime(data2);
            dataPassado.setTime(data1);
        }
        System.out.println("#########################################");
        System.out.println("Data Passado = " + new SimpleDateFormat("dd/MM/yyyy").format(dataPassado.getTime()));
        System.out.println("=>dataPassado.get(Calendar.DATE)=" + dataPassado.get(5));
        System.out.println("=>dataPassado.get(Calendar.MONTH)=" + dataPassado.get(2));
        System.out.println("=>dataPassado.get(Calendar.YEAR)=" + dataPassado.get(1));
        System.out.println("----------------------------------------");
        System.out.println("Data Futuro = " + new SimpleDateFormat("dd/MM/yyyy").format(dataFuturo.getTime()));
        System.out.println("=>dataPassado.get(Calendar.DATE)=" + dataFuturo.get(5));
        System.out.println("=>dataPassado.get(Calendar.MONTH)=" + dataFuturo.get(2));
        System.out.println("=>dataPassado.get(Calendar.YEAR)=" + dataFuturo.get(1));
        System.out.println("----------------------------------------");
        int increment = 0;
        if (dataPassado.get(5) > dataFuturo.get(5)) {
            increment = monthDay[dataPassado.get(2) + 1 - 1];
        }
        if (increment == -1) {
            increment = DiferencaEntreDatasAHT.isAnoBissexto(dataPassado.get(1)) ? 29 : 28;
        }
        if (increment != 0) {
            difDias = dataFuturo.get(5) + increment - dataPassado.get(5);
            increment = 1;
        } else {
            difDias = dataFuturo.get(5) - dataPassado.get(5);
        }
        if (dataPassado.get(2) + 1 + increment > dataFuturo.get(2) + 1) {
            difMeses = dataFuturo.get(2) + 1 + 12 - (dataPassado.get(2) + 1 + increment);
            increment = 1;
        } else {
            difMeses = dataFuturo.get(2) + 1 - (dataPassado.get(2) + 1 + increment);
            increment = 0;
        }
        int difAnos = dataFuturo.get(1) - (dataPassado.get(1) + increment);
        System.out.println("----------------------------------------");
        System.out.println("Data Passado = " + new SimpleDateFormat("dd/MM/yyyy").format(dataPassado.getTime()));
        System.out.println("Data Futuro = " + new SimpleDateFormat("dd/MM/yyyy").format(dataFuturo.getTime()));
        System.out.println("----------------------------------------");
        System.out.println("Dif anos = " + difAnos + " anos ");
        System.out.println("Dif meses = " + difMeses + " meses ");
        System.out.println("Dif dias = " + difDias + " dias ");
        System.out.println("#########################################");
        return new ValueObjectDate(dataFuturo.getTime(), dataPassado.getTime(), difDias, difMeses, difAnos);
    }

    public static boolean isAnoBissexto(int ano) {
        return ano % 4 == 0 && ano % 100 != 0 || ano % 400 == 0;
    }

    public static double calculaQuantidadeEntreDatas(Date data1, Date data2, TipoDeResultadoDaComparacaoDeData tipoDeResultado) {
        Calendar dataFuturo = Calendar.getInstance();
        Calendar dataPassado = Calendar.getInstance();
        if (data1.after(data2)) {
            dataFuturo.setTime(data1);
            dataPassado.setTime(data2);
        } else {
            dataFuturo.setTime(data2);
            dataPassado.setTime(data1);
        }
        double result = 0.0;
        long diferenca = dataFuturo.getTimeInMillis() - dataPassado.getTimeInMillis();
        if (tipoDeResultado == TipoDeResultadoDaComparacaoDeData.RESULTADO_EM_DIAS) {
            double diferencaEmDias = diferenca / 1000L / 60L / 60L / 24L;
            long horasRestantes = diferenca / 1000L / 60L / 60L % 24L;
            result = diferencaEmDias + (double)horasRestantes / 24.0;
            return result;
        }
        if (tipoDeResultado == TipoDeResultadoDaComparacaoDeData.RESULTADO_EM_HORAS) {
            long diferencaEmHoras = diferenca / 1000L / 60L / 60L;
            long minutosRestantes = diferenca / 1000L / 60L % 60L;
            double horasRestantes = (double)minutosRestantes / 60.0;
            result = (double)diferencaEmHoras + horasRestantes;
            return result;
        }
        if (tipoDeResultado == TipoDeResultadoDaComparacaoDeData.RESULTADO_EM_MINUTOS) {
            double diferencaEmMinutos = diferenca / 1000L / 60L;
            long segundosRestantes = diferenca / 1000L % 60L;
            result = diferencaEmMinutos + (double)segundosRestantes / 60.0;
            return result;
        }
        if (tipoDeResultado == TipoDeResultadoDaComparacaoDeData.RESULTADO_EM_SEGUNDOS) {
            double diferencaEmSegundos = diferenca / 1000L;
            return diferencaEmSegundos;
        }
        return 0.0;
    }

    public static enum TipoDeResultadoDaComparacaoDeData {
        RESULTADO_EM_DIAS,
        RESULTADO_EM_HORAS,
        RESULTADO_EM_MINUTOS,
        RESULTADO_EM_SEGUNDOS;

    }
}

