/*
 * Decompiled with CFR 0.152.
 */
package leArquivoLnkAtalhoWindows;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import leArquivoLnkAtalhoWindows.Propriedades;

public class LeArquivoLnkAtalhoWindowsCore {
    private boolean isDirectory;
    private boolean isLocal;
    private String real_file;

    public Propriedades parse(File file) throws IOException, ParseException {
        FileInputStream in = new FileInputStream(file);
        Propriedades propriedades = null;
        try {
            propriedades = this.parseLink(LeArquivoLnkAtalhoWindowsCore.getBytes(in), file);
        }
        finally {
            ((InputStream)in).close();
        }
        return propriedades;
    }

    private String getRealFilename() {
        return this.real_file;
    }

    private boolean isLocal() {
        return this.isLocal;
    }

    private boolean isDirectory() {
        return this.isDirectory;
    }

    private static byte[] getBytes(InputStream in) throws IOException {
        return LeArquivoLnkAtalhoWindowsCore.getBytes(in, null);
    }

    private static byte[] getBytes(InputStream in, Integer max) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buff = new byte[256];
        while (max == null || max > 0) {
            int n = in.read(buff);
            if (n == -1) break;
            bout.write(buff, 0, n);
            if (max == null) continue;
            max = max - n;
        }
        in.close();
        return bout.toByteArray();
    }

    private static boolean isMagicPresent(byte[] link) {
        int magic = 76;
        boolean magic_offset = false;
        return link.length >= 32 && LeArquivoLnkAtalhoWindowsCore.bytesToDword(link, 0) == 76;
    }

    private Propriedades parseLink(byte[] link, File f) throws ParseException {
        String nomeDoAtalho = f.getName();
        String caminhoDoAtalho = f.getAbsolutePath();
        String caminhoCompletoDoArquivoDestino = "";
        String nomeDoArquivoDestino = "";
        String caminhoDaPastaDoArquivoDestino = "";
        try {
            if (!LeArquivoLnkAtalhoWindowsCore.isMagicPresent(link)) {
                throw new ParseException("Invalid shortcut; magic is missing", 0);
            }
            byte flags = link[20];
            int file_atts_offset = 24;
            byte file_atts = link[24];
            int is_dir_mask = 16;
            this.isDirectory = (file_atts & is_dir_mask) > 0;
            int shell_offset = 76;
            boolean has_shell_mask = true;
            int shell_len = 0;
            if ((flags & 1) > 0) {
                shell_len = LeArquivoLnkAtalhoWindowsCore.bytesToWord(link, 76) + 2;
            }
            int file_start = 76 + shell_len;
            int file_location_info_flag_offset_offset = 8;
            byte file_location_info_flag = link[file_start + 8];
            this.isLocal = (file_location_info_flag & 2) == 0;
            int basename_offset_offset = 16;
            int networkVolumeTable_offset_offset = 20;
            int finalname_offset_offset = 24;
            int finalname_offset = link[file_start + 24] + file_start;
            String finalname = LeArquivoLnkAtalhoWindowsCore.getNullDelimitedString(link, finalname_offset);
            if (this.isLocal) {
                int basename_offset = link[file_start + 16] + file_start;
                String basename = LeArquivoLnkAtalhoWindowsCore.getNullDelimitedString(link, basename_offset);
                this.real_file = String.valueOf(basename) + finalname;
            } else {
                int networkVolumeTable_offset = link[file_start + 20] + file_start;
                int shareName_offset_offset = 8;
                int shareName_offset = link[networkVolumeTable_offset + shareName_offset_offset] + networkVolumeTable_offset;
                String shareName = LeArquivoLnkAtalhoWindowsCore.getNullDelimitedString(link, shareName_offset);
                this.real_file = String.valueOf(shareName) + "\\" + finalname;
            }
            caminhoCompletoDoArquivoDestino = this.real_file;
            if (caminhoCompletoDoArquivoDestino.endsWith("\b")) {
                caminhoCompletoDoArquivoDestino = caminhoCompletoDoArquivoDestino.substring(0, caminhoCompletoDoArquivoDestino.length() - 1);
            }
            String[] spli = caminhoCompletoDoArquivoDestino.split("\\\\");
            nomeDoArquivoDestino = spli[spli.length - 1];
            int i = 0;
            while (i < spli.length - 1) {
                caminhoDaPastaDoArquivoDestino = String.valueOf(caminhoDaPastaDoArquivoDestino) + spli[i] + "\\";
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            String msg;
            System.out.println("Erro Lendo arquivo: " + f.getAbsolutePath());
            nomeDoArquivoDestino = "Erro ao ler arquivo de destino";
            caminhoCompletoDoArquivoDestino = msg = "Erro ao parsear o arquivo .lnk. O arquivo pode ser um arquivo invalido ou pode ser que ele aponte um servico do sistema ou nao aponte para nenhum arquivo destino";
            caminhoDaPastaDoArquivoDestino = msg;
        }
        Propriedades propriedades = new Propriedades(nomeDoAtalho, caminhoDoAtalho, caminhoCompletoDoArquivoDestino, nomeDoArquivoDestino, caminhoDaPastaDoArquivoDestino);
        return propriedades;
    }

    private static String getNullDelimitedString(byte[] bytes, int off) {
        int len = 0;
        while (bytes[off + len] != 0) {
            ++len;
        }
        return new String(bytes, off, len);
    }

    private static int bytesToWord(byte[] bytes, int off) {
        return (bytes[off + 1] & 0xFF) << 8 | bytes[off] & 0xFF;
    }

    private static int bytesToDword(byte[] bytes, int off) {
        return LeArquivoLnkAtalhoWindowsCore.bytesToWord(bytes, off + 2) << 16 | LeArquivoLnkAtalhoWindowsCore.bytesToWord(bytes, off);
    }

    public static void main(String[] args) throws Exception {
        File f = new File("C:\\Instalados\\System_Shortcuts\\cpf.lnk");
        LeArquivoLnkAtalhoWindowsCore leArquivoLnkAtalhoWindowsCore = new LeArquivoLnkAtalhoWindowsCore();
        Propriedades propriedades = leArquivoLnkAtalhoWindowsCore.parse(f);
        System.out.println("getNomeDoAtalho = " + propriedades.getNomeDoAtalho());
        System.out.println("getCaminhoDoAtalho = " + propriedades.getCaminhoDoAtalho());
        System.out.println("getNomeDoArquivoDestino = " + propriedades.getNomeDoArquivoDestino());
        System.out.println("getCaminhoCompletoDoArquivoDestino = " + propriedades.getCaminhoCompletoDoArquivoDestino());
        System.out.println("getCaminhoDaPastaDoArquivoDestino = " + propriedades.getCaminhoDaPastaDoArquivoDestino());
    }
}

