/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.uimodel;

import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.RenderInfo;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIComponentChange;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIGarbageCollector;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThread;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThreadGroup;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UITrack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UIComponents {
    private List<UIThreadGroup> m_threadGroups = new ArrayList<UIThreadGroup>();
    private List<UIThread> m_threads = new ArrayList<UIThread>();
    private final List<UIComponentChange> m_listeners = new ArrayList<UIComponentChange>(5);
    private UIGarbageCollector m_garbageCollector;

    public void addListener(UIComponentChange listener) {
        this.m_listeners.add(listener);
    }

    public void removeListener(UIComponentChange listener) {
        this.m_listeners.remove(listener);
    }

    public void markComponentsDirty(boolean structural) {
        for (UIThreadGroup uiThreadGroup : this.getThreadGroups()) {
            if (structural) {
                uiThreadGroup.getRenderInfo().getSampleComponent().getSampleInfo().setStructuralDirty(true);
            }
            uiThreadGroup.getRenderInfo().setNonStructuralDirty(true);
            for (UIThread uiThread : uiThreadGroup.getThreads()) {
                if (structural) {
                    uiThread.getRenderInfo().getSampleComponent().getSampleInfo().setStructuralDirty(true);
                }
                uiThread.getRenderInfo().setNonStructuralDirty(true);
                this.markTrackStructuralDirty(uiThread.getTracks(), structural);
            }
            for (RenderInfo renderInfo : uiThreadGroup.getRenderInfos()) {
                if (structural) {
                    renderInfo.getSampleComponent().getSampleInfo().setStructuralDirty(true);
                }
                renderInfo.setNonStructuralDirty(true);
            }
        }
        this.getGarbageCollector().getEvenRenderInfo().setNonStructuralDirty(true);
        this.getGarbageCollector().getOddRenderInfo().setNonStructuralDirty(true);
        if (structural) {
            this.getGarbageCollector().setStructuralDirty(structural);
        }
        this.markTrackStructuralDirty(this.getGarbageCollector().getTracks(), structural);
        this.fireChange(structural);
    }

    public void markTrackStructuralDirty(Collection<UITrack> tracks, boolean structural) {
        for (UITrack uiTrack : tracks) {
            if (structural) {
                uiTrack.getRenderInfo().getSampleComponent().getSampleInfo().setStructuralDirty(true);
            }
            uiTrack.getRenderInfo().setNonStructuralDirty(true);
        }
    }

    public void fireChange(boolean structural) {
        for (UIComponentChange uiComponentChange : this.m_listeners) {
            uiComponentChange.onUIComponentChange(structural);
        }
    }

    public Collection<UIThreadGroup> getThreadGroups() {
        return this.m_threadGroups;
    }

    void setThreads(List<UIThread> threads) {
        this.m_threads = threads;
    }

    public void setThreadGroups(List<UIThreadGroup> threadGroups) {
        this.m_threadGroups = threadGroups;
    }

    public UIGarbageCollector getGarbageCollector() {
        return this.m_garbageCollector;
    }

    public List<UIThread> getThreads() {
        return this.m_threads;
    }

    public void setGarbageCollector(UIGarbageCollector uiGarbageCollector) {
        this.m_garbageCollector = uiGarbageCollector;
    }

    public void dispose() {
        this.m_listeners.clear();
    }
}

