/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.sections;

import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.HelpSupport;
import com.jrockit.mc.ui.misc.MCToolBarManager;
import com.jrockit.mc.ui.site.IServiceRegistry;
import com.jrockit.mc.ui.site.SectionSite;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class MCSectionPart
extends SectionPart
implements HelpListener {
    public static final int BORDER_WIDTH = 1;
    public static final int HEIGHT_HINT = 50;
    public static final int WIDTH_HINT = 50;
    public static final int DEFAULT_NO_TITLE_STYLE = 4096;
    public static final int DEFAULT_TITLE_STYLE = 256;
    public static final int DEFAULT_TITLE_DESCRIPTION_STYLE = 384;
    public static final int DEFAULT_TWISTIE_STYLE = 322;
    public static final int DEFAULT_TWISTIE_DESCRIPTION_STYLE = 450;
    private String m_sectionIdentifier;
    private String m_helpContextID;
    protected final FormToolkit m_toolkit;
    protected MCToolBarManager m_toolBarManager;
    private SectionSite m_sectionSite;
    private IAction m_action;
    private boolean m_initializedModel;

    public MCSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier) {
        super(parent, toolkit, style);
        this.m_toolkit = toolkit;
        this.m_sectionIdentifier = sectionIdentifier;
        this.getSection().setData("name", (Object)sectionIdentifier);
        if (HelpSupport.getHelpAction(sectionIdentifier) != null) {
            this.m_helpContextID = sectionIdentifier;
        }
        if (HelpSupport.getHelpAction(((Object)((Object)this)).getClass().getName()) != null) {
            this.m_helpContextID = ((Object)((Object)this)).getClass().getName();
        }
        if (HelpSupport.getHelpContextID((Widget)this.getSection()) != null) {
            this.m_helpContextID = HelpSupport.getHelpContextID((Widget)this.getSection());
        }
    }

    public SectionSite getSite() {
        return this.m_sectionSite;
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        this.m_sectionSite = new SectionSite(this.m_sectionIdentifier, this.getFormContainerSite(), this.getParentService());
        if (this.m_toolBarManager == null) {
            this.createToolBarManager();
        }
        this.updateHelpAction();
    }

    protected void setSectionIdentifier(String identifier) {
        if (this.m_sectionSite != null) {
            this.m_sectionSite.setIdentifier(identifier);
        }
        this.m_sectionIdentifier = identifier;
        this.getSection().setData("name", (Object)this.m_sectionIdentifier);
    }

    private IServiceRegistry getParentService() {
        Object container;
        IManagedForm form = this.getManagedForm();
        if (this.getManagedForm() != null && (container = form.getContainer()) instanceof IServiceRegistry) {
            return (IServiceRegistry)container;
        }
        return null;
    }

    public String getSectionIdentifier() {
        return this.m_sectionIdentifier;
    }

    protected void updateHelpAction() {
        Action newAction = HelpSupport.getHelpAction(this.getHelpContextID());
        if (newAction != null) {
            if (this.m_action != null) {
                this.getMCToolBarManager().remove(this.m_action);
                this.m_action = null;
                this.getSection().removeHelpListener((HelpListener)this);
            }
            this.m_action = newAction;
            this.getMCToolBarManager().add(this.m_action, 30);
            this.getSection().addHelpListener((HelpListener)this);
        }
    }

    public void setHelpContextID(String contextID) {
        this.m_helpContextID = contextID;
        this.updateHelpAction();
    }

    protected String getHelpContextID() {
        return this.m_helpContextID;
    }

    protected boolean hasTitle() {
        return (this.getSection().getExpansionStyle() & 0x100) != 0 || (this.getSection().getExpansionStyle() & 0x200) != 0;
    }

    public void helpRequested(HelpEvent e) {
        if (this.m_action != null) {
            this.m_action.run();
        }
    }

    public MCToolBarManager getMCToolBarManager() {
        if (this.m_toolBarManager == null) {
            this.createToolBarManager();
        }
        return this.m_toolBarManager;
    }

    private void createToolBarManager() {
        this.m_toolBarManager = new MCToolBarManager((Composite)this.getSection());
        this.getSection().setTextClient((Control)this.m_toolBarManager.getToolBar());
    }

    public void setFocus() {
        if (this.getSection() != null && !this.getSection().isDisposed()) {
            this.getSection().setFocus();
        }
    }

    protected IWorkbenchPartSite getFormContainerSite() {
        Object container;
        IManagedForm form = this.getManagedForm();
        if (this.getManagedForm() != null && (container = form.getContainer()) instanceof IWorkbenchPart) {
            return ((IWorkbenchPart)container).getSite();
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        if (this.m_toolBarManager != null) {
            this.m_toolBarManager.dispose();
            this.m_toolBarManager = null;
        }
        if (this.m_sectionSite != null) {
            this.m_sectionSite.dispose();
        }
    }

    protected FormToolkit getFormToolkit() {
        return this.m_toolkit;
    }

    protected ScrolledForm getForm() {
        return this.getManagedForm().getForm();
    }

    protected Object getInput() {
        return this.getManagedForm().getInput();
    }

    public final void refresh() {
        if (!this.m_initializedModel) {
            this.m_initializedModel = true;
            this.initializePart();
        }
        this.refreshPart();
        this.markPartRefreshed();
    }

    public void refreshPart() {
    }

    protected void markPartRefreshed() {
        super.refresh();
    }

    protected void initializePart() {
    }

    protected boolean isPartInitialized() {
        return this.m_initializedModel;
    }

    public static int getAccessibilityDescriptionStyle() {
        if (UIPlugin.getDefault().getAccessibilityMode()) {
            return 384;
        }
        return 256;
    }
}

