/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.sections;

import com.jrockit.mc.common.util.ExceptionToolkit;
import com.jrockit.mc.ui.misc.MCLayoutFactory;
import com.jrockit.mc.ui.sections.MCSectionPart;
import com.jrockit.mc.ui.sections.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class MCClientSectionPart
extends MCSectionPart {
    public MCClientSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier) {
        super(parent, toolkit, style, sectionIdentifier);
    }

    protected abstract Composite createClient(IManagedForm var1, FormToolkit var2, Composite var3) throws Exception;

    protected abstract void initializeSection(Section var1);

    @Override
    public void initialize(IManagedForm form) {
        super.initialize(form);
        this.initializeSection(this.getSection());
        this.getSection().setLayout(MCLayoutFactory.createPaintBordersMarginFreeFormPageLayout(1));
        Composite client = null;
        try {
            client = this.createClient(form, this.getFormToolkit(), (Composite)this.getSection());
        }
        catch (Exception e) {
            client = this.createErrorControl(e);
            this.getSection().setText(Messages.MCClientSectionPart_FAILED_TO_INITIALIZE_COMPONENT);
        }
        client.setLayoutData(MCLayoutFactory.createFormPageLayoutData());
        this.getSection().setClient((Control)client);
        this.getFormToolkit().paintBordersFor(client);
    }

    private Composite createErrorControl(Exception e) {
        Composite composite = this.getFormToolkit().createComposite((Composite)this.getSection());
        composite.setLayout((Layout)new GridLayout());
        Text text = new Text(composite, 2816);
        text.setText(String.valueOf(Messages.MCClientSectionPart_FAILED_TO_INITIALIZE_COMPONENT) + "\n" + ExceptionToolkit.toString((Throwable)e));
        text.setLayoutData((Object)new GridData(4, 4, true, true));
        return composite;
    }

    @Override
    public void setFocus() {
        if (this.getSection() != null && this.getSection().isDisposed() && this.getSection().getClient() != null && !this.getSection().getClient().isDisposed()) {
            this.getSection().getClient().setFocus();
        }
    }
}

