/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.formpage.internal;

import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.formpage.FormPageContribution;
import com.jrockit.mc.ui.formpage.FormPageContributionGroup;
import com.jrockit.mc.ui.formpage.FormPageContributionItem;
import com.jrockit.mc.ui.formpage.internal.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.forms.editor.FormEditor;

public class FormPageContributionToolkit {
    public static final String OTHER_ID = "com.jrockit.mc.ui.formpages.group.other";
    private static final String ACCESSIBILITY_GROUP_NAME_FORMAT = "{0} - {1}";

    public static void initializeContributionsWithEditor(List<? extends FormPageContribution> rootNodes, FormEditor formeditor) {
        for (FormPageContribution formPageContribution : rootNodes) {
            if (formPageContribution instanceof FormPageContributionItem) {
                FormPageContributionItem item = (FormPageContributionItem)formPageContribution;
                try {
                    item.getFormPage().initialize(formeditor);
                }
                catch (Exception e) {
                    UIPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not initialize FormPage with label " + item.getLabel() + ". It will be invisible.", e);
                    item.setVisible(Boolean.FALSE);
                }
                continue;
            }
            if (!(formPageContribution instanceof FormPageContributionGroup)) continue;
            FormPageContributionGroup group = (FormPageContributionGroup)formPageContribution;
            FormPageContributionToolkit.initializeContributionsWithEditor(group.getChildren(), formeditor);
        }
    }

    public static <T extends FormPageContribution> List<T> flatten(Collection<? extends FormPageContribution> rootNodes, Class<T> assignableFromClass, int depth, boolean onlyVisible) {
        ArrayList<FormPageContribution> list = new ArrayList<FormPageContribution>();
        if (depth >= 0) {
            for (FormPageContribution formPageContribution : rootNodes) {
                if (assignableFromClass.isInstance(formPageContribution) && (!onlyVisible || Boolean.TRUE.equals(formPageContribution.getVisible()))) {
                    list.add((FormPageContribution)assignableFromClass.cast(formPageContribution));
                }
                if (!(formPageContribution instanceof FormPageContributionGroup) || onlyVisible && !Boolean.TRUE.equals(formPageContribution.getVisible())) continue;
                List<FormPageContribution> children = ((FormPageContributionGroup)formPageContribution).getChildren();
                list.addAll(FormPageContributionToolkit.flatten(children, assignableFromClass, depth - 1, onlyVisible));
            }
        }
        return list;
    }

    public static List<FormPageContributionGroup> transformToTwoLevels(List<FormPageContribution> rootContributions) {
        List<FormPageContributionGroup> allTopLevelCategories = FormPageContributionToolkit.flatten(rootContributions, FormPageContributionGroup.class, 0, true);
        List<FormPageContributionItem> noGroupsItems = FormPageContributionToolkit.flatten(rootContributions, FormPageContributionItem.class, 0, true);
        ArrayList<FormPageContributionGroup> formPageContributions = new ArrayList<FormPageContributionGroup>();
        for (FormPageContributionGroup group : allTopLevelCategories) {
            List<FormPageContributionItem> allValidChildrenItems = FormPageContributionToolkit.flatten(group.getChildren(), FormPageContributionItem.class, Integer.MAX_VALUE, true);
            if (allValidChildrenItems.isEmpty() || !Boolean.TRUE.equals(group.getVisible())) continue;
            formPageContributions.add(group);
            group.clear();
            group.addAll(allValidChildrenItems);
        }
        if (!noGroupsItems.isEmpty()) {
            FormPageContributionGroup groupForUnGrouped = new FormPageContributionGroup("misc");
            groupForUnGrouped.addAll(noGroupsItems);
            groupForUnGrouped.setLabel(Messages.FormPageContributionToolkit_OTHER_GROUP_TEXT);
            groupForUnGrouped.setIcon(UIPlugin.getDefault().getImage("fldr_obj.gif"), false);
            groupForUnGrouped.setLargeIcon(UIPlugin.getDefault().getImage("tabgroup_other.png"), false);
            groupForUnGrouped.setVisible(true);
            formPageContributions.add(groupForUnGrouped);
        }
        return formPageContributions;
    }

    public static void prettyPrint(List<FormPageContribution> rootContributions, String indent) {
        for (FormPageContribution fpc : rootContributions) {
            FormPageContribution f;
            if (fpc instanceof FormPageContributionGroup) {
                f = (FormPageContributionGroup)fpc;
                System.out.println("*" + f.getLabel());
                FormPageContributionToolkit.prettyPrint(((FormPageContributionGroup)f).getChildren(), String.valueOf(indent) + "    ");
            }
            if (!(fpc instanceof FormPageContributionItem)) continue;
            f = (FormPageContributionItem)fpc;
            System.out.println(String.valueOf(indent) + f.getLabel());
        }
    }

    public static void disposeFormPageContributions(List<? extends FormPageContribution> items) {
        for (FormPageContribution formPageContribution : items) {
            if (formPageContribution instanceof FormPageContributionGroup) {
                FormPageContributionGroup group = (FormPageContributionGroup)formPageContribution;
                FormPageContributionToolkit.disposeFormPageContributions(group.getChildren());
            }
            formPageContribution.dispose();
        }
    }

    public static <T extends FormPageContribution> T findWithId(List<? extends FormPageContribution> contribs, String id, Class<T> clazz) {
        for (FormPageContribution formPageContribution : contribs) {
            if (!clazz.isInstance(formPageContribution) || !id.equals(formPageContribution.getId())) continue;
            FormPageContribution t = formPageContribution;
            return (T)t;
        }
        return null;
    }

    public static List<FormPageContributionItem> flattenButPreserveGroupNames(List<FormPageContributionGroup> groups) {
        ArrayList<FormPageContributionItem> newFlattenedList = new ArrayList<FormPageContributionItem>();
        for (FormPageContributionGroup group : groups) {
            List<FormPageContributionItem> allValidChildrenItems = FormPageContributionToolkit.flatten(group.getChildren(), FormPageContributionItem.class, Integer.MAX_VALUE, true);
            for (FormPageContributionItem item : allValidChildrenItems) {
                FormPageContributionToolkit.setTitleWithGroupName(group.getLabel(), item);
                newFlattenedList.add(item);
            }
        }
        return newFlattenedList;
    }

    private static void setTitleWithGroupName(String groupName, FormPageContributionItem item) {
        item.setLabel(NLS.bind((String)ACCESSIBILITY_GROUP_NAME_FORMAT, (Object)groupName, (Object)item.getLabel()));
    }

    public static void sortRecursively(List<FormPageContribution> contribs) {
        Collections.sort(contribs);
        FormPageContributionToolkit.sortWithin(contribs);
    }

    private static void sortWithin(List<FormPageContribution> contribs) {
        for (FormPageContribution contrib : contribs) {
            if (!(contrib instanceof FormPageContributionGroup)) continue;
            FormPageContributionGroup grp = (FormPageContributionGroup)contrib;
            grp.sort();
            FormPageContributionToolkit.sortWithin(grp.getChildren());
        }
    }
}

