/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.bugspot;

import sun.jvm.hotspot.bugspot.PCFinder;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.runtime.JavaVFrame;

public class StackTraceEntry {
    private CFrame cFrame;
    private CDebugger dbg;
    private JavaVFrame javaFrame;
    private String value;
    private boolean isUnknownCFrame;

    public StackTraceEntry(CFrame cFrame, CDebugger dbg) {
        this.cFrame = cFrame;
        this.dbg = dbg;
        this.computeValue();
    }

    public StackTraceEntry(JavaVFrame javaFrame) {
        this.javaFrame = javaFrame;
        this.computeValue();
    }

    public boolean isCFrame() {
        return this.cFrame != null;
    }

    public boolean isJavaFrame() {
        return this.javaFrame != null;
    }

    public CFrame getCFrame() {
        return this.cFrame;
    }

    public JavaVFrame getJavaFrame() {
        return this.javaFrame;
    }

    public boolean isUnknownCFrame() {
        return this.isUnknownCFrame;
    }

    public String toString() {
        return this.value;
    }

    private void computeValue() {
        this.isUnknownCFrame = true;
        this.value = "<unknown>";
        if (this.cFrame != null) {
            PCFinder.Info info = PCFinder.findPC(this.cFrame.pc(), this.cFrame.loadObjectForPC(), this.dbg);
            if (info.getName() != null) {
                this.value = "(C) " + info.getName();
                this.isUnknownCFrame = false;
                if (info.getConfidence() == 1) {
                    this.value = this.value + " (?)";
                }
                if (info.getOffset() >= 0L) {
                    this.value = this.value + " + 0x" + Long.toHexString(info.getOffset());
                }
            }
        } else if (this.javaFrame != null) {
            this.isUnknownCFrame = false;
            Method m = this.javaFrame.getMethod();
            this.value = "(J) " + m.externalNameAndSignature();
        }
    }
}

