/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.bugspot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.ThreadContext;
import sun.jvm.hotspot.debugger.ThreadProxy;

public class RegisterPanel
extends JPanel {
    private List registers = new ArrayList();
    private AbstractTableModel dataModel = new AbstractTableModel(){

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return RegisterPanel.this.registers.size();
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Register Name";
                }
                case 1: {
                    return "Register Value";
                }
            }
            throw new RuntimeException("Index " + col + " out of bounds");
        }

        @Override
        public Object getValueAt(int row, int col) {
            RegisterInfo info = (RegisterInfo)RegisterPanel.this.registers.get(row);
            switch (col) {
                case 0: {
                    return info.getName();
                }
                case 1: {
                    if (RegisterPanel.this.valid) {
                        Address val = info.getValue();
                        if (val != null) {
                            return val;
                        }
                        return RegisterPanel.this.nullAddressString;
                    }
                    return "-";
                }
            }
            throw new RuntimeException("Index (" + col + ", " + row + ") out of bounds");
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == 0) {
                return false;
            }
            if (!RegisterPanel.this.valid) {
                return false;
            }
            if (RegisterPanel.this.curThread == null) {
                return false;
            }
            if (!RegisterPanel.this.curThread.canSetContext()) {
                return false;
            }
            return false;
        }
    };
    private boolean valid;
    private boolean editable;
    private String nullAddressString;
    private ThreadProxy curThread;
    private JTable table;

    public RegisterPanel() {
        this.setLayout(new BorderLayout());
        this.table = new JTable(this.dataModel);
        this.table.setCellSelectionEnabled(true);
        this.table.setSelectionMode(1);
        this.table.setDragEnabled(true);
        JTableHeader header = this.table.getTableHeader();
        header.setReorderingAllowed(false);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add((Component)scrollPane, "Center");
    }

    public void update(ThreadProxy curThread) {
        this.curThread = curThread;
        ThreadContext context = curThread.getContext();
        this.editable = curThread.canSetContext();
        this.registers.clear();
        for (int i = 0; i < context.getNumRegisters(); ++i) {
            String name = context.getRegisterName(i);
            Address addr = context.getRegisterAsAddress(i);
            if (this.nullAddressString == null && addr != null) {
                String addrStr = addr.toString();
                StringBuffer buf = new StringBuffer();
                buf.append("0x");
                int len = addrStr.length() - 2;
                for (int j = 0; j < len; ++j) {
                    buf.append("0");
                }
                this.nullAddressString = buf.toString();
            }
            this.registers.add(new RegisterInfo(name, addr));
        }
        this.valid = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RegisterPanel.this.dataModel.fireTableDataChanged();
            }
        });
    }

    public void clear() {
        this.valid = false;
        this.nullAddressString = null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RegisterPanel.this.dataModel.fireTableDataChanged();
            }
        });
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.table != null) {
            this.table.setFont(font);
        }
    }

    static class RegisterInfo {
        private String name;
        private Address value;

        RegisterInfo(String name, Address value) {
            this.name = name;
            this.value = value;
        }

        String getName() {
            return this.name;
        }

        Address getValue() {
            return this.value;
        }
    }
}

