/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.attributes;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.IAttribute;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataProvider;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.ui.attributes.Messages;
import com.jrockit.mc.rjmx.ui.attributes.ReadOnlyMRIAttribute;
import com.jrockit.mc.ui.misc.DialogToolkit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class MRIAttribute
extends ReadOnlyMRIAttribute
implements IAttribute {
    protected MRIAttribute(IConnectionHandle handle, MRI mri) {
        super(handle, mri);
    }

    public void setValue(Object o) {
        try {
            this.getMBeanHelperService().setAttribute(this.getMRI(), o);
            this.updateValue(o);
        }
        catch (Exception e) {
            DialogToolkit.showExceptionDialogAsync((Display)Display.getDefault(), (String)NLS.bind((String)Messages.MRIAttribute_ERROR_SETTING_ATTRIBUTE_MSG, (Object)this.getMRI().getDataPath()), (Throwable)e);
        }
    }

    public static ReadOnlyMRIAttribute create(IConnectionHandle handle, MRI mri) {
        boolean editable;
        IMRIMetaData metaData = MRIMetaDataToolkit.getAttributeInfo((IConnectionHandle)handle, (MRI)mri);
        boolean bl = editable = metaData != null && MRIMetaDataToolkit.isWritable((IMRIMetaDataProvider)metaData);
        if (editable) {
            return new MRIAttribute(handle, mri);
        }
        return new ReadOnlyMRIAttribute(handle, mri);
    }
}

