/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.netbeans;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

public class PlatformDetailsProvider
extends DetailsProvider.Basic {
    private static final String STANDARD_MODULE = "org.netbeans.StandardModule+";
    private static final String STANDARD_MODULE_DATA = "org.netbeans.StandardModuleData";
    private static final String SPECIFICATION_VERSION = "org.openide.modules.SpecificationVersion";
    private static final String ABSTRACT_NODE = "org.openide.nodes.AbstractNode+";
    private static final String MULTI_FILE_ENTRY = "org.openide.loaders.MultiDataObject$Entry+";
    private static final String DATA_OBJECT = "org.openide.loaders.DataObject+";
    private static final String JAR_FILESYSTEM = "org.openide.filesystems.JarFileSystem+";
    private static final String FILE_OBJ = "org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObj+";
    private static final String FOLDER_OBJ = "org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj+";
    private static final String FILE_NAME = "org.netbeans.modules.masterfs.filebasedfs.naming.FileName+";
    private static final String FOLDER_NAME = "org.netbeans.modules.masterfs.filebasedfs.naming.FolderName+";
    private static final String ABSTRACT_FOLDER = "org.openide.filesystems.AbstractFolder+";
    private static final String BFS_BASE = "org.netbeans.core.startup.layers.BinaryFS$BFSBase+";
    private static final String FIXED_0_7 = "org.openide.util.CharSequences$Fixed_0_7";
    private static final String FIXED_8_15 = "org.openide.util.CharSequences$Fixed_8_15";
    private static final String FIXED_16_23 = "org.openide.util.CharSequences$Fixed_16_23";
    private static final String FIXED_1_10 = "org.openide.util.CharSequences$Fixed6Bit_1_10";
    private static final String FIXED_11_20 = "org.openide.util.CharSequences$Fixed6Bit_11_20";
    private static final String FIXED_21_30 = "org.openide.util.CharSequences$Fixed6Bit_21_30";
    private static final String BYTE_BASED_SEQUENCE = "org.openide.util.CharSequences$ByteBasedSequence";
    private static final String CHAR_BASED_SEQUENCE = "org.openide.util.CharSequences$CharBasedSequence";
    LinkedHashMap<Long, String> cache = new LinkedHashMap<Long, String>(10000){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, String> entry) {
            return this.size() > 10000;
        }
    };
    private static final long[] encodeTable = new long[]{-1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, 62L, -1L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L, 22L, 23L, 24L, 25L, 26L, 27L, 28L, 29L, 30L, 31L, 32L, 33L, 34L, 35L, -1L, -1L, -1L, -1L, 63L, -1L, 36L, 37L, 38L, 39L, 40L, 41L, 42L, 43L, 44L, 45L, 46L, 47L, 48L, 49L, 50L, 51L, 52L, 53L, 54L, 55L, 56L, 57L, 58L, 59L, 60L, 61L, -1L, -1L, -1L, -1L, -1L};
    private static final char[] decodeTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '.', '_'};
    private static final CompactCharSequence EMPTY = new Fixed_0_7(new byte[0], 0);
    private static final CharSequenceComparator Comparator = new CharSequenceComparator();

    public PlatformDetailsProvider() {
        super(STANDARD_MODULE, STANDARD_MODULE_DATA, SPECIFICATION_VERSION, ABSTRACT_NODE, MULTI_FILE_ENTRY, DATA_OBJECT, JAR_FILESYSTEM, FILE_OBJ, FOLDER_OBJ, FILE_NAME, FOLDER_NAME, ABSTRACT_FOLDER, BFS_BASE, FIXED_0_7, FIXED_8_15, FIXED_16_23, FIXED_1_10, FIXED_11_20, FIXED_21_30, BYTE_BASED_SEQUENCE, CHAR_BASED_SEQUENCE);
    }

    @Override
    public String getDetailsString(String string, Instance instance, Heap heap) {
        Long l = this.getUniqueInstanceId(heap, instance);
        String string2 = this.cache.get(l);
        if (string2 != null) {
            return string2;
        }
        string2 = this.getDetailsStringImpl(string, instance, heap);
        this.cache.put(l, string2);
        return string2;
    }

    private String getDetailsStringImpl(String string, Instance instance, Heap heap) {
        if (STANDARD_MODULE.equals(string)) {
            String string2 = DetailsUtils.getInstanceFieldString(instance, "codeName", heap);
            if (string2 != null) {
                return string2;
            }
            return DetailsUtils.getInstanceFieldString(instance, "data", heap);
        }
        if (SPECIFICATION_VERSION.equals(string)) {
            PrimitiveArrayInstance primitiveArrayInstance = (PrimitiveArrayInstance)instance.getValueOfField("digits");
            if (primitiveArrayInstance != null) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Object e : primitiveArrayInstance.getValues()) {
                    stringBuilder.append(e);
                    stringBuilder.append('.');
                }
                return stringBuilder.substring(0, stringBuilder.length() - 1);
            }
        } else {
            if (STANDARD_MODULE_DATA.equals(string)) {
                return DetailsUtils.getInstanceFieldString(instance, "codeName", heap);
            }
            if (ABSTRACT_NODE.equals(string)) {
                String string3 = DetailsUtils.getInstanceFieldString(instance, "displayName", heap);
                if (string3 == null) {
                    string3 = DetailsUtils.getInstanceFieldString(instance, "name", heap);
                }
                if (string3 == null || string3.length() == 0) {
                    string3 = DetailsUtils.getInstanceFieldString(instance, "shortDescription", heap);
                }
                return string3;
            }
            if (JAR_FILESYSTEM.equals(string)) {
                return DetailsUtils.getInstanceFieldString(instance, "foRoot", heap);
            }
            if (MULTI_FILE_ENTRY.equals(string)) {
                return DetailsUtils.getInstanceFieldString(instance, "file", heap);
            }
            if (DATA_OBJECT.equals(string)) {
                return DetailsUtils.getInstanceFieldString(instance, "primary", heap);
            }
            if (FILE_OBJ.equals(string)) {
                return DetailsUtils.getInstanceFieldString(instance, "fileName", heap);
            }
            if (FOLDER_OBJ.equals(string)) {
                return DetailsUtils.getInstanceFieldString(instance, "fileName", heap);
            }
            if (FILE_NAME.equals(string) || FOLDER_NAME.equals(string) || ABSTRACT_FOLDER.equals(string) || BFS_BASE.equals(string)) {
                String string4;
                String string5 = DetailsUtils.getInstanceFieldString(instance, "name", heap);
                if (string5 != null && (string4 = DetailsUtils.getInstanceFieldString(instance, "parent", heap)) != null) {
                    String string6;
                    if (FILE_NAME.equals(string) || FOLDER_NAME.equals(string)) {
                        string6 = this.getFileSeparator(heap);
                        if (string4.endsWith(string6)) {
                            string6 = "";
                        }
                    } else {
                        string6 = "/";
                    }
                    string5 = string4.concat(string6).concat(string5);
                }
                return string5;
            }
            if (FIXED_0_7.equals(string)) {
                Integer n = (Integer)instance.getValueOfField("i1");
                Integer n2 = (Integer)instance.getValueOfField("i2");
                if (n != null && n2 != null) {
                    return new Fixed_0_7(n, (int)n2).toString();
                }
            } else if (FIXED_8_15.equals(string)) {
                Integer n = (Integer)instance.getValueOfField("i1");
                Integer n3 = (Integer)instance.getValueOfField("i2");
                Integer n4 = (Integer)instance.getValueOfField("i3");
                Integer n5 = (Integer)instance.getValueOfField("i4");
                if (n != null && n3 != null && n4 != null && n5 != null) {
                    return new Fixed_8_15(n, n3, n4, n5).toString();
                }
            } else if (FIXED_16_23.equals(string)) {
                Long l = (Long)instance.getValueOfField("i1");
                Long l2 = (Long)instance.getValueOfField("i2");
                Long l3 = (Long)instance.getValueOfField("i3");
                if (l != null && l2 != null && l3 != null) {
                    return new Fixed_16_23(l, l2, l3).toString();
                }
            } else if (FIXED_1_10.equals(string)) {
                Long l = (Long)instance.getValueOfField("i");
                if (l != null) {
                    return new Fixed6Bit_1_10(l).toString();
                }
            } else if (FIXED_11_20.equals(string)) {
                Long l = (Long)instance.getValueOfField("i1");
                Long l4 = (Long)instance.getValueOfField("i2");
                if (l != null && l4 != null) {
                    return new Fixed6Bit_11_20(l, l4).toString();
                }
            } else if (FIXED_21_30.equals(string)) {
                Long l = (Long)instance.getValueOfField("i1");
                Long l5 = (Long)instance.getValueOfField("i2");
                Long l6 = (Long)instance.getValueOfField("i3");
                if (l != null && l5 != null && l6 != null) {
                    return new Fixed6Bit_21_30(l, l5, l6).toString();
                }
            } else if (BYTE_BASED_SEQUENCE.equals(string)) {
                Object object = instance.getValueOfField("value");
                if (object instanceof PrimitiveArrayInstance) {
                    PrimitiveArrayInstance primitiveArrayInstance = (PrimitiveArrayInstance)object;
                    byte[] byArray = new byte[primitiveArrayInstance.getLength()];
                    int n = 0;
                    for (Object e : primitiveArrayInstance.getValues()) {
                        byArray[n++] = Byte.valueOf((String)e);
                    }
                    return new String(byArray);
                }
            } else if (CHAR_BASED_SEQUENCE.equals(string)) {
                return DetailsUtils.getInstanceFieldString(instance, "value", heap);
            }
        }
        return null;
    }

    private Long getUniqueInstanceId(Heap heap, Instance instance) {
        long l = instance.getInstanceId() ^ (long)System.identityHashCode(heap);
        return new Long(l);
    }

    private String getFileSeparator(Heap heap) {
        Long l = new Long(System.identityHashCode(heap));
        String string = this.cache.get(l);
        if (string == null) {
            string = heap.getSystemProperties().getProperty("file.separator", "/");
            this.cache.put(l, string);
        }
        return string;
    }

    private static boolean is6BitChar(int n) {
        return n < 128 && encodeTable[n] >= 0L;
    }

    private static long encode6BitChar(int n) {
        return encodeTable[n];
    }

    private static char decode6BitChar(int n) {
        return decodeTable[n];
    }

    private static interface CompactCharSequence
    extends CharSequence {
    }

    private static class CharSequences {
        private static CharSequence create(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private static CharSequence create(char[] cArray, int n, int n2) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class CharSequenceComparator
    implements Comparator<CharSequence> {
        private CharSequenceComparator() {
        }

        @Override
        public int compare(CharSequence charSequence, CharSequence charSequence2) {
            if (charSequence instanceof ByteBasedSequence) {
                return CharSequenceComparator.compareByteBasedWithOther((ByteBasedSequence)charSequence, charSequence2);
            }
            if (charSequence2 instanceof ByteBasedSequence) {
                return -CharSequenceComparator.compareByteBasedWithOther((ByteBasedSequence)charSequence2, charSequence);
            }
            if (charSequence instanceof CharBasedSequence) {
                return CharSequenceComparator.compareCharBasedWithOther((CharBasedSequence)charSequence, charSequence2);
            }
            if (charSequence2 instanceof CharBasedSequence) {
                return -CharSequenceComparator.compareCharBasedWithOther((CharBasedSequence)charSequence2, charSequence);
            }
            int n = charSequence.length();
            int n2 = charSequence2.length();
            int n3 = Math.min(n, n2);
            for (int i = 0; i < n3; ++i) {
                char c;
                char c2 = charSequence.charAt(i);
                if (c2 == (c = charSequence2.charAt(i))) continue;
                return c2 - c;
            }
            return n - n2;
        }

        private static int compareByteBased(ByteBasedSequence byteBasedSequence, ByteBasedSequence byteBasedSequence2) {
            int n = byteBasedSequence.value.length;
            int n2 = byteBasedSequence2.value.length;
            int n3 = Math.min(n, n2);
            for (int i = 0; i < n3; ++i) {
                if (byteBasedSequence.value[i] == byteBasedSequence2.value[i]) continue;
                return (byteBasedSequence.value[i] & 0xFF) - (byteBasedSequence2.value[i] & 0xFF);
            }
            return n - n2;
        }

        private static int compareCharBased(CharBasedSequence charBasedSequence, CharBasedSequence charBasedSequence2) {
            int n = charBasedSequence.value.length;
            int n2 = charBasedSequence2.value.length;
            int n3 = Math.min(n, n2);
            for (int i = 0; i < n3; ++i) {
                if (charBasedSequence.value[i] == charBasedSequence2.value[i]) continue;
                return charBasedSequence.value[i] - charBasedSequence2.value[i];
            }
            return n - n2;
        }

        private static int compareByteBasedWithCharBased(ByteBasedSequence byteBasedSequence, CharBasedSequence charBasedSequence) {
            int n = byteBasedSequence.value.length;
            int n2 = charBasedSequence.value.length;
            int n3 = Math.min(n, n2);
            for (int i = 0; i < n3; ++i) {
                char c;
                int n4 = byteBasedSequence.value[i] & 0xFF;
                if (n4 == (c = charBasedSequence.value[i])) continue;
                return n4 - c;
            }
            return n - n2;
        }

        private static int compareByteBasedWithOther(ByteBasedSequence byteBasedSequence, CharSequence charSequence) {
            if (charSequence instanceof ByteBasedSequence) {
                return CharSequenceComparator.compareByteBased(byteBasedSequence, (ByteBasedSequence)charSequence);
            }
            if (charSequence instanceof CharBasedSequence) {
                return CharSequenceComparator.compareByteBasedWithCharBased(byteBasedSequence, (CharBasedSequence)charSequence);
            }
            int n = byteBasedSequence.value.length;
            int n2 = charSequence.length();
            int n3 = Math.min(n, n2);
            for (int i = 0; i < n3; ++i) {
                char c;
                int n4 = byteBasedSequence.value[i] & 0xFF;
                if (n4 == (c = charSequence.charAt(i))) continue;
                return n4 - c;
            }
            return n - n2;
        }

        private static int compareCharBasedWithOther(CharBasedSequence charBasedSequence, CharSequence charSequence) {
            if (charSequence instanceof CharBasedSequence) {
                return CharSequenceComparator.compareCharBased(charBasedSequence, (CharBasedSequence)charSequence);
            }
            if (charSequence instanceof ByteBasedSequence) {
                return -CharSequenceComparator.compareByteBasedWithCharBased((ByteBasedSequence)charSequence, charBasedSequence);
            }
            int n = charBasedSequence.value.length;
            int n2 = charSequence.length();
            int n3 = Math.min(n, n2);
            for (int i = 0; i < n3; ++i) {
                char c;
                char c2 = charBasedSequence.value[i];
                if (c2 == (c = charSequence.charAt(i))) continue;
                return c2 - c;
            }
            return n - n2;
        }
    }

    private static final class ByteBasedSequence
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final byte[] value;
        private int hash;

        private ByteBasedSequence(byte[] byArray) {
            this.value = byArray;
        }

        @Override
        public int length() {
            return this.value.length;
        }

        @Override
        public char charAt(int n) {
            int n2 = this.value[n] & 0xFF;
            return (char)n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof ByteBasedSequence) {
                ByteBasedSequence byteBasedSequence = (ByteBasedSequence)object;
                if (this.hash != 0 && byteBasedSequence.hash != 0 && this.hash != byteBasedSequence.hash) {
                    return false;
                }
                return Arrays.equals(this.value, byteBasedSequence.value);
            }
            return false;
        }

        public int hashCode() {
            int n = this.hash;
            if (n == 0) {
                int n2 = this.value.length;
                for (int i = 0; i < n2; ++i) {
                    n = 31 * n + this.value[i];
                }
                this.hash = n;
            }
            return n;
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return CharSequences.create(this.toChars(), n, n2 - n);
        }

        @Override
        public String toString() {
            char[] cArray = this.toChars();
            return new String(cArray);
        }

        private char[] toChars() {
            int n = this.value.length;
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                int n2 = this.value[i] & 0xFF;
                cArray[i] = (char)n2;
            }
            return cArray;
        }

        @Override
        public int compareTo(CharSequence charSequence) {
            return CharSequenceComparator.compareByteBasedWithOther(this, charSequence);
        }
    }

    private static final class CharBasedSequence
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final char[] value;
        private int hash;

        private CharBasedSequence(char[] cArray) {
            this.value = cArray;
        }

        @Override
        public int length() {
            return this.value.length;
        }

        @Override
        public char charAt(int n) {
            return this.value[n];
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof CharBasedSequence) {
                CharBasedSequence charBasedSequence = (CharBasedSequence)object;
                if (this.hash != 0 && charBasedSequence.hash != 0 && this.hash != charBasedSequence.hash) {
                    return false;
                }
                return Arrays.equals(this.value, charBasedSequence.value);
            }
            return false;
        }

        public int hashCode() {
            int n = this.hash;
            if (n == 0) {
                int n2 = this.value.length;
                for (int i = 0; i < n2; ++i) {
                    n = 31 * n + this.value[i];
                }
                this.hash = n;
            }
            return n;
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return CharSequences.create(this.value, n, n2 - n);
        }

        @Override
        public String toString() {
            return new String(this.value);
        }

        @Override
        public int compareTo(CharSequence charSequence) {
            return CharSequenceComparator.compareCharBasedWithOther(this, charSequence);
        }
    }

    private static final class Fixed_16_23
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final long i1;
        private final long i2;
        private final long i3;

        private Fixed_16_23(long l, long l2, long l3) {
            this.i1 = l;
            this.i2 = l2;
            this.i3 = l3;
        }

        private Fixed_16_23(byte[] byArray, int n) {
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            switch (n) {
                case 23: {
                    l3 += ((long)byArray[22] & 0xFFL) << 24;
                }
                case 22: {
                    l3 += (long)((byArray[21] & 0xFF) << 16);
                }
                case 21: {
                    l3 += (long)((byArray[20] & 0xFF) << 8);
                }
                case 20: {
                    l3 += (long)(byArray[19] & 0xFF);
                    l3 <<= 32;
                }
                case 19: {
                    l3 += ((long)byArray[18] & 0xFFL) << 24;
                }
                case 18: {
                    l3 += (long)((byArray[17] & 0xFF) << 16);
                }
                case 17: {
                    l3 += (long)((byArray[16] & 0xFF) << 8);
                }
                case 16: {
                    l3 += (long)(byArray[15] & 0xFF);
                }
                case 15: {
                    l2 += ((long)byArray[14] & 0xFFL) << 24;
                }
                case 14: {
                    l2 += (long)((byArray[13] & 0xFF) << 16);
                }
                case 13: {
                    l2 += (long)((byArray[12] & 0xFF) << 8);
                }
                case 12: {
                    l2 += (long)(byArray[11] & 0xFF);
                    l2 <<= 32;
                }
                case 11: {
                    l2 += ((long)byArray[10] & 0xFFL) << 24;
                }
                case 10: {
                    l2 += (long)((byArray[9] & 0xFF) << 16);
                }
                case 9: {
                    l2 += (long)((byArray[8] & 0xFF) << 8);
                }
                case 8: {
                    l2 += (long)(byArray[7] & 0xFF);
                }
                case 7: {
                    l += ((long)byArray[6] & 0xFFL) << 24;
                }
                case 6: {
                    l += (long)((byArray[5] & 0xFF) << 16);
                }
                case 5: {
                    l += (long)((byArray[4] & 0xFF) << 8);
                }
                case 4: {
                    l += (long)(byArray[3] & 0xFF);
                    l <<= 32;
                }
                case 3: {
                    l += ((long)byArray[2] & 0xFFL) << 24;
                }
                case 2: {
                    l += (long)((byArray[1] & 0xFF) << 16);
                }
                case 1: {
                    l += (long)((byArray[0] & 0xFF) << 8);
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.i1 = l += (long)n;
            this.i2 = l2;
            this.i3 = l3;
        }

        @Override
        public int length() {
            return (int)(this.i1 & 0xFFL);
        }

        @Override
        public char charAt(int n) {
            int n2 = 0;
            switch (n) {
                case 0: {
                    n2 = (int)(this.i1 >> 8 & 0xFFL);
                    break;
                }
                case 1: {
                    n2 = (int)(this.i1 >> 16 & 0xFFL);
                    break;
                }
                case 2: {
                    n2 = (int)(this.i1 >> 24 & 0xFFL);
                    break;
                }
                case 3: {
                    n2 = (int)(this.i1 >> 32 & 0xFFL);
                    break;
                }
                case 4: {
                    n2 = (int)(this.i1 >> 40 & 0xFFL);
                    break;
                }
                case 5: {
                    n2 = (int)(this.i1 >> 48 & 0xFFL);
                    break;
                }
                case 6: {
                    n2 = (int)(this.i1 >> 56 & 0xFFL);
                    break;
                }
                case 7: {
                    n2 = (int)(this.i2 & 0xFFL);
                    break;
                }
                case 8: {
                    n2 = (int)(this.i2 >> 8 & 0xFFL);
                    break;
                }
                case 9: {
                    n2 = (int)(this.i2 >> 16 & 0xFFL);
                    break;
                }
                case 10: {
                    n2 = (int)(this.i2 >> 24 & 0xFFL);
                    break;
                }
                case 11: {
                    n2 = (int)(this.i2 >> 32 & 0xFFL);
                    break;
                }
                case 12: {
                    n2 = (int)(this.i2 >> 40 & 0xFFL);
                    break;
                }
                case 13: {
                    n2 = (int)(this.i2 >> 48 & 0xFFL);
                    break;
                }
                case 14: {
                    n2 = (int)(this.i2 >> 56 & 0xFFL);
                    break;
                }
                case 15: {
                    n2 = (int)(this.i3 & 0xFFL);
                    break;
                }
                case 16: {
                    n2 = (int)(this.i3 >> 8 & 0xFFL);
                    break;
                }
                case 17: {
                    n2 = (int)(this.i3 >> 16 & 0xFFL);
                    break;
                }
                case 18: {
                    n2 = (int)(this.i3 >> 24 & 0xFFL);
                    break;
                }
                case 19: {
                    n2 = (int)(this.i3 >> 32 & 0xFFL);
                    break;
                }
                case 20: {
                    n2 = (int)(this.i3 >> 40 & 0xFFL);
                    break;
                }
                case 21: {
                    n2 = (int)(this.i3 >> 48 & 0xFFL);
                    break;
                }
                case 22: {
                    n2 = (int)(this.i3 >> 56 & 0xFFL);
                }
            }
            return (char)n2;
        }

        @Override
        public String toString() {
            int n = this.length();
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = this.charAt(i);
            }
            return new String(cArray);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Fixed_16_23) {
                Fixed_16_23 fixed_16_23 = (Fixed_16_23)object;
                return this.i1 == fixed_16_23.i1 && this.i2 == fixed_16_23.i2 && this.i3 == fixed_16_23.i3;
            }
            return false;
        }

        public int hashCode() {
            long l = this.i1 + 31L * (this.i2 + 31L * this.i3);
            l = l + (l >> 32) & 0xFFFFFFFFL;
            return (int)l;
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return CharSequences.create(this.toString().substring(n, n2));
        }

        @Override
        public int compareTo(CharSequence charSequence) {
            return Comparator.compare(this, charSequence);
        }
    }

    private static final class Fixed_8_15
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final int i1;
        private final int i2;
        private final int i3;
        private final int i4;

        private Fixed_8_15(int n, int n2, int n3, int n4) {
            this.i1 = n;
            this.i2 = n2;
            this.i3 = n3;
            this.i4 = n4;
        }

        private Fixed_8_15(byte[] byArray, int n) {
            int n2 = n;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            switch (n) {
                case 15: {
                    n5 += (byArray[14] & 0xFF) << 24;
                }
                case 14: {
                    n5 += (byArray[13] & 0xFF) << 16;
                }
                case 13: {
                    n5 += (byArray[12] & 0xFF) << 8;
                }
                case 12: {
                    n5 += byArray[11] & 0xFF;
                }
                case 11: {
                    n4 += (byArray[10] & 0xFF) << 24;
                }
                case 10: {
                    n4 += (byArray[9] & 0xFF) << 16;
                }
                case 9: {
                    n4 += (byArray[8] & 0xFF) << 8;
                }
                case 8: {
                    n4 += byArray[7] & 0xFF;
                }
                case 7: {
                    n3 += (byArray[6] & 0xFF) << 24;
                }
                case 6: {
                    n3 += (byArray[5] & 0xFF) << 16;
                }
                case 5: {
                    n3 += (byArray[4] & 0xFF) << 8;
                }
                case 4: {
                    n3 += byArray[3] & 0xFF;
                }
                case 3: {
                    n2 += (byArray[2] & 0xFF) << 24;
                }
                case 2: {
                    n2 += (byArray[1] & 0xFF) << 16;
                }
                case 1: {
                    n2 += (byArray[0] & 0xFF) << 8;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.i1 = n2;
            this.i2 = n3;
            this.i3 = n4;
            this.i4 = n5;
        }

        @Override
        public int length() {
            return this.i1 & 0xFF;
        }

        @Override
        public char charAt(int n) {
            int n2 = 0;
            switch (n) {
                case 0: {
                    n2 = (this.i1 & 0xFF00) >> 8;
                    break;
                }
                case 1: {
                    n2 = (this.i1 & 0xFF0000) >> 16;
                    break;
                }
                case 2: {
                    n2 = this.i1 >> 24 & 0xFF;
                    break;
                }
                case 3: {
                    n2 = this.i2 & 0xFF;
                    break;
                }
                case 4: {
                    n2 = (this.i2 & 0xFF00) >> 8;
                    break;
                }
                case 5: {
                    n2 = (this.i2 & 0xFF0000) >> 16;
                    break;
                }
                case 6: {
                    n2 = this.i2 >> 24 & 0xFF;
                    break;
                }
                case 7: {
                    n2 = this.i3 & 0xFF;
                    break;
                }
                case 8: {
                    n2 = (this.i3 & 0xFF00) >> 8;
                    break;
                }
                case 9: {
                    n2 = (this.i3 & 0xFF0000) >> 16;
                    break;
                }
                case 10: {
                    n2 = this.i3 >> 24 & 0xFF;
                    break;
                }
                case 11: {
                    n2 = this.i4 & 0xFF;
                    break;
                }
                case 12: {
                    n2 = (this.i4 & 0xFF00) >> 8;
                    break;
                }
                case 13: {
                    n2 = (this.i4 & 0xFF0000) >> 16;
                    break;
                }
                case 14: {
                    n2 = this.i4 >> 24 & 0xFF;
                }
            }
            return (char)n2;
        }

        @Override
        public String toString() {
            int n = this.length();
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = this.charAt(i);
            }
            return new String(cArray);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Fixed_8_15) {
                Fixed_8_15 fixed_8_15 = (Fixed_8_15)object;
                return this.i1 == fixed_8_15.i1 && this.i2 == fixed_8_15.i2 && this.i3 == fixed_8_15.i3 && this.i4 == fixed_8_15.i4;
            }
            return false;
        }

        public int hashCode() {
            return this.i1 + 31 * (this.i2 + 31 * (this.i3 + 31 * this.i4));
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return CharSequences.create(this.toString().substring(n, n2));
        }

        @Override
        public int compareTo(CharSequence charSequence) {
            return Comparator.compare(this, charSequence);
        }
    }

    private static final class Fixed6Bit_21_30
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final long i1;
        private final long i2;
        private final long i3;

        private Fixed6Bit_21_30(long l, long l2, long l3) {
            this.i1 = l;
            this.i2 = l2;
            this.i3 = l3;
        }

        private Fixed6Bit_21_30(byte[] byArray, int n) {
            long l = n & 0xF;
            long l2 = n >> 4 & 0xF;
            long l3 = 0L;
            switch (n) {
                case 30: {
                    l3 |= PlatformDetailsProvider.encode6BitChar(byArray[29]) << 58;
                }
                case 29: {
                    l3 |= PlatformDetailsProvider.encode6BitChar(byArray[28]) << 52;
                }
                case 28: {
                    l3 |= PlatformDetailsProvider.encode6BitChar(byArray[27]) << 46;
                }
                case 27: {
                    l3 |= PlatformDetailsProvider.encode6BitChar(byArray[26]) << 40;
                }
                case 26: {
                    l3 |= PlatformDetailsProvider.encode6BitChar(byArray[25]) << 34;
                }
                case 25: {
                    l3 |= PlatformDetailsProvider.encode6BitChar(byArray[24]) << 28;
                }
                case 24: {
                    l3 |= PlatformDetailsProvider.encode6BitChar(byArray[23]) << 22;
                }
                case 23: {
                    l3 |= PlatformDetailsProvider.encode6BitChar(byArray[22]) << 16;
                }
                case 22: {
                    l3 |= PlatformDetailsProvider.encode6BitChar(byArray[21]) << 10;
                }
                case 21: {
                    l3 |= PlatformDetailsProvider.encode6BitChar(byArray[20]) << 4;
                }
                case 20: {
                    l2 |= PlatformDetailsProvider.encode6BitChar(byArray[19]) << 58;
                }
                case 19: {
                    l2 |= PlatformDetailsProvider.encode6BitChar(byArray[18]) << 52;
                }
                case 18: {
                    l2 |= PlatformDetailsProvider.encode6BitChar(byArray[17]) << 46;
                }
                case 17: {
                    l2 |= PlatformDetailsProvider.encode6BitChar(byArray[16]) << 40;
                }
                case 16: {
                    l2 |= PlatformDetailsProvider.encode6BitChar(byArray[15]) << 34;
                }
                case 15: {
                    l2 |= PlatformDetailsProvider.encode6BitChar(byArray[14]) << 28;
                }
                case 14: {
                    l2 |= PlatformDetailsProvider.encode6BitChar(byArray[13]) << 22;
                }
                case 13: {
                    l2 |= PlatformDetailsProvider.encode6BitChar(byArray[12]) << 16;
                }
                case 12: {
                    l2 |= PlatformDetailsProvider.encode6BitChar(byArray[11]) << 10;
                }
                case 11: {
                    l2 |= PlatformDetailsProvider.encode6BitChar(byArray[10]) << 4;
                }
                case 10: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[9]) << 58;
                }
                case 9: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[8]) << 52;
                }
                case 8: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[7]) << 46;
                }
                case 7: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[6]) << 40;
                }
                case 6: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[5]) << 34;
                }
                case 5: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[4]) << 28;
                }
                case 4: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[3]) << 22;
                }
                case 3: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[2]) << 16;
                }
                case 2: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[1]) << 10;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.i1 = l |= PlatformDetailsProvider.encode6BitChar(byArray[0]) << 4;
            this.i2 = l2;
            this.i3 = l3;
        }

        @Override
        public int length() {
            return (int)((this.i1 & 0xFL) + ((this.i2 & 0xFL) << 4));
        }

        @Override
        public char charAt(int n) {
            int n2 = 0;
            switch (n) {
                case 0: {
                    n2 = (int)(this.i1 >> 4 & 0x3FL);
                    break;
                }
                case 1: {
                    n2 = (int)(this.i1 >> 10 & 0x3FL);
                    break;
                }
                case 2: {
                    n2 = (int)(this.i1 >> 16 & 0x3FL);
                    break;
                }
                case 3: {
                    n2 = (int)(this.i1 >> 22 & 0x3FL);
                    break;
                }
                case 4: {
                    n2 = (int)(this.i1 >> 28 & 0x3FL);
                    break;
                }
                case 5: {
                    n2 = (int)(this.i1 >> 34 & 0x3FL);
                    break;
                }
                case 6: {
                    n2 = (int)(this.i1 >> 40 & 0x3FL);
                    break;
                }
                case 7: {
                    n2 = (int)(this.i1 >> 46 & 0x3FL);
                    break;
                }
                case 8: {
                    n2 = (int)(this.i1 >> 52 & 0x3FL);
                    break;
                }
                case 9: {
                    n2 = (int)(this.i1 >> 58 & 0x3FL);
                    break;
                }
                case 10: {
                    n2 = (int)(this.i2 >> 4 & 0x3FL);
                    break;
                }
                case 11: {
                    n2 = (int)(this.i2 >> 10 & 0x3FL);
                    break;
                }
                case 12: {
                    n2 = (int)(this.i2 >> 16 & 0x3FL);
                    break;
                }
                case 13: {
                    n2 = (int)(this.i2 >> 22 & 0x3FL);
                    break;
                }
                case 14: {
                    n2 = (int)(this.i2 >> 28 & 0x3FL);
                    break;
                }
                case 15: {
                    n2 = (int)(this.i2 >> 34 & 0x3FL);
                    break;
                }
                case 16: {
                    n2 = (int)(this.i2 >> 40 & 0x3FL);
                    break;
                }
                case 17: {
                    n2 = (int)(this.i2 >> 46 & 0x3FL);
                    break;
                }
                case 18: {
                    n2 = (int)(this.i2 >> 52 & 0x3FL);
                    break;
                }
                case 19: {
                    n2 = (int)(this.i2 >> 58 & 0x3FL);
                    break;
                }
                case 20: {
                    n2 = (int)(this.i3 >> 4 & 0x3FL);
                    break;
                }
                case 21: {
                    n2 = (int)(this.i3 >> 10 & 0x3FL);
                    break;
                }
                case 22: {
                    n2 = (int)(this.i3 >> 16 & 0x3FL);
                    break;
                }
                case 23: {
                    n2 = (int)(this.i3 >> 22 & 0x3FL);
                    break;
                }
                case 24: {
                    n2 = (int)(this.i3 >> 28 & 0x3FL);
                    break;
                }
                case 25: {
                    n2 = (int)(this.i3 >> 34 & 0x3FL);
                    break;
                }
                case 26: {
                    n2 = (int)(this.i3 >> 40 & 0x3FL);
                    break;
                }
                case 27: {
                    n2 = (int)(this.i3 >> 46 & 0x3FL);
                    break;
                }
                case 28: {
                    n2 = (int)(this.i3 >> 52 & 0x3FL);
                    break;
                }
                case 29: {
                    n2 = (int)(this.i3 >> 58 & 0x3FL);
                }
            }
            return PlatformDetailsProvider.decode6BitChar(n2);
        }

        @Override
        public String toString() {
            int n = this.length();
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = this.charAt(i);
            }
            return new String(cArray);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Fixed6Bit_21_30) {
                Fixed6Bit_21_30 fixed6Bit_21_30 = (Fixed6Bit_21_30)object;
                return this.i1 == fixed6Bit_21_30.i1 && this.i2 == fixed6Bit_21_30.i2 && this.i3 == fixed6Bit_21_30.i3;
            }
            return false;
        }

        public int hashCode() {
            long l = this.i1 + 31L * (this.i2 + this.i3 * 31L);
            l = l + (l >> 32) & 0xFFFFFFFFL;
            return (int)l;
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return CharSequences.create(this.toString().substring(n, n2));
        }

        @Override
        public int compareTo(CharSequence charSequence) {
            return Comparator.compare(this, charSequence);
        }
    }

    private static final class Fixed6Bit_11_20
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final long i1;
        private final long i2;

        private Fixed6Bit_11_20(long l, long l2) {
            this.i1 = l;
            this.i2 = l2;
        }

        private Fixed6Bit_11_20(byte[] byArray, int n) {
            long l = n & 0xF;
            long l2 = n >> 4 & 0xF;
            switch (n) {
                case 20: {
                    l2 |= PlatformDetailsProvider.encode6BitChar(byArray[19]) << 58;
                }
                case 19: {
                    l2 |= PlatformDetailsProvider.encode6BitChar(byArray[18]) << 52;
                }
                case 18: {
                    l2 |= PlatformDetailsProvider.encode6BitChar(byArray[17]) << 46;
                }
                case 17: {
                    l2 |= PlatformDetailsProvider.encode6BitChar(byArray[16]) << 40;
                }
                case 16: {
                    l2 |= PlatformDetailsProvider.encode6BitChar(byArray[15]) << 34;
                }
                case 15: {
                    l2 |= PlatformDetailsProvider.encode6BitChar(byArray[14]) << 28;
                }
                case 14: {
                    l2 |= PlatformDetailsProvider.encode6BitChar(byArray[13]) << 22;
                }
                case 13: {
                    l2 |= PlatformDetailsProvider.encode6BitChar(byArray[12]) << 16;
                }
                case 12: {
                    l2 |= PlatformDetailsProvider.encode6BitChar(byArray[11]) << 10;
                }
                case 11: {
                    l2 |= PlatformDetailsProvider.encode6BitChar(byArray[10]) << 4;
                }
                case 10: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[9]) << 58;
                }
                case 9: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[8]) << 52;
                }
                case 8: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[7]) << 46;
                }
                case 7: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[6]) << 40;
                }
                case 6: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[5]) << 34;
                }
                case 5: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[4]) << 28;
                }
                case 4: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[3]) << 22;
                }
                case 3: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[2]) << 16;
                }
                case 2: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[1]) << 10;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.i1 = l |= PlatformDetailsProvider.encode6BitChar(byArray[0]) << 4;
            this.i2 = l2;
        }

        @Override
        public int length() {
            return (int)((this.i1 & 0xFL) + ((this.i2 & 0xFL) << 4));
        }

        @Override
        public char charAt(int n) {
            int n2 = 0;
            switch (n) {
                case 0: {
                    n2 = (int)(this.i1 >> 4 & 0x3FL);
                    break;
                }
                case 1: {
                    n2 = (int)(this.i1 >> 10 & 0x3FL);
                    break;
                }
                case 2: {
                    n2 = (int)(this.i1 >> 16 & 0x3FL);
                    break;
                }
                case 3: {
                    n2 = (int)(this.i1 >> 22 & 0x3FL);
                    break;
                }
                case 4: {
                    n2 = (int)(this.i1 >> 28 & 0x3FL);
                    break;
                }
                case 5: {
                    n2 = (int)(this.i1 >> 34 & 0x3FL);
                    break;
                }
                case 6: {
                    n2 = (int)(this.i1 >> 40 & 0x3FL);
                    break;
                }
                case 7: {
                    n2 = (int)(this.i1 >> 46 & 0x3FL);
                    break;
                }
                case 8: {
                    n2 = (int)(this.i1 >> 52 & 0x3FL);
                    break;
                }
                case 9: {
                    n2 = (int)(this.i1 >> 58 & 0x3FL);
                    break;
                }
                case 10: {
                    n2 = (int)(this.i2 >> 4 & 0x3FL);
                    break;
                }
                case 11: {
                    n2 = (int)(this.i2 >> 10 & 0x3FL);
                    break;
                }
                case 12: {
                    n2 = (int)(this.i2 >> 16 & 0x3FL);
                    break;
                }
                case 13: {
                    n2 = (int)(this.i2 >> 22 & 0x3FL);
                    break;
                }
                case 14: {
                    n2 = (int)(this.i2 >> 28 & 0x3FL);
                    break;
                }
                case 15: {
                    n2 = (int)(this.i2 >> 34 & 0x3FL);
                    break;
                }
                case 16: {
                    n2 = (int)(this.i2 >> 40 & 0x3FL);
                    break;
                }
                case 17: {
                    n2 = (int)(this.i2 >> 46 & 0x3FL);
                    break;
                }
                case 18: {
                    n2 = (int)(this.i2 >> 52 & 0x3FL);
                    break;
                }
                case 19: {
                    n2 = (int)(this.i2 >> 58 & 0x3FL);
                }
            }
            return PlatformDetailsProvider.decode6BitChar(n2);
        }

        @Override
        public String toString() {
            int n = this.length();
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = this.charAt(i);
            }
            return new String(cArray);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Fixed6Bit_11_20) {
                Fixed6Bit_11_20 fixed6Bit_11_20 = (Fixed6Bit_11_20)object;
                return this.i1 == fixed6Bit_11_20.i1 && this.i2 == fixed6Bit_11_20.i2;
            }
            return false;
        }

        public int hashCode() {
            long l = this.i1 + 31L * this.i2;
            l = l + (l >> 32) & 0xFFFFFFFFL;
            return (int)l;
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return CharSequences.create(this.toString().substring(n, n2));
        }

        @Override
        public int compareTo(CharSequence charSequence) {
            return Comparator.compare(this, charSequence);
        }
    }

    private static final class Fixed6Bit_1_10
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final long i;

        private Fixed6Bit_1_10(long l) {
            this.i = l;
        }

        private Fixed6Bit_1_10(byte[] byArray, int n) {
            long l = n;
            switch (n) {
                case 10: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[9]) << 58;
                }
                case 9: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[8]) << 52;
                }
                case 8: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[7]) << 46;
                }
                case 7: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[6]) << 40;
                }
                case 6: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[5]) << 34;
                }
                case 5: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[4]) << 28;
                }
                case 4: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[3]) << 22;
                }
                case 3: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[2]) << 16;
                }
                case 2: {
                    l |= PlatformDetailsProvider.encode6BitChar(byArray[1]) << 10;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.i = l |= PlatformDetailsProvider.encode6BitChar(byArray[0]) << 4;
        }

        @Override
        public int length() {
            return (int)(this.i & 0xFL);
        }

        @Override
        public char charAt(int n) {
            int n2 = 0;
            switch (n) {
                case 0: {
                    n2 = (int)(this.i >> 4 & 0x3FL);
                    break;
                }
                case 1: {
                    n2 = (int)(this.i >> 10 & 0x3FL);
                    break;
                }
                case 2: {
                    n2 = (int)(this.i >> 16 & 0x3FL);
                    break;
                }
                case 3: {
                    n2 = (int)(this.i >> 22 & 0x3FL);
                    break;
                }
                case 4: {
                    n2 = (int)(this.i >> 28 & 0x3FL);
                    break;
                }
                case 5: {
                    n2 = (int)(this.i >> 34 & 0x3FL);
                    break;
                }
                case 6: {
                    n2 = (int)(this.i >> 40 & 0x3FL);
                    break;
                }
                case 7: {
                    n2 = (int)(this.i >> 46 & 0x3FL);
                    break;
                }
                case 8: {
                    n2 = (int)(this.i >> 52 & 0x3FL);
                    break;
                }
                case 9: {
                    n2 = (int)(this.i >> 58 & 0x3FL);
                }
            }
            return PlatformDetailsProvider.decode6BitChar(n2);
        }

        @Override
        public String toString() {
            int n = this.length();
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = this.charAt(i);
            }
            return new String(cArray);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Fixed6Bit_1_10) {
                Fixed6Bit_1_10 fixed6Bit_1_10 = (Fixed6Bit_1_10)object;
                return this.i == fixed6Bit_1_10.i;
            }
            return false;
        }

        public int hashCode() {
            int n = 0;
            for (int i = 0; i < this.length(); ++i) {
                n = 31 * n + this.charAt(i);
            }
            return n;
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return CharSequences.create(this.toString().substring(n, n2));
        }

        @Override
        public int compareTo(CharSequence charSequence) {
            return Comparator.compare(this, charSequence);
        }
    }

    private static final class Fixed_0_7
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final int i1;
        private final int i2;

        private Fixed_0_7(int n, int n2) {
            this.i1 = n;
            this.i2 = n2;
        }

        private Fixed_0_7(byte[] byArray, int n) {
            int n2 = n;
            int n3 = 0;
            switch (n) {
                case 7: {
                    n3 += (byArray[6] & 0xFF) << 24;
                }
                case 6: {
                    n3 += (byArray[5] & 0xFF) << 16;
                }
                case 5: {
                    n3 += (byArray[4] & 0xFF) << 8;
                }
                case 4: {
                    n3 += byArray[3] & 0xFF;
                }
                case 3: {
                    n2 += (byArray[2] & 0xFF) << 24;
                }
                case 2: {
                    n2 += (byArray[1] & 0xFF) << 16;
                }
                case 1: {
                    n2 += (byArray[0] & 0xFF) << 8;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.i1 = n2;
            this.i2 = n3;
        }

        @Override
        public int length() {
            return this.i1 & 0xFF;
        }

        @Override
        public char charAt(int n) {
            int n2 = 0;
            switch (n) {
                case 0: {
                    n2 = (this.i1 & 0xFF00) >> 8;
                    break;
                }
                case 1: {
                    n2 = (this.i1 & 0xFF0000) >> 16;
                    break;
                }
                case 2: {
                    n2 = this.i1 >> 24 & 0xFF;
                    break;
                }
                case 3: {
                    n2 = this.i2 & 0xFF;
                    break;
                }
                case 4: {
                    n2 = (this.i2 & 0xFF00) >> 8;
                    break;
                }
                case 5: {
                    n2 = (this.i2 & 0xFF0000) >> 16;
                    break;
                }
                case 6: {
                    n2 = this.i2 >> 24 & 0xFF;
                }
            }
            return (char)n2;
        }

        @Override
        public String toString() {
            int n = this.length();
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = this.charAt(i);
            }
            return new String(cArray);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Fixed_0_7) {
                Fixed_0_7 fixed_0_7 = (Fixed_0_7)object;
                return this.i1 == fixed_0_7.i1 && this.i2 == fixed_0_7.i2;
            }
            return false;
        }

        public int hashCode() {
            int n = 0;
            for (int i = 0; i < this.length(); ++i) {
                n = 31 * n + this.charAt(i);
            }
            return n;
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return CharSequences.create(this.toString().substring(n, n2));
        }

        @Override
        public int compareTo(CharSequence charSequence) {
            return Comparator.compare(this, charSequence);
        }
    }
}

