/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.access;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.KeyHasher;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLInteger;

public class DiskHashtable {
    private final long rowConglomerateId;
    private ConglomerateController rowConglomerate;
    private final long btreeConglomerateId;
    private ConglomerateController btreeConglomerate;
    private final DataValueDescriptor[] btreeRow;
    private final int[] key_column_numbers;
    private final boolean remove_duplicates;
    private final TransactionController tc;
    private final DataValueDescriptor[] row;
    private final DataValueDescriptor[] scanKey = new DataValueDescriptor[]{new SQLInteger()};
    private int size;
    private boolean keepStatistics;
    private final boolean keepAfterCommit;

    public DiskHashtable(TransactionController transactionController, DataValueDescriptor[] dataValueDescriptorArray, int[] nArray, int[] nArray2, boolean bl, boolean bl2) throws StandardException {
        int n;
        this.tc = transactionController;
        this.key_column_numbers = nArray2;
        this.remove_duplicates = bl;
        this.keepAfterCommit = bl2;
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)ContextService.getContextOrNull("LanguageConnectionContext");
        this.keepStatistics = languageConnectionContext != null && languageConnectionContext.getRunTimeStatisticsMode();
        this.row = new DataValueDescriptor[dataValueDescriptorArray.length];
        for (n = 0; n < this.row.length; ++n) {
            this.row[n] = dataValueDescriptorArray[n].getNewNull();
        }
        n = bl2 ? 3 : 1;
        this.rowConglomerateId = transactionController.createConglomerate("heap", dataValueDescriptorArray, null, nArray, null, n);
        this.rowConglomerate = transactionController.openConglomerate(this.rowConglomerateId, bl2, 4, 7, 0);
        this.btreeRow = new DataValueDescriptor[]{new SQLInteger(), this.rowConglomerate.newRowLocationTemplate()};
        Properties properties = new Properties();
        properties.put("baseConglomerateId", String.valueOf(this.rowConglomerateId));
        properties.put("rowLocationColumn", "1");
        properties.put("allowDuplicates", "false");
        properties.put("nKeyFields", "2");
        properties.put("nUniqueColumns", "2");
        properties.put("maintainParentLinks", "false");
        int[] nArray3 = new int[]{0, 0};
        this.btreeConglomerateId = transactionController.createConglomerate("BTREE", this.btreeRow, null, nArray3, properties, n);
        this.btreeConglomerate = transactionController.openConglomerate(this.btreeConglomerateId, bl2, 4, 7, 0);
    }

    public void close() throws StandardException {
        this.btreeConglomerate.close();
        this.rowConglomerate.close();
        this.tc.dropConglomerate(this.btreeConglomerateId);
        this.tc.dropConglomerate(this.rowConglomerateId);
    }

    public boolean put(Object object, Object[] objectArray) throws StandardException {
        boolean bl = false;
        if (this.remove_duplicates || this.keepStatistics) {
            boolean bl2 = bl = this.getRemove(object, false, true) != null;
            if (this.remove_duplicates && bl) {
                return false;
            }
        }
        this.rowConglomerate.insertAndFetchLocation((DataValueDescriptor[])objectArray, (RowLocation)this.btreeRow[1]);
        this.btreeRow[0].setValue(object.hashCode());
        this.btreeConglomerate.insert(this.btreeRow);
        if (this.keepStatistics && !bl) {
            ++this.size;
        }
        return true;
    }

    public Object get(Object object) throws StandardException {
        return this.getRemove(object, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getRemove(Object object, boolean bl, boolean bl2) throws StandardException {
        int n = object.hashCode();
        int n2 = 0;
        DataValueDescriptor[] dataValueDescriptorArray = null;
        this.scanKey[0].setValue(n);
        ScanController scanController = this.tc.openScan(this.btreeConglomerateId, false, bl ? 4 : 0, 7, 1, null, this.scanKey, 1, null, this.scanKey, -1);
        try {
            while (scanController.fetchNext(this.btreeRow)) {
                DataValueDescriptor[] dataValueDescriptorArray2;
                if (!this.rowConglomerate.fetch((RowLocation)this.btreeRow[1], this.row, null) || !this.rowMatches(this.row, object)) continue;
                if (bl2) {
                    dataValueDescriptorArray2 = this;
                    return dataValueDescriptorArray2;
                }
                if (++n2 == 1) {
                    dataValueDescriptorArray = BackingStoreHashtable.shallowCloneRow(this.row);
                } else {
                    if (n2 == 2) {
                        dataValueDescriptorArray2 = new Vector(2);
                        dataValueDescriptorArray2.add(dataValueDescriptorArray);
                        dataValueDescriptorArray = dataValueDescriptorArray2;
                    } else {
                        dataValueDescriptorArray2 = (Vector)dataValueDescriptorArray;
                    }
                    dataValueDescriptorArray2.add(BackingStoreHashtable.shallowCloneRow(this.row));
                }
                if (bl) {
                    this.rowConglomerate.delete((RowLocation)this.btreeRow[1]);
                    scanController.delete();
                    --this.size;
                }
                if (!this.remove_duplicates) continue;
                dataValueDescriptorArray2 = dataValueDescriptorArray;
                return dataValueDescriptorArray2;
            }
        }
        finally {
            scanController.close();
        }
        return dataValueDescriptorArray;
    }

    private boolean rowMatches(DataValueDescriptor[] dataValueDescriptorArray, Object object) {
        if (this.key_column_numbers.length == 1) {
            return dataValueDescriptorArray[this.key_column_numbers[0]].equals(object);
        }
        KeyHasher keyHasher = (KeyHasher)object;
        for (int i = 0; i < this.key_column_numbers.length; ++i) {
            if (dataValueDescriptorArray[this.key_column_numbers[i]].equals(keyHasher.getObject(i))) continue;
            return false;
        }
        return true;
    }

    public Object remove(Object object) throws StandardException {
        return this.getRemove(object, true, false);
    }

    public int size() {
        return this.size;
    }

    public Enumeration elements() throws StandardException {
        return new ElementEnum();
    }

    private class ElementEnum
    implements Enumeration {
        private ScanController scan;
        private boolean hasMore;
        private RowLocation rowloc;

        ElementEnum() {
            block7: {
                try {
                    this.scan = DiskHashtable.this.tc.openScan(DiskHashtable.this.rowConglomerateId, DiskHashtable.this.keepAfterCommit, 0, 7, 0, null, null, 0, null, null, 0);
                    this.hasMore = this.scan.next();
                    if (!this.hasMore) {
                        this.scan.close();
                        this.scan = null;
                    } else if (DiskHashtable.this.keepAfterCommit) {
                        this.rowloc = DiskHashtable.this.rowConglomerate.newRowLocationTemplate();
                        this.scan.fetchLocation(this.rowloc);
                    }
                }
                catch (StandardException standardException) {
                    this.hasMore = false;
                    if (this.scan == null) break block7;
                    try {
                        this.scan.close();
                    }
                    catch (StandardException standardException2) {
                        // empty catch block
                    }
                    this.scan = null;
                }
            }
        }

        public boolean hasMoreElements() {
            return this.hasMore;
        }

        public Object nextElement() {
            if (!this.hasMore) {
                throw new NoSuchElementException();
            }
            try {
                if (this.scan.isHeldAfterCommit() && !this.scan.positionAtRowLocation(this.rowloc)) {
                    throw StandardException.newException("24000");
                }
                this.scan.fetch(DiskHashtable.this.row);
                DataValueDescriptor[] dataValueDescriptorArray = BackingStoreHashtable.shallowCloneRow(DiskHashtable.this.row);
                this.hasMore = this.scan.next();
                if (!this.hasMore) {
                    this.scan.close();
                    this.scan = null;
                } else if (DiskHashtable.this.keepAfterCommit) {
                    this.scan.fetchLocation(this.rowloc);
                }
                return dataValueDescriptorArray;
            }
            catch (StandardException standardException) {
                if (this.scan != null) {
                    try {
                        this.scan.close();
                    }
                    catch (StandardException standardException2) {
                        // empty catch block
                    }
                    this.scan = null;
                }
                throw new NoSuchElementException();
            }
        }
    }
}

