/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.StringTokenizer;
import javax.security.auth.kerberos.KrbDelegationPermissionCollection;

public final class DelegationPermission
extends BasicPermission
implements Serializable {
    private static final long serialVersionUID = 883133252142523922L;
    private transient String subordinate;
    private transient String service;

    public DelegationPermission(String string) {
        super(string);
        this.init(string);
    }

    public DelegationPermission(String string, String string2) {
        super(string, string2);
        this.init(string);
    }

    private void init(String string) {
        StringTokenizer stringTokenizer = null;
        if (!string.startsWith("\"")) {
            throw new IllegalArgumentException("service principal [" + string + "] syntax invalid: " + "improperly quoted");
        }
        stringTokenizer = new StringTokenizer(string, "\"", false);
        this.subordinate = stringTokenizer.nextToken();
        if (stringTokenizer.countTokens() == 2) {
            stringTokenizer.nextToken();
            this.service = stringTokenizer.nextToken();
        } else if (stringTokenizer.countTokens() > 0) {
            throw new IllegalArgumentException("service principal [" + stringTokenizer.nextToken() + "] syntax invalid: " + "improperly quoted");
        }
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof DelegationPermission)) {
            return false;
        }
        DelegationPermission delegationPermission = (DelegationPermission)permission;
        return this.subordinate.equals(delegationPermission.subordinate) && this.service.equals(delegationPermission.service);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DelegationPermission)) {
            return false;
        }
        DelegationPermission delegationPermission = (DelegationPermission)object;
        return this.implies(delegationPermission);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public PermissionCollection newPermissionCollection() {
        return new KrbDelegationPermissionCollection();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(this.getName());
    }
}

