/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SoftAudioBuffer;
import com.sun.media.sound.SoftAudioProcessor;
import java.util.Arrays;

public class SoftReverb
implements SoftAudioProcessor {
    private float roomsize;
    private float damp;
    private float gain = 1.0f;
    private Delay delay;
    private Comb[] combL;
    private Comb[] combR;
    private AllPass[] allpassL;
    private AllPass[] allpassR;
    private float[] input;
    private float[] out;
    private float[] pre1;
    private float[] pre2;
    private float[] pre3;
    private boolean denormal_flip = false;
    private boolean mix = true;
    private SoftAudioBuffer inputA;
    private SoftAudioBuffer left;
    private SoftAudioBuffer right;
    private boolean dirty = true;
    private float dirty_roomsize;
    private float dirty_damp;
    private float dirty_predelay;
    private float dirty_gain;
    private float samplerate;
    private boolean light = true;
    private boolean silent = true;

    public void init(float f, float f2) {
        this.samplerate = f;
        double d = (double)f / 44100.0;
        int n = 23;
        this.delay = new Delay();
        this.combL = new Comb[8];
        this.combR = new Comb[8];
        this.combL[0] = new Comb((int)(d * 1116.0));
        this.combR[0] = new Comb((int)(d * (double)(1116 + n)));
        this.combL[1] = new Comb((int)(d * 1188.0));
        this.combR[1] = new Comb((int)(d * (double)(1188 + n)));
        this.combL[2] = new Comb((int)(d * 1277.0));
        this.combR[2] = new Comb((int)(d * (double)(1277 + n)));
        this.combL[3] = new Comb((int)(d * 1356.0));
        this.combR[3] = new Comb((int)(d * (double)(1356 + n)));
        this.combL[4] = new Comb((int)(d * 1422.0));
        this.combR[4] = new Comb((int)(d * (double)(1422 + n)));
        this.combL[5] = new Comb((int)(d * 1491.0));
        this.combR[5] = new Comb((int)(d * (double)(1491 + n)));
        this.combL[6] = new Comb((int)(d * 1557.0));
        this.combR[6] = new Comb((int)(d * (double)(1557 + n)));
        this.combL[7] = new Comb((int)(d * 1617.0));
        this.combR[7] = new Comb((int)(d * (double)(1617 + n)));
        this.allpassL = new AllPass[4];
        this.allpassR = new AllPass[4];
        this.allpassL[0] = new AllPass((int)(d * 556.0));
        this.allpassR[0] = new AllPass((int)(d * (double)(556 + n)));
        this.allpassL[1] = new AllPass((int)(d * 441.0));
        this.allpassR[1] = new AllPass((int)(d * (double)(441 + n)));
        this.allpassL[2] = new AllPass((int)(d * 341.0));
        this.allpassR[2] = new AllPass((int)(d * (double)(341 + n)));
        this.allpassL[3] = new AllPass((int)(d * 225.0));
        this.allpassR[3] = new AllPass((int)(d * (double)(225 + n)));
        for (int i = 0; i < this.allpassL.length; ++i) {
            this.allpassL[i].setFeedBack(0.5f);
            this.allpassR[i].setFeedBack(0.5f);
        }
        this.globalParameterControlChange(new int[]{129}, 0L, 4L);
    }

    public void setInput(int n, SoftAudioBuffer softAudioBuffer) {
        if (n == 0) {
            this.inputA = softAudioBuffer;
        }
    }

    public void setOutput(int n, SoftAudioBuffer softAudioBuffer) {
        if (n == 0) {
            this.left = softAudioBuffer;
        }
        if (n == 1) {
            this.right = softAudioBuffer;
        }
    }

    public void setMixMode(boolean bl) {
        this.mix = bl;
    }

    public void processAudio() {
        float f;
        int n;
        boolean bl = this.inputA.isSilent();
        if (!bl) {
            this.silent = false;
        }
        if (this.silent) {
            if (!this.mix) {
                this.left.clear();
                this.right.clear();
            }
            return;
        }
        float[] fArray = this.inputA.array();
        float[] fArray2 = this.left.array();
        float[] fArray3 = this.right == null ? null : this.right.array();
        int n2 = fArray.length;
        if (this.input == null || this.input.length < n2) {
            this.input = new float[n2];
        }
        float f2 = this.gain * 0.018f / 2.0f;
        boolean bl2 = this.denormal_flip = !this.denormal_flip;
        if (this.denormal_flip) {
            for (n = 0; n < n2; ++n) {
                this.input[n] = fArray[n] * f2 + 1.0E-20f;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                this.input[n] = fArray[n] * f2 - 1.0E-20f;
            }
        }
        this.delay.processReplace(this.input);
        if (this.light && fArray3 != null) {
            if (this.pre1 == null || this.pre1.length < n2) {
                this.pre1 = new float[n2];
                this.pre2 = new float[n2];
                this.pre3 = new float[n2];
            }
            for (n = 0; n < this.allpassL.length; ++n) {
                this.allpassL[n].processReplace(this.input);
            }
            this.combL[0].processReplace(this.input, this.pre3);
            this.combL[1].processReplace(this.input, this.pre3);
            this.combL[2].processReplace(this.input, this.pre1);
            for (n = 4; n < this.combL.length - 2; n += 2) {
                this.combL[n].processMix(this.input, this.pre1);
            }
            this.combL[3].processReplace(this.input, this.pre2);
            for (n = 5; n < this.combL.length - 2; n += 2) {
                this.combL[n].processMix(this.input, this.pre2);
            }
            if (!this.mix) {
                Arrays.fill(fArray3, 0.0f);
                Arrays.fill(fArray2, 0.0f);
            }
            for (n = this.combR.length - 2; n < this.combR.length; ++n) {
                this.combR[n].processMix(this.input, fArray3);
            }
            for (n = this.combL.length - 2; n < this.combL.length; ++n) {
                this.combL[n].processMix(this.input, fArray2);
            }
            n = 0;
            while (n < n2) {
                f = this.pre1[n] - this.pre2[n];
                float f3 = this.pre3[n];
                int n3 = n;
                fArray2[n3] = fArray2[n3] + (f3 + f);
                int n4 = n++;
                fArray3[n4] = fArray3[n4] + (f3 - f);
            }
        } else {
            if (this.out == null || this.out.length < n2) {
                this.out = new float[n2];
            }
            if (fArray3 != null) {
                if (!this.mix) {
                    Arrays.fill(fArray3, 0.0f);
                }
                this.allpassR[0].processReplace(this.input, this.out);
                for (n = 1; n < this.allpassR.length; ++n) {
                    this.allpassR[n].processReplace(this.out);
                }
                for (n = 0; n < this.combR.length; ++n) {
                    this.combR[n].processMix(this.out, fArray3);
                }
            }
            if (!this.mix) {
                Arrays.fill(fArray2, 0.0f);
            }
            this.allpassL[0].processReplace(this.input, this.out);
            for (n = 1; n < this.allpassL.length; ++n) {
                this.allpassL[n].processReplace(this.out);
            }
            for (n = 0; n < this.combL.length; ++n) {
                this.combL[n].processMix(this.out, fArray2);
            }
        }
        if (bl) {
            this.silent = true;
            for (n = 0; n < n2; ++n) {
                f = fArray2[n];
                if (!((double)f > 1.0E-10) && !((double)f < -1.0E-10)) continue;
                this.silent = false;
                break;
            }
        }
    }

    public void globalParameterControlChange(int[] nArray, long l, long l2) {
        if (nArray.length == 1 && nArray[0] == 129) {
            if (l == 0L) {
                if (l2 == 0L) {
                    this.dirty_roomsize = 1.1f;
                    this.dirty_damp = 5000.0f;
                    this.dirty_predelay = 0.0f;
                    this.dirty_gain = 4.0f;
                    this.dirty = true;
                }
                if (l2 == 1L) {
                    this.dirty_roomsize = 1.3f;
                    this.dirty_damp = 5000.0f;
                    this.dirty_predelay = 0.0f;
                    this.dirty_gain = 3.0f;
                    this.dirty = true;
                }
                if (l2 == 2L) {
                    this.dirty_roomsize = 1.5f;
                    this.dirty_damp = 5000.0f;
                    this.dirty_predelay = 0.0f;
                    this.dirty_gain = 2.0f;
                    this.dirty = true;
                }
                if (l2 == 3L) {
                    this.dirty_roomsize = 1.8f;
                    this.dirty_damp = 24000.0f;
                    this.dirty_predelay = 0.02f;
                    this.dirty_gain = 1.5f;
                    this.dirty = true;
                }
                if (l2 == 4L) {
                    this.dirty_roomsize = 1.8f;
                    this.dirty_damp = 24000.0f;
                    this.dirty_predelay = 0.03f;
                    this.dirty_gain = 1.5f;
                    this.dirty = true;
                }
                if (l2 == 8L) {
                    this.dirty_roomsize = 1.3f;
                    this.dirty_damp = 2500.0f;
                    this.dirty_predelay = 0.0f;
                    this.dirty_gain = 6.0f;
                    this.dirty = true;
                }
            } else if (l == 1L) {
                this.dirty_roomsize = (float)Math.exp((double)(l2 - 40L) * 0.025);
                this.dirty = true;
            }
        }
    }

    public void processControlLogic() {
        if (this.dirty) {
            this.dirty = false;
            this.setRoomSize(this.dirty_roomsize);
            this.setDamp(this.dirty_damp);
            this.setPreDelay(this.dirty_predelay);
            this.setGain(this.dirty_gain);
        }
    }

    public void setRoomSize(float f) {
        this.roomsize = 1.0f - 0.17f / f;
        for (int i = 0; i < this.combL.length; ++i) {
            this.combL[i].feedback = this.roomsize;
            this.combR[i].feedback = this.roomsize;
        }
    }

    public void setPreDelay(float f) {
        this.delay.setDelay((int)(f * this.samplerate));
    }

    public void setGain(float f) {
        this.gain = f;
    }

    public void setDamp(float f) {
        double d = (double)(f / this.samplerate) * (Math.PI * 2);
        double d2 = 2.0 - Math.cos(d);
        this.damp = (float)(d2 - Math.sqrt(d2 * d2 - 1.0));
        if (this.damp > 1.0f) {
            this.damp = 1.0f;
        }
        if (this.damp < 0.0f) {
            this.damp = 0.0f;
        }
        for (int i = 0; i < this.combL.length; ++i) {
            this.combL[i].setDamp(this.damp);
            this.combR[i].setDamp(this.damp);
        }
    }

    public void setLightMode(boolean bl) {
        this.light = bl;
    }

    private static final class AllPass {
        private final float[] delaybuffer;
        private final int delaybuffersize;
        private int rovepos = 0;
        private float feedback;

        public AllPass(int n) {
            this.delaybuffer = new float[n];
            this.delaybuffersize = n;
        }

        public void setFeedBack(float f) {
            this.feedback = f;
        }

        public void processReplace(float[] fArray) {
            int n = fArray.length;
            int n2 = this.delaybuffersize;
            int n3 = this.rovepos;
            for (int i = 0; i < n; ++i) {
                float f = this.delaybuffer[n3];
                float f2 = fArray[i];
                fArray[i] = f - f2;
                this.delaybuffer[n3] = f2 + f * this.feedback;
                if (++n3 != n2) continue;
                n3 = 0;
            }
            this.rovepos = n3;
        }

        public void processReplace(float[] fArray, float[] fArray2) {
            int n = fArray.length;
            int n2 = this.delaybuffersize;
            int n3 = this.rovepos;
            for (int i = 0; i < n; ++i) {
                float f = this.delaybuffer[n3];
                float f2 = fArray[i];
                fArray2[i] = f - f2;
                this.delaybuffer[n3] = f2 + f * this.feedback;
                if (++n3 != n2) continue;
                n3 = 0;
            }
            this.rovepos = n3;
        }
    }

    private static final class Comb {
        private final float[] delaybuffer;
        private final int delaybuffersize;
        private int rovepos = 0;
        private float feedback;
        private float filtertemp = 0.0f;
        private float filtercoeff1 = 0.0f;
        private float filtercoeff2 = 1.0f;

        public Comb(int n) {
            this.delaybuffer = new float[n];
            this.delaybuffersize = n;
        }

        public void setFeedBack(float f) {
            this.feedback = f;
            this.filtercoeff2 = (1.0f - this.filtercoeff1) * f;
        }

        public void processMix(float[] fArray, float[] fArray2) {
            int n = fArray.length;
            int n2 = this.delaybuffersize;
            int n3 = this.rovepos;
            float f = this.filtertemp;
            float f2 = this.filtercoeff1;
            float f3 = this.filtercoeff2;
            for (int i = 0; i < n; ++i) {
                float f4 = this.delaybuffer[n3];
                f = f4 * f3 + f * f2;
                int n4 = i;
                fArray2[n4] = fArray2[n4] + f4;
                this.delaybuffer[n3] = fArray[i] + f;
                if (++n3 != n2) continue;
                n3 = 0;
            }
            this.filtertemp = f;
            this.rovepos = n3;
        }

        public void processReplace(float[] fArray, float[] fArray2) {
            int n = fArray.length;
            int n2 = this.delaybuffersize;
            int n3 = this.rovepos;
            float f = this.filtertemp;
            float f2 = this.filtercoeff1;
            float f3 = this.filtercoeff2;
            for (int i = 0; i < n; ++i) {
                float f4 = this.delaybuffer[n3];
                f = f4 * f3 + f * f2;
                fArray2[i] = f4;
                this.delaybuffer[n3] = fArray[i] + f;
                if (++n3 != n2) continue;
                n3 = 0;
            }
            this.filtertemp = f;
            this.rovepos = n3;
        }

        public void setDamp(float f) {
            this.filtercoeff1 = f;
            this.filtercoeff2 = (1.0f - this.filtercoeff1) * this.feedback;
        }
    }

    private static final class Delay {
        private float[] delaybuffer = null;
        private int rovepos = 0;

        public void setDelay(int n) {
            this.delaybuffer = (float[])(n == 0 ? null : new float[n]);
            this.rovepos = 0;
        }

        public void processReplace(float[] fArray) {
            if (this.delaybuffer == null) {
                return;
            }
            int n = fArray.length;
            int n2 = this.delaybuffer.length;
            int n3 = this.rovepos;
            for (int i = 0; i < n; ++i) {
                float f = fArray[i];
                fArray[i] = this.delaybuffer[n3];
                this.delaybuffer[n3] = f;
                if (++n3 != n2) continue;
                n3 = 0;
            }
            this.rovepos = n3;
        }
    }
}

